/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.netbeans.editor.ext.DataAccessor;

public class FileAccessor
implements DataAccessor {
    private File f;
    private RandomAccessFile file;

    public FileAccessor(File file) {
        this.f = file;
    }

    public void append(byte[] byArray, int n, int n2) throws IOException {
        this.file.write(byArray, n, n2);
    }

    public void read(byte[] byArray, int n, int n2) throws IOException {
        this.file.readFully(byArray, n, n2);
    }

    public void open(boolean bl) throws IOException {
        this.file = new RandomAccessFile(this.f, bl ? "rw" : "r");
        if (!this.f.exists()) {
            this.f.createNewFile();
        }
    }

    public void close() throws IOException {
        if (this.file != null) {
            this.file.close();
        }
    }

    public long getFilePointer() throws IOException {
        return this.file.getFilePointer();
    }

    public void resetFile() throws IOException {
        this.file.setLength(0L);
    }

    public void seek(long l) throws IOException {
        this.file.seek(l);
    }

    public int getFileLength() {
        return (int)this.f.length();
    }

    public String toString() {
        return this.f.getAbsolutePath();
    }
}

