/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.ui.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.hudson.impl.HudsonManagerImpl;
import org.netbeans.modules.hudson.ui.wizard.InstanceDialog;
import org.openide.NotificationLineSupport;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class InstancePropertiesVisual
extends JPanel {
    private NotificationLineSupport msgs;
    private JButton addButton;
    private JCheckBox autoSyncCheckBox;
    private JLabel autoSyncLabel;
    private JSpinner autoSyncSpinner;
    private JProgressBar checkProgress;
    private JLabel nameLabel;
    private JTextField nameTxt;
    private JButton proxyButton;
    private JLabel urlLabel;
    private JTextField urlTxt;

    public InstancePropertiesVisual() {
        this.initComponents();
        DocumentListener documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                InstancePropertiesVisual.this.check();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                InstancePropertiesVisual.this.check();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }
        };
        this.nameTxt.getDocument().addDocumentListener(documentListener);
        this.urlTxt.getDocument().addDocumentListener(documentListener);
        this.checkProgress.setVisible(false);
    }

    void init(NotificationLineSupport notificationLineSupport, JButton jButton) {
        assert (notificationLineSupport != null);
        this.msgs = notificationLineSupport;
        this.addButton = jButton;
        this.check();
    }

    void showChecking() {
        this.checkProgress.setVisible(true);
        this.nameTxt.setEnabled(false);
        this.urlTxt.setEnabled(false);
        this.autoSyncCheckBox.setEnabled(false);
        this.autoSyncSpinner.setEnabled(false);
        this.proxyButton.setEnabled(false);
    }

    void checkFailed(String string) {
        this.msgs.setErrorMessage(string);
        this.checkProgress.setVisible(false);
        this.nameTxt.setEnabled(true);
        this.urlTxt.setEnabled(true);
        this.autoSyncCheckBox.setEnabled(true);
        this.autoSyncSpinner.setEnabled(this.autoSyncCheckBox.isSelected());
        this.proxyButton.setEnabled(true);
        this.urlTxt.requestFocusInWindow();
    }

    String getDisplayName() {
        return this.nameTxt.getText().trim();
    }

    String getUrl() {
        return this.urlTxt.getText().trim();
    }

    int getSyncTime() {
        return this.autoSyncCheckBox.isSelected() ? (Integer)this.autoSyncSpinner.getValue() : 0;
    }

    private void initComponents() {
        this.nameLabel = new JLabel();
        this.nameTxt = new JTextField();
        this.urlLabel = new JLabel();
        this.urlTxt = new JTextField();
        this.autoSyncCheckBox = new JCheckBox();
        this.autoSyncSpinner = new JSpinner();
        this.autoSyncLabel = new JLabel();
        this.proxyButton = new JButton();
        this.checkProgress = new JProgressBar();
        this.nameLabel.setLabelFor(this.nameTxt);
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(InstancePropertiesVisual.class, (String)"LBL_Name"));
        this.urlLabel.setLabelFor(this.urlTxt);
        Mnemonics.setLocalizedText((JLabel)this.urlLabel, (String)NbBundle.getMessage(InstancePropertiesVisual.class, (String)"LBL_Url"));
        this.urlTxt.setText(NbBundle.getMessage(InstancePropertiesVisual.class, (String)"InstancePropertiesVisual.urlTxt.text"));
        this.autoSyncCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.autoSyncCheckBox, (String)NbBundle.getMessage(InstancePropertiesVisual.class, (String)"LBL_AutoSync"));
        this.autoSyncCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.autoSyncCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InstancePropertiesVisual.this.autoSyncCheckBoxActionPerformed(actionEvent);
            }
        });
        this.autoSyncSpinner.setModel(new SpinnerNumberModel((Number)5, Integer.valueOf(1), null, (Number)1));
        this.autoSyncSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                InstancePropertiesVisual.this.autoSyncSpinnerStateChanged(changeEvent);
            }
        });
        this.autoSyncLabel.setLabelFor(this.autoSyncSpinner);
        Mnemonics.setLocalizedText((JLabel)this.autoSyncLabel, (String)NbBundle.getMessage(InstancePropertiesVisual.class, (String)"LBL_AutoSyncMinutes"));
        Mnemonics.setLocalizedText((AbstractButton)this.proxyButton, (String)NbBundle.getMessage(InstancePropertiesVisual.class, (String)"LBL_Proxy"));
        this.proxyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InstancePropertiesVisual.this.proxyButtonActionPerformed(actionEvent);
            }
        });
        this.checkProgress.setIndeterminate(true);
        this.checkProgress.setString(NbBundle.getMessage(InstancePropertiesVisual.class, (String)"InstancePropertiesVisual.checkProgress.string"));
        this.checkProgress.setStringPainted(true);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.checkProgress, -1, 432, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.autoSyncCheckBox).addPreferredGap(0).add((Component)this.autoSyncSpinner, -2, 45, -2).addPreferredGap(0).add((Component)this.autoSyncLabel)).add((Component)this.proxyButton).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.nameLabel).add((Component)this.urlLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.urlTxt, -1, 382, Short.MAX_VALUE).add((Component)this.nameTxt, -1, 382, Short.MAX_VALUE)))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.nameLabel).add((Component)this.nameTxt, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.urlLabel).add((Component)this.urlTxt, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.autoSyncCheckBox).add((Component)this.autoSyncSpinner, -2, -1, -2).add((Component)this.autoSyncLabel)).addPreferredGap(1).add((Component)this.proxyButton).addPreferredGap(1).add((Component)this.checkProgress, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.nameTxt.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstancePropertiesVisual.class, (String)"InstancePropertiesVisual.nameTxt.AccessibleContext.accessibleDescription"));
        this.urlTxt.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstancePropertiesVisual.class, (String)"InstancePropertiesVisual.urlTxt.AccessibleContext.accessibleDescription"));
        this.autoSyncCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstancePropertiesVisual.class, (String)"InstancePropertiesVisual.autoSyncCheckBox.AccessibleContext.accessibleDescription"));
        this.autoSyncSpinner.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstancePropertiesVisual.class, (String)"InstancePropertiesVisual.autoSyncSpinner.AccessibleContext.accessibleDescription"));
        this.proxyButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstancePropertiesVisual.class, (String)"InstancePropertiesVisual.proxyButton.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstancePropertiesVisual.class, (String)"InstancePropertiesVisual.AccessibleContext.accessibleDescription"));
    }

    private void proxyButtonActionPerformed(ActionEvent actionEvent) {
        OptionsDisplayer.getDefault().open("General");
    }

    private void autoSyncSpinnerStateChanged(ChangeEvent changeEvent) {
        this.check();
    }

    private void autoSyncCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.autoSyncSpinner.setEnabled(this.autoSyncCheckBox.isSelected());
        this.check();
    }

    private void check() {
        this.addButton.setEnabled(false);
        String string = this.getDisplayName();
        String string2 = this.getUrl();
        if (string.length() == 0) {
            this.msgs.setInformationMessage(NbBundle.getMessage(InstanceDialog.class, (String)"MSG_EmptyName"));
            return;
        }
        if (HudsonManagerImpl.getDefault().getInstanceByName(string) != null) {
            this.msgs.setErrorMessage(NbBundle.getMessage(InstanceDialog.class, (String)"MSG_ExistName"));
            return;
        }
        if (string2.length() == 0 || string2.endsWith("//")) {
            this.msgs.setInformationMessage(NbBundle.getMessage(InstanceDialog.class, (String)"MSG_EmptyUrl"));
            return;
        }
        if (!string2.endsWith("/")) {
            this.msgs.setInformationMessage(NbBundle.getMessage(InstancePropertiesVisual.class, (String)"InstanceDialog.end_with_slash"));
            return;
        }
        try {
            URL uRL = new URL(string2);
            if (!uRL.getProtocol().matches("https?")) {
                this.msgs.setErrorMessage(NbBundle.getMessage(InstancePropertiesVisual.class, (String)"InstanceDialog.http_protocol"));
                return;
            }
        }
        catch (MalformedURLException malformedURLException) {
            this.msgs.setErrorMessage(malformedURLException.getLocalizedMessage());
            return;
        }
        if (HudsonManagerImpl.getDefault().getInstance(string2) != null) {
            this.msgs.setErrorMessage(NbBundle.getMessage(InstanceDialog.class, (String)"MSG_ExistUrl"));
            return;
        }
        this.msgs.clearMessages();
        this.addButton.setEnabled(true);
    }
}

