/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsstack.api;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WSStackVersion
implements Comparable<WSStackVersion> {
    private final int major;
    private final int minor;
    private final int micro;
    private final int update;

    private WSStackVersion(int n, int n2, int n3, int n4) {
        this.major = n;
        this.minor = n2;
        this.micro = n3;
        this.update = n4;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMicro() {
        return this.micro;
    }

    public int getUpdate() {
        return this.update;
    }

    public static WSStackVersion valueOf(int n, int n2, int n3, int n4) {
        if (n < 0 || n2 < 0 || n3 < 0 || n4 < 0) {
            throw new IllegalArgumentException("Negative version number");
        }
        return new WSStackVersion(n, n2, n3, n4);
    }

    @Override
    public int compareTo(WSStackVersion wSStackVersion) {
        if (wSStackVersion == null) {
            throw new IllegalArgumentException("Cannot pass null as parameter of WSStackVersion.compareTo(WSStackVersion)");
        }
        if (this == wSStackVersion) {
            return 0;
        }
        int n = this.major - wSStackVersion.major;
        if (n != 0) {
            return n / Math.abs(n);
        }
        n = this.minor - wSStackVersion.minor;
        if (n != 0) {
            return n / Math.abs(n);
        }
        n = this.micro - wSStackVersion.micro;
        if (n != 0) {
            return n / Math.abs(n);
        }
        n = this.update - wSStackVersion.update;
        if (n != 0) {
            return n / Math.abs(n);
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        WSStackVersion wSStackVersion = (WSStackVersion)object;
        return this.major == wSStackVersion.major && this.minor == wSStackVersion.minor && this.micro == wSStackVersion.micro && this.update == wSStackVersion.update;
    }

    public int hashCode() {
        int n = 7;
        n = 73 * n + this.major;
        n = 73 * n + this.minor;
        n = 73 * n + this.micro;
        n = 73 * n + this.update;
        return n;
    }

    public String toString() {
        return String.valueOf(this.major) + "." + String.valueOf(this.minor) + "." + String.valueOf(this.micro) + "." + String.valueOf(this.update);
    }
}

