/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Util {
    public static Set<String> allMimeTypes;
    private static final Logger LOG;

    public static Set<String> getAllMimeTypes() {
        return allMimeTypes != null ? allMimeTypes : EditorSettings.getDefault().getAllMimeTypes();
    }

    public static boolean canBeParsed(String string) {
        if (string == null || "content/unknown".equals(string) || !Util.getAllMimeTypes().contains(string)) {
            return false;
        }
        int n = string.indexOf(47);
        assert (n != -1) : "Invalid mimetype: '" + string + "'";
        String string2 = string.substring(0, n);
        return !(string2.equals("application") ? !string.equals("application/x-httpd-eruby") && !string.equals("application/xml-dtd") : !string2.equals("text"));
    }

    public static StackTraceElement findCaller(StackTraceElement[] stackTraceElementArray, Object ... objectArray) {
        block0: for (StackTraceElement stackTraceElement : stackTraceElementArray) {
            if (stackTraceElement.getClassName().equals(Util.class.getName()) || stackTraceElement.getClassName().startsWith("java.lang.")) continue;
            if (objectArray != null && objectArray.length > 0) {
                for (Object object : objectArray) {
                    if (object instanceof Class && stackTraceElement.getClassName().startsWith(((Class)object).getName()) || object instanceof String && stackTraceElement.getClassName().startsWith((String)object)) continue block0;
                }
            } else if (stackTraceElement.getClassName().startsWith("org.netbeans.modules.parsing.")) continue;
            return stackTraceElement;
        }
        return null;
    }

    public static URL resolveUrl(URL uRL, String string) throws MalformedURLException {
        try {
            if ("file".equals(uRL.getProtocol())) {
                return new File(new File(uRL.toURI()), string).toURI().toURL();
            }
            return new URL(uRL, string);
        }
        catch (URISyntaxException uRISyntaxException) {
            MalformedURLException malformedURLException = new MalformedURLException("Can't resolve URL: root=" + uRL + ", relativePath=" + string);
            malformedURLException.initCause(uRISyntaxException);
            throw malformedURLException;
        }
    }

    public static boolean containsAny(Collection<? extends String> collection, Collection<? extends String> collection2) {
        if (collection != null && collection2 != null) {
            for (String string : collection2) {
                if (!collection.contains(string)) continue;
                return true;
            }
        }
        return false;
    }

    public static FileObject getFileObject(Document document) {
        Object object = document.getProperty("stream");
        if (object instanceof FileObject) {
            return (FileObject)object;
        }
        if (object instanceof DataObject) {
            return ((DataObject)object).getPrimaryFile();
        }
        return null;
    }

    private Util() {
    }

    static {
        LOG = Logger.getLogger(Util.class.getName());
    }
}

