/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.navigation.includeview;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.navigation.includeview.IncludeNode;
import org.netbeans.modules.cnd.navigation.services.IncludedModel;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncludedChildren
extends Children.Keys<CsmFile> {
    private static Comparator<CsmFile> COMARATOR = new MyComparator();
    private CsmFile object;
    private IncludedChildren parent;
    private IncludedModel model;
    private boolean isInited = false;

    public IncludedChildren(CsmFile csmFile, IncludedModel includedModel, IncludedChildren includedChildren) {
        this.object = csmFile;
        this.parent = includedChildren;
        this.model = includedModel;
    }

    public void dispose() {
        if (this.isInited) {
            this.isInited = false;
            this.setKeys(new CsmFile[0]);
        }
    }

    private synchronized void resetKeys() {
        Set<CsmFile> set;
        if (this.object.isValid() && (set = this.model.getModel().get(this.object)) != null && set.size() > 0) {
            ArrayList<CsmFile> arrayList = new ArrayList<CsmFile>(set);
            Collections.sort(arrayList, COMARATOR);
            this.setKeys(arrayList);
            return;
        }
        this.setKeys(new CsmFile[0]);
    }

    protected Node[] createNodes(CsmFile csmFile) {
        IncludeNode includeNode = null;
        Set<CsmFile> set = this.model.getModel().get(csmFile);
        includeNode = set == null || set.size() == 0 ? new IncludeNode(csmFile, Children.LEAF, this.model, false) : (this.checkRecursion(csmFile) ? new IncludeNode(csmFile, Children.LEAF, this.model, true) : new IncludeNode(csmFile, this.model, this));
        return new Node[]{includeNode};
    }

    private boolean checkRecursion(CsmFile csmFile) {
        if (csmFile.equals(this.object)) {
            return true;
        }
        IncludedChildren includedChildren = this.parent;
        while (includedChildren != null) {
            if (csmFile.equals(includedChildren.object)) {
                return true;
            }
            includedChildren = includedChildren.parent;
        }
        return false;
    }

    protected void addNotify() {
        this.isInited = true;
        this.resetKeys();
        super.addNotify();
    }

    protected void removeNotify() {
        super.removeNotify();
        this.dispose();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyComparator
    implements Comparator<CsmFile> {
        private MyComparator() {
        }

        @Override
        public int compare(CsmFile csmFile, CsmFile csmFile2) {
            String string = ((Object)csmFile.getName()).toString();
            String string2 = ((Object)csmFile2.getName()).toString();
            return string.compareTo(string2);
        }
    }
}

