/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.query;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.RepositoriesSupport;
import org.netbeans.modules.bugtracking.spi.BugtrackingController;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.Query;
import org.netbeans.modules.bugtracking.spi.QueryNotifyListener;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.ui.query.QueryAccessor;
import org.netbeans.modules.bugtracking.ui.query.QueryAction;
import org.netbeans.modules.bugtracking.util.BugtrackingOwnerSupport;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.bugtracking.util.LinkButton;
import org.netbeans.modules.bugtracking.util.RepositoryComboSupport;
import org.netbeans.modules.kenai.api.Kenai;
import org.openide.awt.Mnemonics;
import org.openide.nodes.Node;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class QueryTopComponent
extends TopComponent
implements PropertyChangeListener,
QueryNotifyListener,
FocusListener {
    private static QueryTopComponent instance;
    private static Set<QueryTopComponent> openQueries;
    private Query[] savedQueries = null;
    private static final String PREFERRED_ID = "QueryTopComponent";
    private Query query;
    private static final Object LOCK;
    private RequestProcessor rp = new RequestProcessor("Bugtracking query", 1, true);
    private RequestProcessor.Task prepareTask;
    private RepositoryComboSupport rs;
    private Node[] context;
    private JLabel findIssuesLabel;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private LinkButton newButton;
    private JPanel panel;
    private JPanel queriesPanel;
    private JLabel repoLabel;
    private JPanel repoPanel;
    private JComboBox repositoryComboBox;
    private JScrollPane scrollPane;

    QueryTopComponent() {
        RepositoriesSupport.getInstance().addPropertyChangeListener(this);
        this.initComponents();
        Font font = new JLabel().getFont();
        int n = font.getSize();
        this.findIssuesLabel.setFont(this.repoLabel.getFont().deriveFont((float)n * 1.7f));
        int n2 = (int)((double)n * 1.5);
        this.scrollPane.getHorizontalScrollBar().setUnitIncrement(n2);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(n2);
    }

    public static Set<QueryTopComponent> getOpenQueries() {
        return openQueries;
    }

    private Query getQuery() {
        return this.query;
    }

    void init(Query query, Repository repository, Node[] nodeArray, boolean bl) {
        this.query = query;
        this.context = nodeArray;
        this.setNameAndTooltip();
        if (bl) {
            this.repositoryComboBox.setEnabled(false);
            this.newButton.setEnabled(false);
        }
        if (query != null) {
            this.setSaved();
            BugtrackingController bugtrackingController = query.getController();
            this.panel.add(bugtrackingController.getComponent());
            this.query.addPropertyChangeListener(this);
            this.query.addNotifyListener(this);
        } else {
            this.newButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    QueryTopComponent.this.onNewClick();
                }
            });
            this.repositoryComboBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    Object object;
                    if (itemEvent.getStateChange() == 1) {
                        Object object2 = itemEvent.getItem();
                        if (object2 instanceof Repository) {
                            QueryTopComponent.this.onRepoSelected();
                        }
                    } else if (itemEvent.getStateChange() == 2 && (object = itemEvent.getItem()) instanceof Repository) {
                        ((Repository)object).removePropertyChangeListener(QueryTopComponent.this);
                    }
                }
            });
            this.rs = repository == null ? RepositoryComboSupport.setup((JComponent)((Object)this), this.repositoryComboBox, true) : RepositoryComboSupport.setup((JComponent)((Object)this), this.repositoryComboBox, repository);
            this.newButton.addFocusListener(this);
            this.repositoryComboBox.addFocusListener(this);
            this.queriesPanel.setVisible(false);
        }
        BugtrackingUtil.logBugtrackingUsage(query != null ? query.getRepository() : repository, "ISSUE_QUERY");
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.jPanel2 = new JPanel();
        this.panel = new JPanel();
        this.repoPanel = new JPanel();
        this.repositoryComboBox = new JComboBox();
        this.queriesPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.findIssuesLabel = new JLabel();
        this.repoLabel = new JLabel();
        this.jPanel1 = new JPanel();
        this.newButton = new LinkButton();
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                QueryTopComponent.this.formComponentResized(componentEvent);
            }
        });
        this.scrollPane.setBorder(null);
        this.jPanel2.setBackground(UIManager.getDefaults().getColor("EditorPane.background"));
        this.panel.setBackground(UIManager.getDefaults().getColor("EditorPane.background"));
        this.panel.setOpaque(false);
        this.panel.setLayout(new BorderLayout());
        this.repoPanel.setBackground(UIManager.getDefaults().getColor("EditorPane.background"));
        this.repoPanel.setNextFocusableComponent(this.newButton);
        this.queriesPanel.setBackground(new Color(224, 224, 224));
        this.queriesPanel.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                QueryTopComponent.this.queriesPanelComponentResized(componentEvent);
            }
        });
        this.queriesPanel.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(QueryTopComponent.class, (String)"QueryTopComponent.jLabel1.text_1"));
        this.queriesPanel.add((Component)this.jLabel1, "Before");
        Mnemonics.setLocalizedText((JLabel)this.findIssuesLabel, (String)NbBundle.getMessage(QueryTopComponent.class, (String)"QueryTopComponent.findIssuesLabel.text"));
        this.repoLabel.setLabelFor(this.repositoryComboBox);
        Mnemonics.setLocalizedText((JLabel)this.repoLabel, (String)NbBundle.getMessage(QueryTopComponent.class, (String)"QueryTopComponent.repoLabel.text"));
        this.repoLabel.setFocusCycleRoot(true);
        this.jPanel1.setOpaque(false);
        GroupLayout groupLayout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 64, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 8, Short.MAX_VALUE));
        Mnemonics.setLocalizedText((AbstractButton)this.newButton, (String)NbBundle.getMessage(QueryTopComponent.class, (String)"QueryTopComponent.newButton.text_1"));
        GroupLayout groupLayout2 = new GroupLayout((Container)this.repoPanel);
        this.repoPanel.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.repoLabel).addPreferredGap(0).add((Component)this.repositoryComboBox, -2, -1, -2).addPreferredGap(0).add((Component)this.newButton, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(0).add((Component)this.queriesPanel, -1, -1, Short.MAX_VALUE)).add((Component)this.findIssuesLabel));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add(13, 13, 13).add((Component)this.findIssuesLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.repoLabel).add((Component)this.repositoryComboBox, -2, -1, -2).add((Component)this.newButton, -2, -1, -2))).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add(42, 42, 42).add((GroupLayout.Group)groupLayout2.createParallelGroup(2).add((Component)this.queriesPanel, -2, -1, -2).add((Component)this.jPanel1, -2, -1, -2))));
        this.repositoryComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(QueryTopComponent.class, (String)"QueryTopComponent.repositoryComboBox.AccessibleContext.accessibleDescription"));
        this.newButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(QueryTopComponent.class, (String)"QueryTopComponent.newButton.AccessibleContext.accessibleDescription"));
        GroupLayout groupLayout3 = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)this.panel, -1, 295, Short.MAX_VALUE).add(2, (GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((Component)this.repoPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((Component)this.repoPanel, -2, -1, -2).add(14, 14, 14).add((Component)this.panel, -1, -1, Short.MAX_VALUE)));
        this.scrollPane.setViewportView(this.jPanel2);
        GroupLayout groupLayout4 = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)groupLayout4);
        groupLayout4.setHorizontalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((Component)this.scrollPane));
        groupLayout4.setVerticalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((Component)this.scrollPane));
    }

    private void queriesPanelComponentResized(ComponentEvent componentEvent) {
    }

    private void formComponentResized(ComponentEvent componentEvent) {
        this.updateSavedQueriesPanel();
    }

    public static synchronized QueryTopComponent getDefault() {
        if (instance == null) {
            instance = new QueryTopComponent();
        }
        return instance;
    }

    public static synchronized QueryTopComponent findInstance() {
        TopComponent topComponent = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (topComponent == null) {
            Logger.getLogger(QueryTopComponent.class.getName()).warning("Cannot find QueryTopComponent component. It will not be located properly in the window system.");
            return QueryTopComponent.getDefault();
        }
        if (topComponent instanceof QueryTopComponent) {
            return (QueryTopComponent)topComponent;
        }
        Logger.getLogger(QueryTopComponent.class.getName()).warning("There seem to be multiple components with the 'QueryTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return QueryTopComponent.getDefault();
    }

    public static synchronized QueryTopComponent find(Query query) {
        for (QueryTopComponent queryTopComponent : openQueries) {
            if (!query.equals(queryTopComponent.getQuery())) continue;
            return queryTopComponent;
        }
        return null;
    }

    public int getPersistenceType() {
        return 2;
    }

    public void componentOpened() {
        openQueries.add(this);
        Kenai.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
        if (this.query != null) {
            this.query.getController().opened();
        }
        BugtrackingManager.LOG.log(Level.FINE, "{0} - {1} opened", new Object[]{this.getClass().getName(), this.query != null ? this.query.getDisplayName() : null});
    }

    public void componentClosed() {
        openQueries.remove(this);
        if (this.query != null) {
            this.query.removePropertyChangeListener(this);
            this.query.removeNotifyListener(this);
            this.query.getController().closed();
        }
        Kenai.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
        if (this.prepareTask != null) {
            this.prepareTask.cancel();
        }
        BugtrackingManager.LOG.log(Level.FINE, "{0} - {1} closed", new Object[]{this.getClass().getName(), this.query != null ? this.query.getDisplayName() : null});
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return this.query != null && this.query.getDisplayName() != null ? this.query.getDisplayName() : PREFERRED_ID;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("bugtracking.query.saved")) {
            this.setSaved();
        } else if (propertyChangeEvent.getPropertyName().equals("bugtracking.query.removed")) {
            if (this.query != null && propertyChangeEvent.getSource() == this.query) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        QueryTopComponent.this.close();
                    }
                });
            }
        } else if (propertyChangeEvent.getPropertyName().equals("bugtracking.repository.queries.changed")) {
            this.updateSavedQueries();
        } else if (propertyChangeEvent.getPropertyName().equals("bugtracking.repositories.changed")) {
            if (!this.repositoryComboBox.isEnabled()) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (QueryTopComponent.this.rs != null) {
                        QueryTopComponent.this.rs.refreshRepositoryModel();
                    }
                }
            });
        }
    }

    @Override
    public void started() {
        assert (this.query != null);
        if (this.query == null) {
            return;
        }
        assert (this.query.getRepository() != null);
        BugtrackingOwnerSupport.getInstance().setLooseAssociation(BugtrackingOwnerSupport.ContextType.SELECTED_FILE_AND_ALL_PROJECTS, this.query.getRepository());
    }

    @Override
    public void notifyData(Issue issue) {
    }

    @Override
    public void finished() {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        Component component = focusEvent.getComponent();
        if (component instanceof JComponent) {
            Point point = SwingUtilities.convertPoint(component.getParent(), component.getLocation(), this.repoPanel);
            final Rectangle rectangle = new Rectangle(point, component.getSize());
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    QueryTopComponent.this.repoPanel.scrollRectToVisible(rectangle);
                }
            });
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    private void onNewClick() {
        Repository repository = BugtrackingUtil.createRepository();
        if (repository != null) {
            this.repositoryComboBox.addItem(repository);
            this.repositoryComboBox.setSelectedItem(repository);
        }
    }

    private void onRepoSelected() {
        if (this.prepareTask != null) {
            this.prepareTask.cancel();
        }
        Cancellable cancellable = new Cancellable(){

            public boolean cancel() {
                if (QueryTopComponent.this.prepareTask != null) {
                    QueryTopComponent.this.prepareTask.cancel();
                }
                return true;
            }
        };
        final ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(QueryTopComponent.class, (String)"CTL_PreparingQuery"), (Cancellable)cancellable);
        this.prepareTask = this.rp.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    BugtrackingController bugtrackingController;
                    progressHandle.start();
                    Repository repository = QueryTopComponent.this.getRepository();
                    if (repository == null) {
                        return;
                    }
                    repository.addPropertyChangeListener(QueryTopComponent.this);
                    BugtrackingController bugtrackingController2 = bugtrackingController = QueryTopComponent.this.query != null ? QueryTopComponent.this.query.getController() : null;
                    if (QueryTopComponent.this.query != null) {
                        QueryTopComponent.this.query.removePropertyChangeListener(QueryTopComponent.this);
                        QueryTopComponent.this.query.removeNotifyListener(QueryTopComponent.this);
                    }
                    QueryTopComponent.this.query = repository.createQuery();
                    if (QueryTopComponent.this.query == null) {
                        return;
                    }
                    QueryAccessor.getInstance().setSelection(QueryTopComponent.this.query, QueryTopComponent.this.context);
                    QueryTopComponent.this.query.addPropertyChangeListener(QueryTopComponent.this);
                    QueryTopComponent.this.query.addNotifyListener(QueryTopComponent.this);
                    QueryTopComponent.this.updateSavedQueriesIntern(repository);
                    final BugtrackingController bugtrackingController3 = QueryTopComponent.this.query.getController();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (bugtrackingController != null) {
                                QueryTopComponent.this.panel.remove(bugtrackingController.getComponent());
                            }
                            QueryTopComponent.this.panel.add(bugtrackingController3.getComponent());
                            QueryTopComponent.this.panel.revalidate();
                            QueryTopComponent.this.panel.repaint();
                            QueryTopComponent.this.focusFirstEnabledComponent();
                        }
                    });
                }
                finally {
                    progressHandle.finish();
                    QueryTopComponent.this.prepareTask = null;
                }
            }
        });
    }

    private Repository getRepository() {
        Object object = this.repositoryComboBox.getSelectedItem();
        if (object == null || !(object instanceof Repository)) {
            return null;
        }
        return (Repository)object;
    }

    private void focusFirstEnabledComponent() {
        this.repositoryComboBox.requestFocusInWindow();
        if (!this.repositoryComboBox.isEnabled()) {
            this.newButton.requestFocusInWindow();
            if (!this.newButton.isEnabled()) {
                this.newButton.transferFocus();
            }
        }
    }

    private void setNameAndTooltip() throws MissingResourceException {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (QueryTopComponent.this.query != null && QueryTopComponent.this.query.getDisplayName() != null) {
                    QueryTopComponent.this.setName(NbBundle.getMessage(QueryTopComponent.class, (String)"LBL_QueryName", (Object[])new Object[]{QueryTopComponent.this.query.getRepository().getDisplayName(), QueryTopComponent.this.query.getDisplayName()}));
                    QueryTopComponent.this.setToolTipText(NbBundle.getMessage(QueryTopComponent.class, (String)"LBL_QueryName", (Object[])new Object[]{QueryTopComponent.this.query.getRepository().getDisplayName(), QueryTopComponent.this.query.getTooltip()}));
                } else {
                    QueryTopComponent.this.setName(NbBundle.getMessage(QueryTopComponent.class, (String)"CTL_QueryTopComponent"));
                    QueryTopComponent.this.setToolTipText(NbBundle.getMessage(QueryTopComponent.class, (String)"HINT_QueryTopComponent"));
                }
            }
        });
    }

    private void setSaved() {
        this.repoPanel.setVisible(false);
        this.setNameAndTooltip();
    }

    public void updateSavedQueries() {
        final Repository repository = this.getRepository();
        if (repository == null) {
            return;
        }
        this.rp.post(new Runnable(){

            public void run() {
                QueryTopComponent.this.updateSavedQueriesIntern(repository);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSavedQueriesIntern(Repository repository) {
        if (repository == null) {
            return;
        }
        BugtrackingManager.LOG.log(Level.FINE, "updateSavedQueries for {0} start", new Object[]{repository.getDisplayName()});
        Query[] queryArray = LOCK;
        synchronized (LOCK) {
            if (this.savedQueries != null) {
                for (Query i : this.savedQueries) {
                    i.removePropertyChangeListener(this);
                }
            }
            // ** MonitorExit[queryArray] (shouldn't be in output)
            queryArray = repository.getQueries();
            Object object = LOCK;
            synchronized (object) {
                this.savedQueries = queryArray;
                if (this.savedQueries == null || this.savedQueries.length == 0) {
                    this.queriesPanel.setVisible(false);
                    BugtrackingManager.LOG.log(Level.FINE, "updateSavedQueries for {0} finnished. No queries.", new Object[]{repository.getDisplayName()});
                    return;
                }
                this.queriesPanel.setVisible(true);
                Component[] componentArray = this.queriesPanel.getComponents();
                for (Component component : componentArray) {
                    if (!(component instanceof QueryButton) && !(component instanceof JSeparator)) continue;
                    this.queriesPanel.remove(component);
                }
                this.queriesPanel.setLayout(new GroupieFlowLayout(0));
                Object object2 = null;
                Arrays.sort(this.savedQueries);
                for (int i = 0; i < this.savedQueries.length; ++i) {
                    Component component;
                    Query query = this.savedQueries[i];
                    query.addPropertyChangeListener(this);
                    object2 = new QueryButton(repository, query);
                    ((Component)object2).addFocusListener(this);
                    ((AbstractButton)object2).setText(query.getDisplayName());
                    this.queriesPanel.add((Component)object2);
                    if (i >= this.savedQueries.length - 1) continue;
                    component = new JSeparator();
                    ((JSeparator)component).setOrientation(1);
                    ((JComponent)component).setPreferredSize(new Dimension(2, ((JComponent)object2).getPreferredSize().height));
                    ((JComponent)component).setBorder(new LineBorder(Color.BLACK, 1));
                    this.queriesPanel.add(component);
                }
                this.updateSavedQueriesPanel();
                BugtrackingManager.LOG.log(Level.FINE, "updateSavedQueries for {0} finnished. {1} saved queries.", new Object[]{repository.getDisplayName(), this.savedQueries.length});
            }
            return;
        }
    }

    private void updateSavedQueriesPanel() {
        LayoutManager layoutManager = this.queriesPanel.getLayout();
        if (layoutManager instanceof GroupieFlowLayout) {
            GroupieFlowLayout groupieFlowLayout = (GroupieFlowLayout)layoutManager;
            int n = groupieFlowLayout.getHeight(this.queriesPanel);
            if (n == 0) {
                return;
            }
            this.queriesPanel.revalidate();
            Dimension dimension = this.queriesPanel.getSize();
            dimension.height = n;
            this.queriesPanel.setSize(dimension);
            dimension = this.queriesPanel.getPreferredSize();
            dimension.height = n;
            this.queriesPanel.setPreferredSize(dimension);
            this.queriesPanel.revalidate();
            this.queriesPanel.repaint();
        }
    }

    public boolean requestFocusInWindow() {
        return this.jPanel2.requestFocusInWindow();
    }

    static {
        openQueries = new HashSet<QueryTopComponent>();
        LOCK = new Object();
    }

    private class QueryButton
    extends LinkButton {
        public QueryButton(final Repository repository, final Query query) {
            this.setText(query.getDisplayName());
            this.getAccessibleContext().setAccessibleDescription(query.getTooltip());
            this.setAction(new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    QueryAction.openQuery(query, repository);
                }
            });
        }
    }

    public class GroupieFlowLayout
    extends FlowLayout {
        public GroupieFlowLayout(int n) {
            super(n);
        }

        public Dimension minimumLayoutSize(Container container) {
            Dimension dimension = super.minimumLayoutSize(container);
            dimension.width = 0;
            return dimension;
        }

        public int getHeight(Container container) {
            if (container.getWidth() == 0) {
                return 0;
            }
            Insets insets = container.getInsets();
            int n = container.getWidth() - (insets.left + insets.right + this.getHgap() * 2);
            int n2 = container.getComponentCount();
            int n3 = 0;
            int n4 = insets.top + this.getVgap();
            int n5 = 0;
            for (int i = 0; i < n2; ++i) {
                Component component = container.getComponent(i);
                if (!component.isVisible()) continue;
                Dimension dimension = component.getPreferredSize();
                component.setSize(dimension.width, dimension.height);
                if (n3 == 0 || n3 + dimension.width <= n) {
                    if (n3 > 0) {
                        n3 += this.getHgap();
                    }
                    n3 += dimension.width;
                    n5 = Math.max(n5, dimension.height);
                    continue;
                }
                n3 = dimension.width;
                n4 += this.getVgap() + n5;
                n5 = dimension.height;
            }
            return n4 + n5 + this.getVgap();
        }
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return QueryTopComponent.getDefault();
        }
    }
}

