/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.navigation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.beans.PropertyVetoException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import org.netbeans.modules.csl.api.StructureItem;
import org.netbeans.modules.csl.api.StructureScanner;
import org.netbeans.modules.csl.core.Language;
import org.netbeans.modules.csl.core.LanguageRegistry;
import org.netbeans.modules.csl.navigation.ClassMemberFilters;
import org.netbeans.modules.csl.navigation.ElementNode;
import org.netbeans.modules.csl.navigation.ElementScanningTask;
import org.netbeans.modules.csl.navigation.actions.FilterSubmenuAction;
import org.netbeans.modules.csl.navigation.actions.SortActionSupport;
import org.netbeans.modules.csl.navigation.base.FiltersManager;
import org.netbeans.modules.csl.navigation.base.TapPanel;
import org.netbeans.modules.csl.spi.ParserResult;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ClassMemberPanelUI
extends JPanel
implements ExplorerManager.Provider,
FiltersManager.FilterChangeListener {
    private ExplorerManager manager = new ExplorerManager();
    private MyBeanTreeView elementView;
    private TapPanel filtersPanel;
    private JLabel filtersLbl;
    private Lookup lookup = null;
    private ClassMemberFilters filters;
    private Action[] actions;

    public ClassMemberPanelUI(Language language) {
        StructureScanner structureScanner;
        StructureScanner.Configuration configuration;
        this.initComponents();
        this.elementView = this.createBeanTreeView();
        this.add((Component)((Object)this.elementView), "Center");
        this.filtersPanel = new TapPanel();
        this.filtersLbl = new JLabel(NbBundle.getMessage(ClassMemberPanelUI.class, (String)"LBL_Filter"));
        this.filtersLbl.setBorder(new EmptyBorder(0, 5, 5, 0));
        this.filtersPanel.add(this.filtersLbl);
        this.filtersPanel.setOrientation(2);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(84, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        String string = Utilities.keyToString((KeyStroke)keyStroke);
        this.filtersPanel.setToolTipText(NbBundle.getMessage(ClassMemberPanelUI.class, (String)"TIP_TapPanel", (Object)string));
        this.filters = new ClassMemberFilters(this);
        this.filters.getInstance().hookChangeListener(this);
        this.filtersPanel.add(this.filters.getComponent());
        this.actions = new Action[]{new SortActionSupport.SortByNameAction(this.filters), new SortActionSupport.SortBySourceAction(this.filters), null, new FilterSubmenuAction(this.filters.getInstance())};
        boolean bl = true;
        if (language != null && language.getStructure() != null && (configuration = (structureScanner = language.getStructure()).getConfiguration()) != null && !(bl = configuration.isFilterable())) {
            this.filters.disableFiltering = true;
        }
        if (bl) {
            this.add((Component)this.filtersPanel, "South");
        }
        this.manager.setRootContext(ElementNode.getWaitNode());
    }

    public boolean requestFocusInWindow() {
        boolean bl = super.requestFocusInWindow();
        this.elementView.requestFocusInWindow();
        return bl;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public ElementScanningTask getTask() {
        return new ElementScanningTask(this);
    }

    public void showWaitNode() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ClassMemberPanelUI.this.elementView.setRootVisible(true);
                ClassMemberPanelUI.this.manager.setRootContext(ElementNode.getWaitNode());
            }
        });
    }

    public void selectElementNode(final ParserResult parserResult, final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ElementNode elementNode = ClassMemberPanelUI.this.getRootNode();
                if (elementNode == null) {
                    return;
                }
                ElementNode elementNode2 = elementNode.getMimeRootNodeForOffset(parserResult, n);
                Node[] nodeArray = ClassMemberPanelUI.this.manager.getSelectedNodes();
                if (nodeArray == null || nodeArray.length != 1 || nodeArray[0] != elementNode2) {
                    try {
                        ClassMemberPanelUI.this.manager.setSelectedNodes(new Node[]{elementNode2 == null ? ClassMemberPanelUI.this.getRootNode() : elementNode2});
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        Exceptions.printStackTrace((Throwable)propertyVetoException);
                    }
                }
            }
        });
    }

    public void refresh(final StructureItem structureItem, final FileObject fileObject) {
        final ElementNode elementNode = this.getRootNode();
        if (elementNode != null && elementNode.getFileObject().equals(fileObject)) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    long l = System.currentTimeMillis();
                    elementNode.updateRecursively(structureItem);
                    long l2 = System.currentTimeMillis();
                    Logger.getLogger("TIMER").log(Level.FINE, "Navigator Merge", new Object[]{fileObject, l2 - l});
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Node[] nodeArray;
                    Node[] nodeArray2;
                    long l = System.currentTimeMillis();
                    ClassMemberPanelUI.this.elementView.setRootVisible(false);
                    ClassMemberPanelUI.this.elementView.setAutoWaitCursor(false);
                    ClassMemberPanelUI.this.manager.setRootContext((Node)new ElementNode(structureItem, ClassMemberPanelUI.this, fileObject));
                    boolean bl = true;
                    Language language = LanguageRegistry.getInstance().getLanguageByMimeType(fileObject.getMIMEType());
                    if (language != null && language.getStructure() != null && (nodeArray2 = (nodeArray = language.getStructure()).getConfiguration()) != null) {
                        boolean bl2 = bl = nodeArray2.getExpandDepth() != 0;
                    }
                    if (bl) {
                        boolean bl3 = ClassMemberPanelUI.this.elementView.getScrollOnExpand();
                        ClassMemberPanelUI.this.elementView.setScrollOnExpand(false);
                        ClassMemberPanelUI.this.elementView.expandAll();
                        ClassMemberPanelUI.this.elementView.setScrollOnExpand(bl3);
                    } else {
                        for (Node node : nodeArray = ClassMemberPanelUI.this.manager.getRootContext().getChildren().getNodes()) {
                            ClassMemberPanelUI.this.elementView.expandNode(node);
                        }
                    }
                    ClassMemberPanelUI.this.elementView.setAutoWaitCursor(true);
                    long l2 = System.currentTimeMillis();
                    Logger.getLogger("TIMER").log(Level.FINE, "Navigator Initialization", new Object[]{fileObject, l2 - l});
                }
            });
        }
    }

    public void sort() {
        this.getRootNode().refreshRecursively();
    }

    public ClassMemberFilters getFilters() {
        return this.filters;
    }

    public void expandNode(Node node) {
        this.elementView.expandNode(node);
    }

    public Action[] getActions() {
        return this.actions;
    }

    public FileObject getFileObject() {
        return this.getRootNode().getFileObject();
    }

    public void filterStateChanged(ChangeEvent changeEvent) {
        ElementNode elementNode = this.getRootNode();
        if (elementNode != null) {
            elementNode.refreshRecursively();
        }
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    private ElementNode getRootNode() {
        Node node = this.manager.getRootContext();
        if (node instanceof ElementNode) {
            return (ElementNode)node;
        }
        return null;
    }

    private MyBeanTreeView createBeanTreeView() {
        MyBeanTreeView myBeanTreeView = new MyBeanTreeView();
        return myBeanTreeView;
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    private static class MyBeanTreeView
    extends BeanTreeView {
        private MyBeanTreeView() {
        }

        public boolean getScrollOnExpand() {
            return this.tree.getScrollsOnExpand();
        }

        public void setScrollOnExpand(boolean bl) {
            this.tree.setScrollsOnExpand(bl);
        }
    }
}

