/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.utils;

import java.io.File;
import java.util.HashSet;
import org.netbeans.modules.cnd.api.utils.SourceFileFilter;
import org.netbeans.modules.cnd.utils.MIMEExtensions;
import org.netbeans.modules.cnd.utils.MIMESupport;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class AllSourceFileFilter
extends SourceFileFilter {
    private static AllSourceFileFilter instance = null;
    private static String[] suffixes = null;

    public static AllSourceFileFilter getInstance() {
        if (instance == null) {
            instance = new AllSourceFileFilter();
        }
        return instance;
    }

    public String getDescription() {
        return NbBundle.getMessage(SourceFileFilter.class, (String)"FILECHOOSER_All_SOURCES_FILEFILTER", (Object)this.getSuffixesAsString());
    }

    public boolean accept(File file) {
        if (file != null) {
            if (file.isDirectory()) {
                return true;
            }
            if (FileUtil.getExtension((String)file.getPath()).length() == 0) {
                return "text/x-h".equals(MIMESupport.getFileMIMEType((File)file));
            }
            return super.accept(file);
        }
        return false;
    }

    public String[] getSuffixes() {
        if (suffixes == null) {
            suffixes = this.getAllSuffixes();
        }
        return suffixes;
    }

    private String[] getAllSuffixes() {
        HashSet hashSet = new HashSet();
        hashSet.addAll(MIMEExtensions.get((String)"text/x-c++").getValues());
        hashSet.addAll(MIMEExtensions.get((String)"text/x-c").getValues());
        hashSet.addAll(MIMEExtensions.get((String)"text/x-h").getValues());
        hashSet.addAll(MIMEExtensions.get((String)"text/x-fortran").getValues());
        return hashSet.toArray(new String[hashSet.size()]);
    }
}

