/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model;

import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.modules.vmd.api.model.ComponentDescriptor;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyDescriptor;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.openide.ErrorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Debug {
    private static int stackTraceFriendIndex = Integer.MIN_VALUE;

    private Debug() {
    }

    private static void init() {
        if (stackTraceFriendIndex >= 0) {
            return;
        }
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i];
            if (!Debug.class.getName().equals(stackTraceElement.getClassName()) || !"init".equals(stackTraceElement.getMethodName())) continue;
            stackTraceFriendIndex = i + 2;
            return;
        }
    }

    public static void warning(Object ... objectArray) {
        Debug.init();
        if (objectArray.length == 1 && objectArray[0] instanceof Throwable) {
            ((Throwable)objectArray[0]).printStackTrace(System.err);
            return;
        }
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("WARNING: ").append(stackTraceElementArray[stackTraceFriendIndex - 1]).append('\n');
        if (stackTraceFriendIndex < stackTraceElementArray.length) {
            stringBuilder.append("         ").append(stackTraceElementArray[stackTraceFriendIndex]).append('\n');
        }
        for (Object object : objectArray) {
            stringBuilder.append(" | ").append(object);
        }
        System.err.println(stringBuilder.toString());
    }

    public static boolean isFriend(Class clazz) {
        Debug.init();
        StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[stackTraceFriendIndex];
        return stackTraceElement.getClassName().equals(clazz.getName());
    }

    public static boolean isFriend(Class clazz, String string) {
        Debug.init();
        StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[stackTraceFriendIndex];
        return stackTraceElement.getClassName().equals(clazz.getName()) && stackTraceElement.getMethodName().equals(string);
    }

    public static boolean isFriend(String string, String string2) {
        Debug.init();
        StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[stackTraceFriendIndex];
        return stackTraceElement.getClassName().equals(string) && stackTraceElement.getMethodName().equals(string2);
    }

    public static RuntimeException error(Object ... objectArray) {
        Throwable throwable;
        Debug.init();
        if (objectArray.length == 1 && objectArray[0] instanceof Throwable) {
            throwable = (Throwable)objectArray[0];
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
            stringBuilder.append("ERROR: ").append(stackTraceElementArray[stackTraceFriendIndex - 1]).append('\n');
            if (stackTraceFriendIndex < stackTraceElementArray.length) {
                stringBuilder.append("       ").append(stackTraceElementArray[stackTraceFriendIndex]).append('\n');
            }
            for (Object object : objectArray) {
                stringBuilder.append(" | ").append(object);
            }
            throwable = new RuntimeException(stringBuilder.toString());
        }
        ErrorManager.getDefault().notify(65536, throwable);
        throw new RuntimeException(throwable);
    }

    public static RuntimeException illegalState(Object ... objectArray) {
        Throwable throwable;
        Debug.init();
        if (objectArray.length == 1 && objectArray[0] instanceof Throwable) {
            throwable = (Throwable)objectArray[0];
        } else {
            StringBuilder stringBuilder = new StringBuilder("ILLEGAL STATE: ");
            stringBuilder.append(Thread.currentThread().getStackTrace()[stackTraceFriendIndex - 1]);
            stringBuilder.append('\n');
            for (Object object : objectArray) {
                stringBuilder.append(" | ").append(object);
            }
            throwable = new IllegalStateException(stringBuilder.toString());
        }
        ErrorManager.getDefault().notify(65536, throwable);
        throw new RuntimeException(throwable);
    }

    public static RuntimeException illegalArgument(Object ... objectArray) {
        Throwable throwable;
        Debug.init();
        if (objectArray.length == 1 && objectArray[0] instanceof Throwable) {
            throwable = (Throwable)objectArray[0];
        } else {
            StringBuilder stringBuilder = new StringBuilder("ILLEGAL ARGUMENT: ");
            stringBuilder.append(Thread.currentThread().getStackTrace()[stackTraceFriendIndex - 1]);
            stringBuilder.append('\n');
            for (Object object : objectArray) {
                stringBuilder.append(" | ").append(object);
            }
            throwable = new IllegalArgumentException(stringBuilder.toString());
        }
        ErrorManager.getDefault().notify(65536, throwable);
        throw new RuntimeException(throwable);
    }

    public static void dumpDocument(DesignDocument designDocument) {
        assert (designDocument != null);
        Debug.dumpComponent(designDocument.getRootComponent());
    }

    public static void dumpComponent(DesignComponent designComponent) {
        if (designComponent == null) {
            System.out.println("No component to dump");
            return;
        }
        System.out.println("Dumping component: " + designComponent.getComponentID());
        designComponent.dumpComponent("");
    }

    public static void collectAllComponentReferences(PropertyValue propertyValue, Collection<DesignComponent> collection) {
        propertyValue.collectAllComponentReferences(collection);
    }

    public static boolean isComponentReferencedInRootTree(DesignComponent designComponent) {
        assert (designComponent != null);
        return Debug.isComponentReferencedInRootTree(designComponent.getDocument().getRootComponent(), designComponent);
    }

    private static boolean isComponentReferencedInRootTree(DesignComponent designComponent, DesignComponent designComponent2) {
        ArrayList<DesignComponent> arrayList = new ArrayList<DesignComponent>();
        ComponentDescriptor componentDescriptor = designComponent.getComponentDescriptor();
        if (componentDescriptor != null) {
            for (PropertyDescriptor object : componentDescriptor.getPropertyDescriptors()) {
                PropertyValue propertyValue = designComponent.readProperty(object.getName());
                arrayList.clear();
                Debug.collectAllComponentReferences(propertyValue, arrayList);
                if (!arrayList.contains(designComponent2)) continue;
                return true;
            }
        }
        for (DesignComponent designComponent3 : designComponent.getComponents()) {
            if (!Debug.isComponentReferencedInRootTree(designComponent3, designComponent2)) continue;
            return true;
        }
        return false;
    }
}

