/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.dtrace.collector;

import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.netbeans.modules.dlight.api.collector.DataCollectorConfiguration;
import org.netbeans.modules.dlight.api.indicator.IndicatorDataProviderConfiguration;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.core.stack.datacollector.CpuSamplingSupport;
import org.netbeans.modules.dlight.dtrace.collector.DtraceParser;
import org.netbeans.modules.dlight.dtrace.collector.impl.DTDCConfigurationAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DTDCConfiguration
implements DataCollectorConfiguration,
IndicatorDataProviderConfiguration {
    public static final String DTRACE_KERNEL = "dtrace_kernel";
    public static final String DTRACE_USER = "dtrace_user";
    public static final String DTRACE_PROC = "dtrace_proc";
    static final String DTDC_CONFIGURATION_ID = "DtraceDataCollectorConfigurationId";
    private static DTDCConfiguration CPU_SAMPLING;
    private URL scriptUrl;
    private String args;
    private List<DataTableMetadata> datatableMetadata;
    private DtraceParser parser;
    private List<String> requiredPrivileges;
    private boolean stackSupportEnabled = false;
    private int indicatorFiringFactor;
    private boolean standalone;
    private String prefix;

    public DTDCConfiguration(URL uRL, List<DataTableMetadata> list) {
        this.scriptUrl = uRL;
        this.datatableMetadata = list;
        this.args = null;
        this.parser = null;
        this.requiredPrivileges = null;
        this.indicatorFiringFactor = 1;
    }

    public void setScriptArgs(String string) {
        this.args = string;
    }

    public void setDtraceParser(DtraceParser dtraceParser) {
        this.parser = dtraceParser;
    }

    DTDCConfiguration setParser(DtraceParser dtraceParser) {
        this.parser = dtraceParser;
        return this;
    }

    public void setIndicatorFiringFactor(int n) {
        this.indicatorFiringFactor = n;
    }

    public void setRequiredDTracePrivileges(List<String> list) {
        this.requiredPrivileges = list;
    }

    public void setStackSupportEnabled(boolean bl) {
        this.stackSupportEnabled = bl;
    }

    public void setStandalone(boolean bl) {
        this.standalone = bl;
    }

    public void setOutputPrefix(String string) {
        this.prefix = string;
    }

    int getIndicatorFiringFactor() {
        return this.indicatorFiringFactor;
    }

    String getArgs() {
        return this.args;
    }

    List<DataTableMetadata> getDatatableMetadata() {
        return this.datatableMetadata;
    }

    DtraceParser getParser() {
        return this.parser;
    }

    List<String> getRequiredPrivileges() {
        return this.requiredPrivileges;
    }

    URL getScriptUrl() {
        return this.scriptUrl;
    }

    boolean isStackSupportEnabled() {
        return this.stackSupportEnabled;
    }

    boolean isStandalone() {
        return this.standalone;
    }

    String getOutputPrefix() {
        return this.prefix;
    }

    public String getID() {
        return DTDC_CONFIGURATION_ID;
    }

    public static synchronized DTDCConfiguration createCpuSamplingConfiguration() {
        if (CPU_SAMPLING == null) {
            CPU_SAMPLING = new DTDCConfiguration(CpuSamplingSupport.CPU_SAMPLING_SCRIPT_URL, Arrays.asList(CpuSamplingSupport.CPU_SAMPLE_TABLE));
            CPU_SAMPLING.setStackSupportEnabled(true);
            CPU_SAMPLING.setOutputPrefix("cpu:");
        }
        return CPU_SAMPLING;
    }

    static {
        DTDCConfigurationAccessor.setDefault(new DTDCConfigurationAccessorImpl());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DTDCConfigurationAccessorImpl
    extends DTDCConfigurationAccessor {
        private DTDCConfigurationAccessorImpl() {
        }

        @Override
        public String getArgs(DTDCConfiguration dTDCConfiguration) {
            return dTDCConfiguration.getArgs();
        }

        @Override
        public List<DataTableMetadata> getDatatableMetadata(DTDCConfiguration dTDCConfiguration) {
            return dTDCConfiguration.getDatatableMetadata();
        }

        @Override
        public DtraceParser getParser(DTDCConfiguration dTDCConfiguration) {
            return dTDCConfiguration.getParser();
        }

        @Override
        public List<String> getRequiredPrivileges(DTDCConfiguration dTDCConfiguration) {
            return dTDCConfiguration.getRequiredPrivileges();
        }

        @Override
        public URL getScriptUrl(DTDCConfiguration dTDCConfiguration) {
            return dTDCConfiguration.getScriptUrl();
        }

        @Override
        public String getID() {
            return DTDCConfiguration.DTDC_CONFIGURATION_ID;
        }

        @Override
        public boolean isStackSupportEnabled(DTDCConfiguration dTDCConfiguration) {
            return dTDCConfiguration.isStackSupportEnabled();
        }

        @Override
        public int getIndicatorFiringFactor(DTDCConfiguration dTDCConfiguration) {
            return dTDCConfiguration.getIndicatorFiringFactor();
        }

        @Override
        public boolean isStandalone(DTDCConfiguration dTDCConfiguration) {
            return dTDCConfiguration.isStandalone();
        }

        @Override
        public String getOutputPrefix(DTDCConfiguration dTDCConfiguration) {
            return dTDCConfiguration.getOutputPrefix();
        }
    }
}

