/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.customizer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.PlatformsCustomizer;
import org.netbeans.api.java.platform.Profile;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.mobility.project.ui.customizer.ProjectProperties;
import org.netbeans.modules.mobility.cldcplatform.J2MEPlatform;
import org.netbeans.spi.mobility.project.ui.customizer.CustomizerPanel;
import org.netbeans.spi.mobility.project.ui.customizer.VisualPropertyGroup;
import org.netbeans.spi.mobility.project.ui.customizer.support.VisualPropertySupport;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CustomizerMIDP
extends JPanel
implements CustomizerPanel,
VisualPropertyGroup,
ActionListener {
    private static final String[] PROPERTY_GROUP = new String[]{"platform.active", "platform.active.description", "platform.device", "platform.configuration", "platform.profile", "platform.apis", "platform.bootclasspath", "javac.source", "javac.target"};
    private static final Comparator<J2MEPlatform.J2MEProfile> OPTIONAL_API_COMPARATOR = new Comparator<J2MEPlatform.J2MEProfile>(){

        @Override
        public int compare(J2MEPlatform.J2MEProfile j2MEProfile, J2MEPlatform.J2MEProfile j2MEProfile2) {
            return j2MEProfile.getDisplayNameWithVersion().compareTo(j2MEProfile2.getDisplayNameWithVersion());
        }
    };
    private Map<String, Object> props;
    private VisualPropertySupport vps;
    private String configuration;
    private String[] platformNames;
    private HashMap<String, J2MEPlatform> name2platform;
    private HashMap<String, J2MEPlatform.Device> name2device;
    private HashMap<String, J2MEPlatform.J2MEProfile> name2profile;
    private ArrayList<JCheckBox> optional;
    private boolean useDefault;
    private final transient Object lock = new Object();
    private ButtonGroup cfgGroup;
    private JButton jButtonEdit;
    private JComboBox jComboBoxTarget;
    private JComboBox jComboDevice;
    private JLabel jLabelConfig;
    private JLabel jLabelDevice;
    private JLabel jLabelOptional;
    private JLabel jLabelProfile;
    private JLabel jLabelTarget;
    private JPanel jPanelConfig;
    private JPanel jPanelOptional;
    private JPanel jPanelProfile;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private ButtonGroup profGroup;
    private int firstConfigWidth = -1;

    public CustomizerMIDP() {
        this.initComponents();
        this.initAccessibility();
        this.initAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshAll() {
        Object object = this.lock;
        synchronized (object) {
            this.jPanelConfig.removeAll();
            this.jPanelProfile.removeAll();
            this.jPanelOptional.removeAll();
            this.cfgGroup = new ButtonGroup();
            this.profGroup = new ButtonGroup();
            this.initAll();
            this.initGroupValues(this.useDefault);
            this.jPanelConfig.invalidate();
            this.jPanelProfile.invalidate();
            this.jPanelOptional.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAll() {
        Object object = this.lock;
        synchronized (object) {
            this.optional = new ArrayList();
            this.name2platform = new HashMap();
            this.name2device = new HashMap();
            this.name2profile = new HashMap();
            JavaPlatform[] javaPlatformArray = JavaPlatformManager.getDefault().getPlatforms(null, new Specification("j2me", null));
            HashMap<J2MEPlatform.J2MEProfile, J2MEPlatform.J2MEProfile> hashMap = new HashMap<J2MEPlatform.J2MEProfile, J2MEPlatform.J2MEProfile>();
            HashMap<J2MEPlatform.J2MEProfile, J2MEPlatform.J2MEProfile> hashMap2 = new HashMap<J2MEPlatform.J2MEProfile, J2MEPlatform.J2MEProfile>();
            HashMap<J2MEPlatform.J2MEProfile, J2MEPlatform.J2MEProfile> hashMap3 = new HashMap<J2MEPlatform.J2MEProfile, J2MEPlatform.J2MEProfile>();
            for (int i = 0; i < javaPlatformArray.length; ++i) {
                J2MEPlatform j2MEPlatform;
                if (!(javaPlatformArray[i] instanceof J2MEPlatform) || !(j2MEPlatform = (J2MEPlatform)javaPlatformArray[i]).isValid()) continue;
                this.name2platform.put(j2MEPlatform.getDisplayName(), j2MEPlatform);
                Profile[] profileArray = j2MEPlatform.getSpecification().getProfiles();
                for (int j = 0; j < profileArray.length; ++j) {
                    if (!(profileArray[j] instanceof J2MEPlatform.J2MEProfile)) continue;
                    J2MEPlatform.J2MEProfile j2MEProfile = (J2MEPlatform.J2MEProfile)profileArray[j];
                    if ("configuration".equals(j2MEProfile.getType())) {
                        j2MEProfile = this.takeBetter(j2MEProfile, (J2MEPlatform.J2MEProfile)hashMap.remove(j2MEProfile));
                        hashMap.put(j2MEProfile, j2MEProfile);
                        continue;
                    }
                    if ("profile".equals(j2MEProfile.getType())) {
                        j2MEProfile = this.takeBetter(j2MEProfile, (J2MEPlatform.J2MEProfile)hashMap2.remove(j2MEProfile));
                        hashMap2.put(j2MEProfile, j2MEProfile);
                        continue;
                    }
                    if (!"optional".equals(j2MEProfile.getType())) continue;
                    j2MEProfile = this.takeBetter(j2MEProfile, (J2MEPlatform.J2MEProfile)hashMap3.remove(j2MEProfile));
                    hashMap3.put(j2MEProfile, j2MEProfile);
                }
            }
            this.platformNames = this.name2platform.keySet().toArray(new String[this.name2platform.size()]);
            Arrays.sort(this.platformNames);
            J2MEPlatform.J2MEProfile[] j2MEProfileArray = hashMap.values().toArray(new J2MEPlatform.J2MEProfile[hashMap.size()]);
            this.initConfigurations(j2MEProfileArray);
            j2MEProfileArray = hashMap2.values().toArray(new J2MEPlatform.J2MEProfile[hashMap2.size()]);
            this.initProfiles(j2MEProfileArray);
            j2MEProfileArray = hashMap3.values().toArray(new J2MEPlatform.J2MEProfile[hashMap3.size()]);
            this.initOptional(j2MEProfileArray);
        }
    }

    private J2MEPlatform.J2MEProfile takeBetter(J2MEPlatform.J2MEProfile j2MEProfile, J2MEPlatform.J2MEProfile j2MEProfile2) {
        if (j2MEProfile == null) {
            return j2MEProfile2;
        }
        if (j2MEProfile2 == null) {
            return j2MEProfile;
        }
        return j2MEProfile.getDisplayNameWithVersion().length() > j2MEProfile2.getDisplayNameWithVersion().length() ? j2MEProfile : j2MEProfile2;
    }

    private void initConfigurations(J2MEPlatform.J2MEProfile[] j2MEProfileArray) {
        Arrays.sort(j2MEProfileArray);
        for (int i = 0; i < j2MEProfileArray.length; ++i) {
            JRadioButton jRadioButton = new JRadioButton(j2MEProfileArray[i].toString());
            jRadioButton.setToolTipText(j2MEProfileArray[i].getDisplayNameWithVersion());
            jRadioButton.setActionCommand(j2MEProfileArray[i].toString());
            this.cfgGroup.add(jRadioButton);
            this.jPanelConfig.add(jRadioButton);
            Dimension dimension = jRadioButton.getPreferredSize();
            if (this.firstConfigWidth == -1) {
                this.firstConfigWidth = dimension.width + 10;
                jRadioButton.setPreferredSize(new Dimension(this.firstConfigWidth, dimension.height));
                jRadioButton.setMinimumSize(new Dimension(this.firstConfigWidth, dimension.height));
            } else {
                jRadioButton.setPreferredSize(new Dimension(this.firstConfigWidth, dimension.height));
                jRadioButton.setMinimumSize(new Dimension(this.firstConfigWidth, dimension.height));
            }
            jRadioButton.addActionListener(this);
        }
    }

    private void initProfiles(J2MEPlatform.J2MEProfile[] j2MEProfileArray) {
        Arrays.sort(j2MEProfileArray);
        for (int i = 0; i < j2MEProfileArray.length; ++i) {
            JRadioButton jRadioButton = new JRadioButton(j2MEProfileArray[i].toString());
            jRadioButton.setToolTipText(j2MEProfileArray[i].getDisplayNameWithVersion());
            jRadioButton.setActionCommand(j2MEProfileArray[i].toString());
            jRadioButton.setPreferredSize(new Dimension(this.firstConfigWidth, jRadioButton.getPreferredSize().height));
            jRadioButton.setMinimumSize(new Dimension(this.firstConfigWidth, jRadioButton.getPreferredSize().height));
            this.profGroup.add(jRadioButton);
            this.jPanelProfile.add(jRadioButton);
            jRadioButton.addActionListener(this);
        }
    }

    private void initOptional(J2MEPlatform.J2MEProfile[] j2MEProfileArray) {
        Arrays.sort(j2MEProfileArray, OPTIONAL_API_COMPARATOR);
        for (int i = 0; i < j2MEProfileArray.length; ++i) {
            String string = j2MEProfileArray[i].isNameIsJarFileName() ? j2MEProfileArray[i].getDisplayName() : j2MEProfileArray[i].getDisplayNameWithVersion();
            JCheckBox jCheckBox = new JCheckBox(string);
            jCheckBox.setToolTipText(string);
            jCheckBox.setActionCommand(j2MEProfileArray[i].toString());
            this.optional.add(jCheckBox);
            jCheckBox.addActionListener(this);
        }
    }

    @Override
    public void initValues(ProjectProperties projectProperties, String string) {
        this.props = projectProperties;
        this.vps = VisualPropertySupport.getDefault(projectProperties);
        this.configuration = string;
    }

    @Override
    public void initGroupValues(boolean bl) {
        this.jComboBoxTarget.removeActionListener(this);
        if (this.platformNames.length > 0) {
            this.vps.register(this.jComboBoxTarget, this.platformNames, "platform.active", bl);
            this.useDefault = bl;
            this.jComboBoxTarget.addActionListener(this);
        } else {
            this.jComboBoxTarget.removeAllItems();
            String string = NbBundle.getMessage(CustomizerMIDP.class, (String)"ERR_CustMIDP_NoPlatform");
            this.jComboBoxTarget.addItem(string);
            this.jComboBoxTarget.setSelectedItem(string);
            this.jComboBoxTarget.setEnabled(false);
        }
        this.initDevices((String)this.jComboBoxTarget.getSelectedItem(), false);
        this.enableLabels(!bl);
        this.props.put(VisualPropertySupport.translatePropertyName(this.configuration, "javac.source", bl), "1.3");
        this.props.put(VisualPropertySupport.translatePropertyName(this.configuration, "javac.target", bl), "1.3");
    }

    private void enableLabels(boolean bl) {
        this.jLabelDevice.setEnabled(bl);
        this.jLabelConfig.setEnabled(bl);
        this.jLabelTarget.setEnabled(bl);
        this.jLabelOptional.setEnabled(bl);
        this.jLabelProfile.setEnabled(bl);
        this.jButtonEdit.setEnabled(bl);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.jComboBoxTarget.equals(actionEvent.getSource())) {
            this.initDevices((String)this.jComboBoxTarget.getSelectedItem(), true);
        } else if (this.jComboDevice.equals(actionEvent.getSource())) {
            this.initAllProfiles((String)this.jComboDevice.getSelectedItem(), true);
        } else if (actionEvent.getSource() instanceof JCheckBox) {
            JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
            if (jCheckBox.isSelected()) {
                this.detectCollisions(jCheckBox.getActionCommand());
            }
            this.saveOptionalAPIs();
            this.saveClassPath();
        } else if (actionEvent.getSource() instanceof JRadioButton) {
            this.saveClassPath();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDevices(String string, boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            J2MEPlatform j2MEPlatform = this.name2platform.get(string);
            if (j2MEPlatform != null) {
                this.props.put(VisualPropertySupport.translatePropertyName(this.configuration, "platform.active.description", this.useDefault), j2MEPlatform.getDisplayName());
                this.props.put(VisualPropertySupport.translatePropertyName(this.configuration, "platform.type", this.useDefault), j2MEPlatform.getType());
                J2MEPlatform.Device[] deviceArray = j2MEPlatform.getDevices();
                this.jComboDevice.removeActionListener(this);
                this.name2device = new HashMap();
                for (int i = 0; i < deviceArray.length; ++i) {
                    if (!deviceArray[i].isValid()) continue;
                    this.name2device.put(deviceArray[i].getName(), deviceArray[i]);
                }
                Object[] objectArray = this.name2device.keySet().toArray(new String[this.name2device.size()]);
                Arrays.sort(objectArray);
                this.vps.register(this.jComboDevice, objectArray, "platform.device", this.useDefault);
                this.initAllProfiles((String)this.jComboDevice.getSelectedItem(), bl);
                this.jComboDevice.addActionListener(this);
            } else {
                this.jComboDevice.removeAllItems();
                this.jComboDevice.setEnabled(false);
                this.enableLabels(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAllProfiles(String string, boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            Object object2;
            int n;
            Object[] objectArray;
            HashMap<String, J2MEPlatform.J2MEProfile> hashMap = new HashMap<String, J2MEPlatform.J2MEProfile>();
            J2MEPlatform.Device device = this.name2device.get(string);
            HashSet<String> hashSet = new HashSet<String>();
            String string2 = null;
            String string3 = null;
            HashSet<String> hashSet2 = new HashSet<String>();
            this.name2profile = new HashMap();
            if (device != null) {
                objectArray = device.getProfiles();
                for (n = 0; n < objectArray.length; ++n) {
                    hashSet.add(objectArray[n].toString());
                    this.name2profile.put(objectArray[n].toString(), objectArray[n]);
                    if ("configuration".equals(objectArray[n].getType()) && objectArray[n].isDefault()) {
                        string2 = objectArray[n].toString();
                        continue;
                    }
                    if ("profile".equals(objectArray[n].getType()) && objectArray[n].isDefault()) {
                        string3 = objectArray[n].toString();
                        continue;
                    }
                    if (!"optional".equals(objectArray[n].getType()) || !objectArray[n].isDefault()) continue;
                    hashMap.put(objectArray[n].toString(), objectArray[n]);
                    hashSet2.add(objectArray[n].toString());
                }
            }
            objectArray = this.jPanelConfig.getComponents();
            for (n = 0; n < objectArray.length; ++n) {
                if (!(objectArray[n] instanceof JRadioButton)) continue;
                object2 = (JRadioButton)objectArray[n];
                this.vps.register((JRadioButton)object2, "platform.configuration", this.useDefault);
                if (hashSet.contains(((AbstractButton)object2).getActionCommand())) {
                    ((AbstractButton)object2).setEnabled(!this.useDefault);
                    continue;
                }
                ((AbstractButton)object2).setEnabled(false);
            }
            if (bl && string2 != null) {
                this.selectDefault(this.jPanelConfig, string2, "platform.configuration");
            }
            bl = (objectArray = this.jPanelProfile.getComponents()).length > 0;
            for (n = 0; n < objectArray.length; ++n) {
                if (!(objectArray[n] instanceof JRadioButton)) continue;
                object2 = (JRadioButton)objectArray[n];
                this.vps.register((JRadioButton)object2, "platform.profile", this.useDefault);
                if (hashSet.contains(((AbstractButton)object2).getActionCommand())) {
                    ((AbstractButton)object2).setEnabled(!this.useDefault);
                } else {
                    ((AbstractButton)object2).setEnabled(false);
                }
                if (!((AbstractButton)object2).isSelected()) continue;
                bl = false;
            }
            if (bl && string2 != null) {
                this.selectDefault(this.jPanelProfile, string3, "platform.profile");
            }
            Set<String> set = this.getOptionalValues();
            this.jPanelOptional.setVisible(false);
            this.jPanelOptional.removeAll();
            for (JCheckBox jCheckBox : this.removeDuplicateOptProfiles(hashMap)) {
                String string4 = jCheckBox.getActionCommand();
                boolean bl2 = (bl ? hashSet2 : set).contains(string4);
                this.jPanelOptional.add((Component)jCheckBox, new GridBagConstraints(0, -1, 0, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
                jCheckBox.setEnabled(!this.useDefault);
                jCheckBox.setSelected(bl2);
            }
            this.jPanelOptional.add((Component)new JPanel(), new GridBagConstraints(0, -1, 0, 0, 1.0, 1.0, 18, 3, new Insets(0, 0, 0, 0), 0, 0));
            this.jPanelOptional.setVisible(true);
            this.jPanelOptional.repaint();
            this.jPanelOptional.validate();
            this.saveOptionalAPIs();
            this.saveClassPath();
        }
    }

    private List<JCheckBox> removeDuplicateOptProfiles(Map<String, J2MEPlatform.J2MEProfile> map) {
        Serializable serializable;
        CharSequence charSequence;
        Object object;
        ArrayList<JCheckBox> arrayList;
        ArrayList<ArrayList<JCheckBox>> arrayList2 = new ArrayList<ArrayList<JCheckBox>>(this.optional.size());
        for (JCheckBox serializable22 : this.optional) {
            if (map.get(serializable22.getActionCommand()) == null) continue;
            arrayList = new JCheckBox(serializable22.getText());
            ((JComponent)((Object)arrayList)).setToolTipText(serializable22.getToolTipText());
            ((AbstractButton)((Object)arrayList)).setActionCommand(serializable22.getActionCommand());
            ((AbstractButton)((Object)arrayList)).addActionListener(this);
            arrayList2.add(arrayList);
        }
        Collection<J2MEPlatform.J2MEProfile> collection = map.values();
        HashMap<CharSequence, Serializable> hashMap = new HashMap<CharSequence, Serializable>();
        arrayList = collection.iterator();
        while (arrayList.hasNext()) {
            object = (J2MEPlatform.J2MEProfile)arrayList.next();
            charSequence = object.getClassPath();
            serializable = (LinkedList<Object>)hashMap.get(charSequence);
            if (serializable == null) {
                serializable = new LinkedList<Object>();
                hashMap.put(charSequence, serializable);
            }
            serializable.add(object);
        }
        arrayList = new ArrayList<JCheckBox>(arrayList2.size());
        object = new HashMap();
        charSequence = new StringBuilder();
        serializable = new StringBuilder();
        for (JCheckBox jCheckBox : arrayList2) {
            String string = jCheckBox.getActionCommand();
            J2MEPlatform.J2MEProfile j2MEProfile = map.get(string);
            String string2 = j2MEProfile.getClassPath();
            List list = (List)hashMap.get(string2);
            if (list.size() > 1) {
                JCheckBox jCheckBox2 = (JCheckBox)object.get(string2);
                if (jCheckBox2 == null) {
                    object.put(string2, jCheckBox);
                    arrayList.add(jCheckBox);
                    continue;
                }
                String string3 = jCheckBox2.getText();
                String string4 = jCheckBox2.getToolTipText();
                ((StringBuilder)charSequence).setLength(0);
                ((StringBuilder)serializable).setLength(0);
                if (!string3.contains(jCheckBox.getText())) {
                    ((StringBuilder)charSequence).append(string3);
                    ((StringBuilder)charSequence).append(", ");
                    ((StringBuilder)charSequence).append(jCheckBox.getText());
                    jCheckBox2.setText(((StringBuilder)charSequence).toString());
                }
                if (string4.contains(jCheckBox.getToolTipText())) continue;
                ((StringBuilder)serializable).append(string4);
                ((StringBuilder)serializable).append(", ");
                ((StringBuilder)serializable).append(jCheckBox.getToolTipText());
                jCheckBox2.setToolTipText(((StringBuilder)serializable).toString());
                continue;
            }
            arrayList.add(jCheckBox);
        }
        return arrayList;
    }

    private Set<String> getOptionalValues() {
        String string = (String)this.props.get(VisualPropertySupport.translatePropertyName(this.configuration, "platform.apis", this.useDefault));
        if (string == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> hashSet = new HashSet<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            hashSet.add(stringTokenizer.nextToken());
        }
        return hashSet;
    }

    private void selectDefault(JPanel jPanel, String string, String string2) {
        Component[] componentArray = jPanel.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            JRadioButton jRadioButton;
            if (!(componentArray[i] instanceof JRadioButton) || !string.equals((jRadioButton = (JRadioButton)componentArray[i]).getActionCommand())) continue;
            this.props.put(VisualPropertySupport.translatePropertyName(this.configuration, string2, this.useDefault), string);
            this.vps.register(jRadioButton, string2, this.useDefault);
        }
    }

    private void detectCollisions(String string) {
        J2MEPlatform.J2MEProfile j2MEProfile = this.name2profile.get(string);
        if (j2MEProfile == null) {
            return;
        }
        Component[] componentArray = this.jPanelOptional.getComponents();
        for (int i = 0; i < componentArray.length - 1; ++i) {
            J2MEPlatform.J2MEProfile j2MEProfile2;
            JCheckBox jCheckBox = (JCheckBox)componentArray[i];
            if (!jCheckBox.isSelected() || (j2MEProfile2 = this.name2profile.get(jCheckBox.getActionCommand())) == null || j2MEProfile2.equals((Object)j2MEProfile) || !j2MEProfile2.getName().equals(j2MEProfile.getName()) || !jCheckBox.isEnabled()) continue;
            jCheckBox.setSelected(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveOptionalAPIs() {
        Object object = this.lock;
        synchronized (object) {
            StringBuffer stringBuffer = new StringBuffer();
            Component[] componentArray = this.jPanelOptional.getComponents();
            for (int i = 0; i < componentArray.length - 1; ++i) {
                JCheckBox jCheckBox = (JCheckBox)componentArray[i];
                if (!jCheckBox.isSelected()) continue;
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(jCheckBox.getActionCommand());
            }
            String string = VisualPropertySupport.translatePropertyName(this.configuration, "platform.apis", this.useDefault);
            this.props.put(string, stringBuffer.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveClassPath() {
        Object object = this.lock;
        synchronized (object) {
            J2MEPlatform.J2MEProfile j2MEProfile;
            JToggleButton jToggleButton;
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            Component[] componentArray = this.jPanelConfig.getComponents();
            for (n = 0; n < componentArray.length; ++n) {
                if (!(componentArray[n] instanceof JRadioButton) || !(jToggleButton = (JRadioButton)componentArray[n]).isSelected() || (j2MEProfile = this.name2profile.get(jToggleButton.getActionCommand())) == null) continue;
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(':');
                }
                stringBuffer.append(j2MEProfile.getClassPath());
            }
            componentArray = this.jPanelProfile.getComponents();
            for (n = 0; n < componentArray.length; ++n) {
                if (!(componentArray[n] instanceof JRadioButton) || !(jToggleButton = (JRadioButton)componentArray[n]).isSelected() || (j2MEProfile = this.name2profile.get(jToggleButton.getActionCommand())) == null) continue;
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(':');
                }
                stringBuffer.append(j2MEProfile.getClassPath());
            }
            componentArray = this.jPanelOptional.getComponents();
            for (n = 0; n < componentArray.length - 1; ++n) {
                jToggleButton = (JCheckBox)componentArray[n];
                if (!jToggleButton.isSelected() || (j2MEProfile = this.name2profile.get(jToggleButton.getActionCommand())) == null) continue;
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(':');
                }
                stringBuffer.append(j2MEProfile.getClassPath());
            }
            J2MEPlatform.Device device = this.name2device.get(this.jComboDevice.getSelectedItem());
            this.props.put(VisualPropertySupport.translatePropertyName(this.configuration, "platform.bootclasspath", this.useDefault), device == null ? stringBuffer.toString() : device.sortClasspath(stringBuffer.toString()));
        }
    }

    private void initComponents() {
        this.cfgGroup = new ButtonGroup();
        this.profGroup = new ButtonGroup();
        this.jLabelTarget = new JLabel();
        this.jComboBoxTarget = new JComboBox();
        this.jButtonEdit = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jLabelDevice = new JLabel();
        this.jComboDevice = new JComboBox();
        this.jLabelConfig = new JLabel();
        this.jPanelConfig = new JPanel();
        this.jLabelProfile = new JLabel();
        this.jPanelProfile = new JPanel();
        this.jLabelOptional = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jPanelOptional = new JPanel();
        this.setLayout(new GridBagLayout());
        this.jLabelTarget.setLabelFor(this.jComboBoxTarget);
        Mnemonics.setLocalizedText((JLabel)this.jLabelTarget, (String)NbBundle.getMessage(CustomizerMIDP.class, (String)"LBL_CustMIDP_TargetPlatform"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabelTarget, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.jComboBoxTarget, gridBagConstraints);
        this.jComboBoxTarget.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerMIDP.class, (String)"ACSD_CustMIDP_Platform"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonEdit, (String)NbBundle.getMessage(CustomizerMIDP.class, (String)"LBL_CustMIDP_Edit"));
        this.jButtonEdit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerMIDP.this.jButtonEditActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.jButtonEdit, gridBagConstraints);
        this.jButtonEdit.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerMIDP.class, (String)"ACSD_CustMIDP_Edit"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        this.add((Component)this.jSeparator1, gridBagConstraints);
        this.jLabelDevice.setLabelFor(this.jComboDevice);
        Mnemonics.setLocalizedText((JLabel)this.jLabelDevice, (String)NbBundle.getMessage(CustomizerMIDP.class, (String)"LBL_CustMIDP_Device"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.jLabelDevice, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 5, 0, 0);
        this.add((Component)this.jComboDevice, gridBagConstraints);
        this.jComboDevice.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerMIDP.class, (String)"ACSD_CustMIDP_Device"));
        Mnemonics.setLocalizedText((JLabel)this.jLabelConfig, (String)NbBundle.getMessage(CustomizerMIDP.class, (String)"LBL_CustMIDP_Configuration"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        this.add((Component)this.jLabelConfig, gridBagConstraints);
        this.jPanelConfig.setLayout(new GridLayout(1, 0, 5, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 5, 0, 0);
        this.add((Component)this.jPanelConfig, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabelProfile, (String)NbBundle.getMessage(CustomizerMIDP.class, (String)"LBL_CustMIDP_Profile"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        this.add((Component)this.jLabelProfile, gridBagConstraints);
        this.jPanelProfile.setLayout(new GridLayout(1, 0, 5, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 5, 0, 0);
        this.add((Component)this.jPanelProfile, gridBagConstraints);
        this.jLabelOptional.setLabelFor(this.jPanelOptional);
        Mnemonics.setLocalizedText((JLabel)this.jLabelOptional, (String)NbBundle.getMessage(CustomizerMIDP.class, (String)"LBL_CustMIDP_Optional"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        this.add((Component)this.jLabelOptional, gridBagConstraints);
        this.jPanelOptional.setLayout(new GridBagLayout());
        this.jScrollPane1.setViewportView(this.jPanelOptional);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerMIDP.class, (String)"ACSN_CustMIDP"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerMIDP.class, (String)"ACSD_CustMIDP"));
    }

    private void jButtonEditActionPerformed(ActionEvent actionEvent) {
        PlatformsCustomizer.showCustomizer((JavaPlatform)((JavaPlatform)this.name2platform.get(this.jComboBoxTarget.getSelectedItem())));
        this.refreshAll();
    }

    @Override
    public String[] getGroupPropertyNames() {
        return PROPERTY_GROUP;
    }
}

