/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.kenai;

import java.io.File;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.kenai.HgKenaiSupport;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.util.VCSKenaiSupport;
import org.openide.awt.HtmlBrowser;
import org.openide.util.NbBundle;

public class KenaiNotificationListener
extends VCSKenaiSupport.KenaiNotificationListener {
    protected void handleVCSNotification(VCSKenaiSupport.VCSKenaiNotification vCSKenaiNotification) {
        if (vCSKenaiNotification.getService() != VCSKenaiSupport.Service.VCS_HG) {
            Mercurial.LOG.fine("rejecting VCS notification " + vCSKenaiNotification + " because not from hg");
            return;
        }
        File file = vCSKenaiNotification.getProjectDirectory();
        if (!Mercurial.getInstance().isManaged(file)) {
            assert (false) : " project " + file + " not managed";
            Mercurial.LOG.fine("rejecting VCS notification " + vCSKenaiNotification + " for " + file + " because not versioned by hg");
            return;
        }
        Mercurial.LOG.fine("accepting VCS notification " + vCSKenaiNotification + " for " + file);
        File[] fileArray = Mercurial.getInstance().getFileStatusCache().listFiles(new File[]{file}, 6612);
        List list = vCSKenaiNotification.getModifications();
        LinkedList<File> linkedList = new LinkedList<File>();
        String string = null;
        block0: for (File file2 : fileArray) {
            String string2 = HgUtils.getRelativePath(file2);
            if (string2 == null) {
                assert (false) : file2.getAbsolutePath() + " - no relative path";
                continue;
            }
            string2 = this.trim(string2);
            for (VCSKenaiSupport.VCSKenaiModification vCSKenaiModification : list) {
                String string3 = vCSKenaiModification.getResource();
                string3 = this.trim(string3);
                LOG.finer(" changed file " + string2 + ", " + string3);
                if (!string2.equals(string3)) continue;
                LOG.fine("  will notify " + file2 + ", " + vCSKenaiNotification);
                linkedList.add(file2);
                if (string != null) continue block0;
                string = vCSKenaiModification.getId();
                continue block0;
            }
        }
        if (linkedList.size() > 0) {
            this.notifyFileChange(linkedList.toArray(new File[linkedList.size()]), file, vCSKenaiNotification.getUri().toString(), string);
        }
    }

    protected void setupPane(JTextPane jTextPane, File[] fileArray, File file, String string, String string2) {
        String string3 = NbBundle.getMessage(KenaiNotificationListener.class, (String)"MSG_NotificationBubble_Description", (Object)this.getFileNames(fileArray), (Object)HgKenaiSupport.getInstance().getRevisionUrl(string, string2));
        jTextPane.setText(string3);
        jTextPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                    URL uRL = hyperlinkEvent.getURL();
                    assert (uRL != null);
                    HtmlBrowser.URLDisplayer uRLDisplayer = HtmlBrowser.URLDisplayer.getDefault();
                    assert (uRLDisplayer != null) : "HtmlBrowser.URLDisplayer found.";
                    if (uRLDisplayer != null) {
                        uRLDisplayer.showURL(uRL);
                    } else {
                        Mercurial.LOG.info("No URLDisplayer found.");
                    }
                }
            }
        });
    }
}

