/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.cdc.project.semc;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class PkgMake
extends Task {
    private File workdir;
    private String id;
    private String appname;
    private String appicon;
    private String vendor;
    private String version;
    private File cert;
    private File key;
    private File logo;
    private boolean logoInstallOnly;
    private String pass;
    private File dll;
    private List filesets = new LinkedList();

    public void addFileset(FileSet fs) {
        this.filesets.add(fs);
    }

    public void execute() throws BuildException {
        File iconFile;
        BufferedReader br = null;
        StringBuffer newFileContent = new StringBuffer();
        File pkg = new File(this.workdir, "PProLauncher" + this.id + ".pkg");
        if (!pkg.exists()) {
            throw new BuildException("PProLauncher" + this.id + ".pkg does not exists!");
        }
        if (!pkg.canWrite()) {
            this.log("PProLauncher" + this.id + ".pkg can not be written!", 1);
            throw new BuildException("PProLauncher" + this.id + ".pkg can not be written!");
        }
        try {
            String line;
            br = new BufferedReader(new FileReader(pkg));
            boolean found = false;
            Pattern vendorMatcher = Pattern.compile("^%.*$");
            Pattern headerMatcher = Pattern.compile("^#.*$");
            Pattern logoMatcher = Pattern.compile("^=.*$");
            Pattern iconMatcher = Pattern.compile("^\\\"" + this.id + ".mbm.*$");
            while ((line = br.readLine()) != null) {
                if (line.indexOf(";\"app.jar\"") != -1) {
                    found = true;
                    for (FileSet fs : this.filesets) {
                        DirectoryScanner ds = null;
                        try {
                            ds = fs.getDirectoryScanner(this.project);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if (ds == null) {
                            this.log("Directory scanner == null, skipping", 4);
                            continue;
                        }
                        this.log("Directory scanner: " + ds, 4);
                        File basedir = ds.getBasedir();
                        this.log("Base dir: " + basedir, 4);
                        String[] files = ds.getIncludedFiles();
                        for (int i = 0; i < files.length; ++i) {
                            File f = new File(basedir, files[i]);
                            if (!f.exists()) {
                                this.log(files[i] + " ignored, pointing to non existing file");
                                continue;
                            }
                            if (files[i].toLowerCase().endsWith("dll")) {
                                newFileContent.append("\"" + files[i] + "\" - \"!:\\sys\\bin\\" + files[i] + "\"\r\n");
                                continue;
                            }
                            newFileContent.append("\"" + files[i] + "\" - \"!:\\Private\\" + this.id + "\\" + files[i] + "\"\r\n");
                        }
                    }
                    continue;
                }
                if (headerMatcher.matcher(line).matches()) {
                    Pattern versionVerifier = Pattern.compile("^\\d{1,2}[.]\\d{1,2}[.]\\d{1,2}$");
                    if (this.version == null || !versionVerifier.matcher(this.version.trim()).matches()) {
                        throw new BuildException("Property version is not set or have wrong format!");
                    }
                    this.version = this.version.trim().replace('.', ',');
                    newFileContent.append("#{\"" + this.appname + "\"}, (0x" + this.id.toUpperCase() + "), " + this.version + ", TYPE=SA\r\n");
                    continue;
                }
                if (vendorMatcher.matcher(line).matches()) {
                    if (this.vendor == null) {
                        throw new BuildException("Property vendor is not set!");
                    }
                    newFileContent.append("%{\"" + this.vendor + "\"}\r\n");
                    continue;
                }
                if (logoMatcher.matcher(line).matches() || iconMatcher.matcher(line).matches()) continue;
                newFileContent.append(line);
                newFileContent.append("\r\n");
            }
        }
        catch (FileNotFoundException ex) {
            throw new BuildException((Throwable)ex);
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ex) {
                    throw new BuildException((Throwable)ex);
                }
            }
        }
        if (this.appicon != null && (iconFile = new File(this.workdir, this.appicon)).exists()) {
            newFileContent.append("; Icon added by NetBeans CDC Plugin\r\n");
            newFileContent.append("\"" + this.appicon + "\" - \"!:\\Resource\\Apps\\" + this.appicon + "\"\r\n");
        }
        if (this.logo != null && this.logo.exists()) {
            String ext = this.logo.toString().toLowerCase();
            int i = ext.lastIndexOf(46);
            if (i != -1) {
                ext = ext.substring(i + 1);
            }
            String mimeType = null;
            if (ext.endsWith("png")) {
                mimeType = "image/png";
            } else if (ext.endsWith("gif")) {
                mimeType = "image/gif";
            } else if (ext.endsWith("bmp")) {
                mimeType = "image/bmp";
            } else if (ext.endsWith("mbm")) {
                mimeType = "image/x-mbm";
            } else if (ext.endsWith("jpg")) {
                mimeType = "image/jpeg";
            } else if (ext.endsWith("jpeg")) {
                mimeType = "image/jpeg";
            } else {
                this.log("Unknown mime type for logo, skipping", 1);
            }
            if (mimeType != null) {
                try {
                    File f = new File(this.workdir, this.id + "-logo." + ext);
                    if (!f.exists()) {
                        PkgMake.copyFiles(this.logo, f);
                    }
                }
                catch (IOException ioEx) {
                    // empty catch block
                }
                newFileContent.append("; Logo added by NetBeans CDC Plugin\r\n");
                if (this.logoInstallOnly) {
                    newFileContent.append("=\"" + this.id + "-logo." + ext + "\", \"" + mimeType + "\", \"\"");
                } else {
                    newFileContent.append("=\"" + this.id + "-logo." + ext + "\", \"" + mimeType + "\", \"!:\\Private\\" + this.id + "\\" + this.id + "-logo." + ext + "\"");
                }
                newFileContent.append("\r\n");
            }
        }
        FilterOutputStream bos = null;
        try {
            bos = new BufferedOutputStream(new FileOutputStream(new File(pkg.getAbsolutePath())));
            bos.write(newFileContent.toString().getBytes());
        }
        catch (FileNotFoundException ex) {
            throw new BuildException((Throwable)ex);
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException ex) {
                    throw new BuildException((Throwable)ex);
                }
            }
        }
    }

    public File getWorkdir() {
        return this.workdir;
    }

    public void setWorkdir(File workdir) {
        this.workdir = workdir;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getAppname() {
        return this.appname;
    }

    public void setAppname(String appname) {
        this.appname = appname;
    }

    public String getAppicon() {
        return this.appicon;
    }

    public void setAppicon(String appicon) {
        this.appicon = appicon;
    }

    public File getCert() {
        return this.cert;
    }

    public void setCert(File cert) {
        this.cert = cert;
    }

    public File getKey() {
        return this.key;
    }

    public void setKey(File key) {
        this.key = key;
    }

    public String getPass() {
        return this.pass;
    }

    public void setPass(String pass) {
        this.pass = pass;
    }

    public File getDll() {
        return this.dll;
    }

    public void setDll(File dll) {
        this.dll = dll;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public File getLogo() {
        return this.logo;
    }

    public void setLogo(File logo) {
        this.logo = logo;
    }

    public boolean isLogoInstallOnly() {
        return this.logoInstallOnly;
    }

    public void setLogoInstallOnly(boolean logoInstallOnly) {
        this.logoInstallOnly = logoInstallOnly;
    }

    private static void copyFiles(File in, File out) throws IOException {
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            int read;
            bis = new BufferedInputStream(new FileInputStream(in));
            bos = new BufferedOutputStream(new FileOutputStream(out));
            byte[] data = new byte[1024];
            while ((read = bis.read(data)) != -1) {
                ((BufferedOutputStream)bos).write(data, 0, read);
            }
        }
        catch (IOException ioEx) {
            throw ioEx;
        }
        finally {
            if (bis != null) {
                bis.close();
            }
            if (bos != null) {
                bos.close();
            }
        }
    }
}

