/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.navigator;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.logging.Logger;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.LocalFileSystem;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;

public class ROUtil {
    private static final HashMap<File, WeakReference<LocalFileSystem>> cache = new HashMap();

    static FileObject checkPOMFileObjectReadOnly(FileObject fileObject, File file) {
        LocalFileSystem localFileSystem;
        FileObject fileObject2 = fileObject;
        if ("pom".equals(fileObject.getExt()) && (fileObject2 = (localFileSystem = ROUtil.checkFSCache(file)).findResource(ROUtil.getPath(file))) == null) {
            Logger.getLogger(ROUtil.class.getName()).info("Could not find a ReadOnly fileobject for " + ROUtil.getPath(file) + " in " + localFileSystem.getRootDirectory() + ": " + localFileSystem);
            fileObject2 = fileObject;
        }
        return fileObject2;
    }

    static DataObject checkPOMFileObjectReadOnly(DataObject dataObject) {
        DataObject dataObject2 = dataObject;
        FileObject fileObject = dataObject.getPrimaryFile();
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file != null) {
            fileObject = ROUtil.checkPOMFileObjectReadOnly(fileObject, file);
            try {
                dataObject2 = DataObject.find((FileObject)fileObject);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return dataObject2;
    }

    private static String getPath(File file) {
        File file2 = file.getParentFile();
        assert (file2 != null) : "wrong parent for " + file;
        File file3 = file2.getParentFile();
        assert (file3 != null) : "wrong parent for " + file2;
        return file3.getName() + "/" + file2.getName() + "/" + file.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LocalFileSystem checkFSCache(File file) {
        File file2 = file.getParentFile();
        assert (file2 != null) : "wrong parent for " + file;
        File file3 = file2.getParentFile();
        assert (file3 != null) : "wrong parent for " + file2;
        File file4 = file3.getParentFile();
        assert (file4 != null) : "wrong parent for " + file3;
        LocalFileSystem localFileSystem = null;
        HashMap<File, WeakReference<LocalFileSystem>> hashMap = cache;
        synchronized (hashMap) {
            WeakReference<LocalFileSystem> weakReference = cache.get(file4);
            if (weakReference != null) {
                localFileSystem = (LocalFileSystem)weakReference.get();
            }
            if (localFileSystem == null) {
                localFileSystem = new LocalFileSystem();
                localFileSystem.setReadOnly(true);
                try {
                    localFileSystem.setRootDirectory(file4);
                    cache.put(file4, new WeakReference<LocalFileSystem>(localFileSystem));
                }
                catch (PropertyVetoException propertyVetoException) {
                    Exceptions.printStackTrace((Throwable)propertyVetoException);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }
        return localFileSystem;
    }
}

