/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.runtime.scope;

import org.jruby.nb.parser.BlockStaticScope;
import org.jruby.nb.parser.StaticScope;
import org.jruby.nb.runtime.DynamicScope;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class NoVarsDynamicScope
extends DynamicScope {
    public NoVarsDynamicScope(StaticScope staticScope, DynamicScope dynamicScope) {
        super(staticScope, dynamicScope);
    }

    public NoVarsDynamicScope(StaticScope staticScope) {
        super(staticScope);
    }

    public void growIfNeeded() {
        assert (this.staticScope.getNumberOfVariables() == 0) : "NoVarsDynamicScope cannot be grown; use ManyVarsDynamicScope";
    }

    public DynamicScope cloneScope() {
        return new NoVarsDynamicScope(this.staticScope, this.parent);
    }

    public IRubyObject[] getValues() {
        return IRubyObject.NULL_ARRAY;
    }

    public IRubyObject getValue(int n, int n2) {
        return this.parent.getValue(n, n2 - 1);
    }

    public IRubyObject getValueOrNil(int n, int n2, IRubyObject iRubyObject) {
        return this.parent.getValueOrNil(n, n2 - 1, iRubyObject);
    }

    public IRubyObject getValueDepthZeroOrNil(int n, IRubyObject iRubyObject) {
        throw new RuntimeException(this.getClass().getSimpleName() + " does not support scopes with any variables");
    }

    public IRubyObject getValueZeroDepthZeroOrNil(IRubyObject iRubyObject) {
        throw new RuntimeException(this.getClass().getSimpleName() + " does not support scopes with one or more variables");
    }

    public IRubyObject getValueOneDepthZeroOrNil(IRubyObject iRubyObject) {
        throw new RuntimeException(this.getClass().getSimpleName() + " does not support scopes with two or more variables");
    }

    public IRubyObject getValueTwoDepthZeroOrNil(IRubyObject iRubyObject) {
        throw new RuntimeException(this.getClass().getSimpleName() + " does not support scopes with three or more variables");
    }

    public IRubyObject getValueThreeDepthZeroOrNil(IRubyObject iRubyObject) {
        throw new RuntimeException(this.getClass().getSimpleName() + " does not support scopes with four or more variables");
    }

    public IRubyObject setValue(int n, IRubyObject iRubyObject, int n2) {
        return this.parent.setValue(n, iRubyObject, n2 - 1);
    }

    public IRubyObject setValueDepthZero(IRubyObject iRubyObject, int n) {
        throw new RuntimeException(this.getClass().getSimpleName() + " does not support scopes with any variables");
    }

    public IRubyObject setValueZeroDepthZero(IRubyObject iRubyObject) {
        throw new RuntimeException(this.getClass().getSimpleName() + " does not support scopes with one or more variables");
    }

    public IRubyObject setValueOneDepthZero(IRubyObject iRubyObject) {
        throw new RuntimeException(this.getClass().getSimpleName() + " does not support scopes with two or more variables");
    }

    public IRubyObject setValueTwoDepthZero(IRubyObject iRubyObject) {
        throw new RuntimeException(this.getClass().getSimpleName() + " does not support scopes with three or more variables");
    }

    public IRubyObject setValueThreeDepthZero(IRubyObject iRubyObject) {
        throw new RuntimeException(this.getClass().getSimpleName() + " does not support scopes with four or more variables");
    }

    public void setArgValues(IRubyObject[] iRubyObjectArray, int n) {
        assert (n == 0) : "NoVarsDynamicScope only supports scopes with no variables";
    }

    public void setArgValues(IRubyObject iRubyObject) {
        assert (false) : "NoVarsDynamicScope does not support any variables";
    }

    public void setArgValues(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        assert (false) : "NoVarsDynamicScope does not support any variables";
    }

    public void setArgValues(IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        assert (false) : "NoVarsDynamicScope does not support any variables";
    }

    public IRubyObject[] getArgValues() {
        if (!this.staticScope.isArgumentScope()) {
            return this.parent.getArgValues();
        }
        int n = this.staticScope.getRequiredArgs() + this.staticScope.getOptionalArgs();
        assert (n == 0) : "NoVarsDynamicScope only supports scopes with no variables";
        return IRubyObject.NULL_ARRAY;
    }

    public String toString(StringBuffer stringBuffer, String string) {
        stringBuffer.append(string).append("Static Type[" + this.hashCode() + "]: " + (this.staticScope instanceof BlockStaticScope ? "block" : "local") + " []");
        if (this.parent != null) {
            stringBuffer.append("\n");
            this.parent.toString(stringBuffer, string + "  ");
        }
        return stringBuffer.toString();
    }
}

