/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.internal.runtime.methods;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.jruby.nb.RubyModule;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.anno.JavaMethodDescriptor;
import org.jruby.nb.internal.runtime.methods.CallConfiguration;
import org.jruby.nb.internal.runtime.methods.DynamicMethod;
import org.jruby.nb.internal.runtime.methods.ReflectedCompiledMethod;
import org.jruby.nb.internal.runtime.methods.ReflectedJavaMethod;
import org.jruby.nb.internal.runtime.methods.ReflectedJavaMultiMethod;
import org.jruby.nb.parser.StaticScope;
import org.jruby.nb.runtime.Arity;
import org.jruby.nb.runtime.MethodFactory;
import org.jruby.nb.runtime.Visibility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionMethodFactory
extends MethodFactory {
    @Override
    public DynamicMethod getCompiledMethodLazily(RubyModule rubyModule, String string, Arity arity, Visibility visibility, StaticScope staticScope, Object object, CallConfiguration callConfiguration) {
        return this.getCompiledMethod(rubyModule, string, arity, visibility, staticScope, object, callConfiguration);
    }

    @Override
    public DynamicMethod getCompiledMethod(RubyModule rubyModule, String string, Arity arity, Visibility visibility, StaticScope staticScope, Object object, CallConfiguration callConfiguration) {
        try {
            Method method = object.getClass().getMethod(string, COMPILED_METHOD_PARAMS);
            return new ReflectedCompiledMethod(rubyModule, arity, visibility, staticScope, object, method, callConfiguration);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException("No method with name " + string + " found in " + object.getClass());
        }
    }

    @Override
    public DynamicMethod getAnnotatedMethod(RubyModule rubyModule, JavaMethodDescriptor javaMethodDescriptor) {
        try {
            Method method = javaMethodDescriptor.getDeclaringClass().getDeclaredMethod(javaMethodDescriptor.name, javaMethodDescriptor.getParameterClasses());
            ReflectedJavaMethod reflectedJavaMethod = new ReflectedJavaMethod(rubyModule, method, javaMethodDescriptor.anno);
            reflectedJavaMethod.setJavaName(method.getName());
            reflectedJavaMethod.setSingleton(Modifier.isStatic(method.getModifiers()));
            reflectedJavaMethod.setCallConfig(CallConfiguration.getCallConfigByAnno(javaMethodDescriptor.anno));
            return reflectedJavaMethod;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public DynamicMethod getAnnotatedMethod(RubyModule rubyModule, List<JavaMethodDescriptor> list) {
        try {
            ArrayList<Method> arrayList = new ArrayList<Method>();
            ArrayList<JRubyMethod> arrayList2 = new ArrayList<JRubyMethod>();
            for (JavaMethodDescriptor object2 : list) {
                arrayList.add(object2.getDeclaringClass().getDeclaredMethod(object2.name, object2.getParameterClasses()));
                arrayList2.add(object2.anno);
            }
            Method method = (Method)arrayList.get(0);
            JRubyMethod jRubyMethod = (JRubyMethod)arrayList2.get(0);
            ReflectedJavaMultiMethod reflectedJavaMultiMethod = new ReflectedJavaMultiMethod(rubyModule, arrayList, arrayList2);
            reflectedJavaMultiMethod.setJavaName(method.getName());
            reflectedJavaMultiMethod.setSingleton(Modifier.isStatic(method.getModifiers()));
            reflectedJavaMultiMethod.setCallConfig(CallConfiguration.getCallConfigByAnno(jRubyMethod));
            return reflectedJavaMultiMethod;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    @Deprecated
    public void defineIndexedAnnotatedMethods(RubyModule rubyModule, Class clazz, MethodFactory.MethodDefiningCallback methodDefiningCallback) {
        Method[] methodArray;
        for (Method method : methodArray = clazz.getDeclaredMethods()) {
            JRubyMethod jRubyMethod = method.getAnnotation(JRubyMethod.class);
            if (jRubyMethod == null) continue;
            methodDefiningCallback.define(rubyModule, new JavaMethodDescriptor(method), this.getAnnotatedMethod(rubyModule, new JavaMethodDescriptor(method)));
        }
    }
}

