/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui.treelist;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jdesktop.swingx.painter.BusyPainter;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.painter.PainterIcon;
import org.netbeans.modules.kenai.ui.treelist.RendererPanel;
import org.netbeans.modules.kenai.ui.treelist.TreeLabel;
import org.netbeans.modules.kenai.ui.treelist.TreeListListener;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TreeListNode {
    public static final long TIMEOUT_INTERVAL_MILLIS = NbPreferences.forModule(TreeListNode.class).getInt("node.expand.timeoutmillis", 300000);
    private final boolean expandable;
    private final TreeListNode parent;
    private TreeListListener listener;
    private boolean expanded = false;
    private ArrayList<TreeListNode> children = null;
    private final Object LOCK = new Object();
    private RendererPanel renderer;
    private ChildrenLoader loader;

    public TreeListNode(boolean bl, TreeListNode treeListNode) {
        this.expandable = bl;
        this.parent = treeListNode;
    }

    public final boolean isExpandable() {
        return this.expandable;
    }

    public final TreeListNode getParent() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<TreeListNode> getChildren() {
        Object object = this.LOCK;
        synchronized (object) {
            if (null == this.children) {
                return Collections.emptyList();
            }
            return new ArrayList<TreeListNode>(this.children);
        }
    }

    public Action[] getPopupActions() {
        return null;
    }

    protected abstract List<TreeListNode> createChildren();

    protected final void refreshChildren() {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = TreeListNode.this.LOCK;
                synchronized (object) {
                    if (null != TreeListNode.this.children) {
                        for (TreeListNode treeListNode : TreeListNode.this.children) {
                            treeListNode.dispose();
                        }
                        TreeListNode.this.children = null;
                        if (null != TreeListNode.this.listener) {
                            TreeListNode.this.listener.childrenRemoved(TreeListNode.this);
                        }
                    }
                    if (TreeListNode.this.expanded) {
                        TreeListNode.this.startLoadingChildren();
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final JComponent getRenderer(Color color, Color color2, boolean bl, boolean bl2, int n) {
        RendererPanel rendererPanel = null;
        TreeListNode treeListNode = this;
        synchronized (treeListNode) {
            if (null == this.renderer) {
                this.renderer = new RendererPanel(this);
            }
            rendererPanel = this.renderer;
        }
        rendererPanel.configure(color, color2, bl, bl2, this.getNestingDepth(), n);
        return rendererPanel;
    }

    protected abstract JComponent getComponent(Color var1, Color var2, boolean var3, boolean var4);

    protected Action getDefaultAction() {
        return null;
    }

    protected void childrenLoadingStarted() {
    }

    protected void childrenLoadingFinished() {
    }

    protected void childrenLoadingTimedout() {
    }

    final void setListener(TreeListListener treeListListener) {
        this.listener = treeListListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispose() {
        Object object = this.LOCK;
        synchronized (object) {
            this.listener = null;
            if (null != this.children) {
                for (TreeListNode treeListNode : this.children) {
                    treeListNode.dispose();
                }
            }
        }
    }

    final boolean isDescendantOf(TreeListNode treeListNode) {
        if (null == this.parent) {
            return false;
        }
        if (this.parent.equals(treeListNode)) {
            return true;
        }
        return this.parent.isDescendantOf(treeListNode);
    }

    final boolean isExpanded() {
        return this.expanded && this.isExpandable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setExpanded(boolean bl) {
        if (!this.isExpandable()) {
            throw new IllegalStateException();
        }
        if (this.expanded == bl) {
            return;
        }
        this.expanded = bl;
        if (null != this.listener) {
            if (this.expanded) {
                boolean bl2 = true;
                Object object = this.LOCK;
                synchronized (object) {
                    if (null == this.children) {
                        bl2 = false;
                        this.startLoadingChildren();
                    }
                }
                if (bl2) {
                    this.listener.childrenAdded(this);
                }
            } else {
                Object object = this.LOCK;
                synchronized (object) {
                    if (null != this.loader) {
                        this.loader.cancel();
                        this.childrenLoadingFinished();
                    }
                }
                this.listener.childrenRemoved(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireContentChanged() {
        TreeListNode treeListNode = this;
        synchronized (treeListNode) {
            this.renderer = null;
        }
        if (null != this.listener) {
            this.listener.contentChanged(this);
        }
    }

    protected final JLabel createProgressLabel() {
        return this.createProgressLabel(NbBundle.getMessage(TreeListNode.class, (String)"LBL_LoadingInProgress"));
    }

    protected final JLabel createProgressLabel(String string) {
        return new ProgressLabel(string);
    }

    final int getNestingDepth() {
        if (null == this.getParent()) {
            return 0;
        }
        return this.getParent().getNestingDepth() + 1;
    }

    private void startLoadingChildren() {
        this.childrenLoadingStarted();
        if (null != this.loader) {
            this.loader.cancel();
        }
        this.loader = new ChildrenLoader();
        RequestProcessor.getDefault().post((Runnable)this.loader);
    }

    private class ProgressLabel
    extends TreeLabel {
        private int frame;
        private Timer t;
        final BusyPainter painter;

        public ProgressLabel(String string) {
            super(string);
            this.frame = 0;
            this.painter = new BusyPainter(16);
            PainterIcon painterIcon = new PainterIcon(new Dimension(16, 16));
            painterIcon.setPainter((Painter)this.painter);
            this.setIcon((Icon)painterIcon);
            this.t = new Timer(100, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ProgressLabel.this.frame = (ProgressLabel.this.frame + 1) % ProgressLabel.this.painter.getPoints();
                    ProgressLabel.this.painter.setFrame(ProgressLabel.this.frame);
                    ProgressLabel.this.repaint();
                    TreeListNode.this.fireContentChanged();
                }
            });
            this.t.setRepeats(true);
            super.setVisible(false);
        }

        public void setVisible(boolean bl) {
            boolean bl2 = this.isVisible();
            super.setVisible(bl);
            if (bl2 != bl) {
                if (bl) {
                    this.t.start();
                } else {
                    this.t.stop();
                }
            }
        }
    }

    private class ChildrenLoader
    implements Runnable,
    Cancellable {
        private boolean cancelled = false;
        private Thread t = null;

        private ChildrenLoader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            final List[] listArray = new ArrayList[1];
            Runnable runnable = new Runnable(){

                public void run() {
                    listArray[0] = TreeListNode.this.createChildren();
                }
            };
            this.t = new Thread(runnable);
            this.t.start();
            try {
                this.t.join(TIMEOUT_INTERVAL_MILLIS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.cancelled) {
                return;
            }
            if (null == listArray[0]) {
                TreeListNode.this.childrenLoadingTimedout();
                return;
            }
            Object object = TreeListNode.this.LOCK;
            synchronized (object) {
                TreeListNode.this.children = new ArrayList(listArray[0]);
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (null != TreeListNode.this.listener) {
                        TreeListNode.this.listener.childrenAdded(TreeListNode.this);
                    }
                }
            });
            TreeListNode.this.childrenLoadingFinished();
        }

        public boolean cancel() {
            this.cancelled = true;
            if (null != this.t) {
                this.t.interrupt();
            }
            return true;
        }
    }
}

