/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbverification;

import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;

public class JavaUtils {
    public static String extractClassNameFromType(TypeMirror typeMirror) {
        Element element;
        if (typeMirror instanceof DeclaredType && ((element = ((DeclaredType)typeMirror).asElement()).getKind() == ElementKind.CLASS || element.getKind() == ElementKind.INTERFACE)) {
            return ((TypeElement)element).getQualifiedName().toString();
        }
        return null;
    }

    public static boolean hasAnnotation(Element element, String string) {
        AnnotationMirror annotationMirror = JavaUtils.findAnnotation(element, string);
        return annotationMirror != null;
    }

    public static AnnotationMirror findAnnotation(Element element, String string) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!string.equals(annotationMirror.getAnnotationType().toString())) continue;
            return annotationMirror;
        }
        return null;
    }

    public static AnnotationValue getAnnotationAttrValue(AnnotationMirror annotationMirror, String string) {
        if (annotationMirror != null) {
            for (ExecutableElement executableElement : annotationMirror.getElementValues().keySet()) {
                if (!string.equals(executableElement.getSimpleName().toString())) continue;
                return annotationMirror.getElementValues().get(executableElement);
            }
        }
        return null;
    }

    public static String getShortClassName(String string) {
        return string.substring(string.lastIndexOf(".") + 1);
    }

    public static boolean isMethodSignatureSame(CompilationInfo compilationInfo, ExecutableElement executableElement, ExecutableElement executableElement2) {
        int n = executableElement.getParameters().size();
        if (n != executableElement2.getParameters().size()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            TypeMirror typeMirror = executableElement.getParameters().get(i).asType();
            TypeMirror typeMirror2 = executableElement2.getParameters().get(i).asType();
            if (compilationInfo.getTypes().isSameType(typeMirror, typeMirror2)) continue;
            return false;
        }
        return true;
    }
}

