/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen.java;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Modifier;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.xml.namespace.QName;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.websvc.saas.codegen.Constants;
import org.netbeans.modules.websvc.saas.codegen.SaasClientAuthenticationGenerator;
import org.netbeans.modules.websvc.saas.codegen.SaasClientCodeGenerator;
import org.netbeans.modules.websvc.saas.codegen.java.SaasClientJavaAuthenticationGenerator;
import org.netbeans.modules.websvc.saas.codegen.java.WadlSaasEx;
import org.netbeans.modules.websvc.saas.codegen.java.support.AbstractTask;
import org.netbeans.modules.websvc.saas.codegen.java.support.JavaSourceHelper;
import org.netbeans.modules.websvc.saas.codegen.java.support.JavaUtil;
import org.netbeans.modules.websvc.saas.codegen.java.support.SourceGroupSupport;
import org.netbeans.modules.websvc.saas.codegen.model.ParameterInfo;
import org.netbeans.modules.websvc.saas.codegen.model.RestClientSaasBean;
import org.netbeans.modules.websvc.saas.codegen.model.SaasBean;
import org.netbeans.modules.websvc.saas.codegen.util.Util;
import org.netbeans.modules.websvc.saas.model.SaasMethod;
import org.netbeans.modules.websvc.saas.model.WadlSaasMethod;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestClientPojoCodeGenerator
extends SaasClientCodeGenerator {
    private JavaSource targetSource;
    private FileObject saasServiceFile = null;
    private JavaSource saasServiceJS = null;
    private FileObject serviceFolder = null;
    private SaasClientJavaAuthenticationGenerator authGen;

    public RestClientPojoCodeGenerator() {
        this.setDropFileType(Constants.DropFileType.JAVA_CLIENT);
    }

    public boolean canAccept(SaasMethod saasMethod, Document document) {
        return SaasBean.canAccept((SaasMethod)saasMethod, WadlSaasMethod.class, (Constants.DropFileType)this.getDropFileType()) && Util.isJava((Document)document);
    }

    public void init(SaasMethod saasMethod, Document document) throws IOException {
        this.init(saasMethod, new RestClientSaasBean((WadlSaasMethod)saasMethod), document);
    }

    public void init(SaasMethod saasMethod, RestClientSaasBean restClientSaasBean, Document document) throws IOException {
        super.init(saasMethod, document);
        this.setBean((SaasBean)restClientSaasBean);
        this.targetSource = JavaSource.forFileObject((FileObject)this.getTargetFile());
        String string = JavaSourceHelper.getPackageName(this.targetSource);
        this.getBean().setPackageName(string);
        this.serviceFolder = null;
        this.saasServiceFile = SourceGroupSupport.findJavaSourceFile(this.getProject(), this.getBean().getSaasServiceName());
        if (this.saasServiceFile != null) {
            this.saasServiceJS = JavaSource.forFileObject((FileObject)this.saasServiceFile);
        }
        this.authGen = new SaasClientJavaAuthenticationGenerator((SaasBean)this.getBean(), this.getProject());
        this.authGen.setLoginArguments(this.getLoginArguments());
        this.authGen.setAuthenticatorMethodParameters(this.getAuthenticatorMethodParameters());
        this.authGen.setSaasServiceFolder(this.getSaasServiceFolder());
        this.getBean();
        this.authGen.setAuthenticationProfile(RestClientSaasBean.getProfile((SaasMethod)saasMethod, (Constants.DropFileType)this.getDropFileType()));
        this.authGen.setDropFileType(this.getDropFileType());
    }

    protected JavaSource getTargetSource() {
        return this.targetSource;
    }

    public SaasClientAuthenticationGenerator getAuthenticationGenerator() {
        return this.authGen;
    }

    public JavaSource getSaasServiceSource() {
        return this.saasServiceJS;
    }

    public FileObject getSaasServiceFolder() throws IOException {
        if (this.serviceFolder == null) {
            SourceGroup[] sourceGroupArray = SourceGroupSupport.getJavaSourceGroups(this.getProject());
            this.serviceFolder = SourceGroupSupport.getFolderForPackage(sourceGroupArray[0], this.getBean().getSaasServicePackageName(), true);
        }
        return this.serviceFolder;
    }

    public RestClientSaasBean getBean() {
        return (RestClientSaasBean)super.getBean();
    }

    protected void preGenerate() throws IOException {
        super.preGenerate();
        this.addJaxbLib();
        this.createRestConnectionFile(this.getProject());
        if (this.getBean().getMethod().getSaas().getLibraryJars() == null) {
            WadlSaasEx wadlSaasEx = new WadlSaasEx(this.getBean().getMethod().getSaas());
            this.getBean().getMethod().getSaas().setLibraryJars(wadlSaasEx.getLibraryJars());
            this.getBean().getMethod().getSaas().setJaxbSourceJars(wadlSaasEx.getJaxbSourceJars());
        }
        if (this.getBean().getMethod().getSaas().getLibraryJars().size() > 0) {
            JavaUtil.addClientJars((SaasBean)this.getBean(), this.getProject(), null);
        }
    }

    public Set<FileObject> generate() throws IOException {
        this.preGenerate();
        this.getAuthenticationGenerator().createAuthenticatorClass();
        this.getAuthenticationGenerator().createAuthorizationClasses();
        this.createSaasServiceClass();
        this.addSaasServiceMethod();
        this.addImportsToSaasService();
        this.getAuthenticationGenerator().modifyAuthenticationClass();
        this.setJaxbWrapper();
        this.insertSaasServiceAccessCode(this.isInBlock(this.getTargetDocument()));
        this.addImportsToTargetFile();
        this.finishProgressReporting();
        return new HashSet<FileObject>(Collections.EMPTY_LIST);
    }

    private void setJaxbWrapper() {
        this.getBean();
        List list = RestClientSaasBean.findRepresentationTypes((WadlSaasMethod)this.getBean().getMethod());
        if (!list.isEmpty()) {
            for (QName qName : list) {
                String string = qName.getNamespaceURI();
                this.getBean().addOutputWrapperName(qName.getLocalPart());
                this.getBean().addOutputWrapperPackageName((this.getBean().getGroupName() + "." + this.getBean().getDisplayName()).toLowerCase() + "." + string.substring(string.lastIndexOf(":") + 1).toLowerCase());
            }
        }
    }

    protected void addJaxbLib() throws IOException {
        JavaUtil.addJaxbLib(this.getProject());
    }

    protected String getCustomMethodBody() throws IOException {
        String string = "";
        String string2 = "";
        List<ParameterInfo> list = this.getServiceMethodParameters();
        this.clearVariablePatterns();
        this.updateVariableNames(list);
        List list2 = this.renameParameterNames(list);
        string = string + Util.getHeaderOrParameterUsage((List)list2);
        string2 = string2 + this.getHeaderOrParameterDeclaration(list2);
        String string3 = "\n        try {\n";
        string3 = string3 + string2 + "\n";
        string3 = string3 + "             RestResponse " + this.getResultPattern() + " = " + this.getBean().getSaasServiceName() + "." + this.getBean().getSaasServiceMethodName() + "(" + string + ");\n";
        string3 = string3 + Util.createPrintStatement((List)this.getBean().getOutputWrapperPackageNames(), (List)this.getBean().getOutputWrapperNames(), (Constants.DropFileType)this.getDropFileType(), (Constants.HttpMethodType)this.getBean().getHttpMethod(), (boolean)this.getBean().canGenerateJAXBUnmarshaller(), (String)this.getResultPattern(), (String)"             ");
        string3 = string3 + "        } catch (Exception ex) {\n";
        string3 = string3 + "             ex.printStackTrace();\n";
        string3 = string3 + "        }\n";
        return string3;
    }

    protected String getServiceMethodBody() throws IOException {
        String string = "";
        string = string + "        " + this.getFixedParameterDeclaration();
        string = string + "             " + this.getAuthenticationGenerator().getPreAuthenticationCode() + "\n";
        string = string + "        " + this.getTemplateParameterDefinition(this.getBean().getTemplateParameters(), "pathParams", false);
        string = string + "        " + Util.getHeaderOrParameterDefinition((List)this.getBean().getQueryParameters(), (String)"queryParams", (boolean)false);
        string = string + "             RestConnection conn = new RestConnection(\"" + this.getBean().getUrl() + "\"";
        string = string + ", pathParams";
        string = string + ", " + (!Util.isPutPostFormParams((RestClientSaasBean)this.getBean()) ? "queryParams" : "null");
        string = string + ");\n";
        string = string + "             " + this.getAuthenticationGenerator().getPostAuthenticationCode() + "\n";
        Constants.HttpMethodType httpMethodType = this.getBean().getHttpMethod();
        String string2 = "null";
        if (this.getBean().getHeaderParameters() != null && this.getBean().getHeaderParameters().size() > 0) {
            string2 = "headerParams";
            string = string + "        " + Util.getHeaderOrParameterDefinition((List)this.getBean().getHeaderParameters(), (String)"headerParams", (boolean)false, (Constants.HttpMethodType)httpMethodType);
        }
        string = string + "             sleep(1000);\n";
        string = string + "             return conn." + httpMethodType.prefix() + "(" + string2;
        if (httpMethodType == Constants.HttpMethodType.PUT || httpMethodType == Constants.HttpMethodType.POST) {
            if (Util.isPutPostFormParams((RestClientSaasBean)this.getBean())) {
                string = string + ", queryParams";
            } else if (Util.hasInputRepresentations((RestClientSaasBean)this.getBean())) {
                string = string + ", content";
            }
        }
        string = string + ");\n";
        return string;
    }

    protected String getFixedParameterDeclaration() {
        String string = "";
        List list = null;
        Constants.SaasAuthenticationType saasAuthenticationType = this.getBean().getAuthenticationType();
        if (saasAuthenticationType == Constants.SaasAuthenticationType.SESSION_KEY) {
            SaasBean.SessionKeyAuthentication sessionKeyAuthentication = (SaasBean.SessionKeyAuthentication)this.getBean().getAuthentication();
            list = sessionKeyAuthentication.getParameters();
        } else {
            list = Collections.emptyList();
        }
        for (ParameterInfo parameterInfo : this.getBean().getInputParameters()) {
            if (!parameterInfo.isFixed() || Util.isContains((ParameterInfo)parameterInfo, (List)list)) continue;
            string = string + "String " + this.getVariableName(parameterInfo.getName()) + " = \"" + this.findParamValue(parameterInfo) + "\";\n";
        }
        return string;
    }

    protected List<ParameterInfo> getServiceMethodParameters() {
        return Util.getRestClientMethodParameters((RestClientSaasBean)this.getBean());
    }

    protected List<ParameterInfo> getAuthenticatorMethodParameters() {
        return Collections.emptyList();
    }

    protected String getLoginArguments() {
        return "";
    }

    protected void addImportsToTargetFile() throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getBean().getSaasServicePackageName() + "." + this.getBean().getSaasServiceName());
        arrayList.add("org.netbeans.saas.RestResponse");
        JavaUtil.addImportsToSource(this.getTargetSource(), arrayList);
    }

    protected void addImportsToSaasService() throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("org.netbeans.saas.RestConnection");
        arrayList.add("org.netbeans.saas.RestResponse");
        JavaUtil.addImportsToSource(this.saasServiceJS, arrayList);
    }

    protected void insertSaasServiceAccessCode(boolean bl) throws IOException {
        try {
            String string = "";
            if (bl) {
                string = this.getCustomMethodBody();
            } else {
                string = "\nprivate String call" + this.getBean().getName() + "Service() {\n";
                string = string + this.getCustomMethodBody() + "\n";
                string = string + "return " + this.getResultPattern() + ";\n";
                string = string + "}\n";
            }
            this.insert(string, true);
        }
        catch (BadLocationException badLocationException) {
            throw new IOException(badLocationException.getMessage());
        }
    }

    public void createSaasServiceClass() throws IOException {
        if (this.saasServiceFile == null) {
            SourceGroup[] sourceGroupArray = SourceGroupSupport.getJavaSourceGroups(this.getProject());
            String string = this.getBean().getSaasServicePackageName();
            FileObject fileObject = SourceGroupSupport.getFolderForPackage(sourceGroupArray[0], string, true);
            this.saasServiceJS = JavaSourceHelper.createJavaSource(this.getBean().getSaasServiceTemplate() + "." + "java", fileObject, string, this.getBean().getSaasServiceName());
            HashSet hashSet = new HashSet(this.saasServiceJS.getFileObjects());
            if (hashSet != null && hashSet.size() > 0) {
                this.saasServiceFile = (FileObject)hashSet.iterator().next();
            }
        }
    }

    protected void addSaasServiceMethod() throws IOException {
        List<ParameterInfo> list = this.getServiceMethodParameters();
        final String[] stringArray = this.getGetParamNames(list);
        final Object[] objectArray = this.getGetParamTypes(list);
        if (JavaSourceHelper.isContainsMethod(this.saasServiceJS, this.getBean().getSaasServiceMethodName(), stringArray, objectArray)) {
            return;
        }
        ModificationResult modificationResult = this.saasServiceJS.runModificationTask((Task)new AbstractTask<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                Modifier[] modifierArray = JavaUtil.PUBLIC_STATIC;
                String string = "RestResponse";
                String string2 = "{ \n" + RestClientPojoCodeGenerator.this.getServiceMethodBody() + "\n }";
                String string3 = "\n";
                for (String string4 : stringArray) {
                    string3 = string3 + "@param $PARAM$ \n".replace("$PARAM$", string4);
                }
                string3 = string3 + "@return an instance of " + string;
                ClassTree classTree = JavaSourceHelper.getTopLevelClassTree((CompilationController)workingCopy);
                ClassTree classTree2 = JavaSourceHelper.addMethod(workingCopy, classTree, modifierArray, null, null, RestClientPojoCodeGenerator.this.getBean().getSaasServiceMethodName(), string, stringArray, objectArray, null, null, new String[]{"java.io.IOException"}, string2, string3);
                workingCopy.rewrite((Tree)classTree, (Tree)classTree2);
            }
        });
        modificationResult.commit();
    }

    public ParameterInfo findParameter(String string) {
        List list = this.getBean().getInputParameters();
        if (list != null) {
            for (ParameterInfo parameterInfo : list) {
                if (!parameterInfo.getName().equals(string)) continue;
                return parameterInfo;
            }
        }
        return null;
    }

    protected String getHeaderOrParameterDeclaration(List<ParameterInfo> list, String string) {
        if (string == null) {
            string = " ";
        }
        String string2 = "";
        for (ParameterInfo parameterInfo : list) {
            String string3 = this.getVariableName(parameterInfo.getName());
            String string4 = this.findParamValue(parameterInfo);
            if (parameterInfo.getType() != String.class) {
                string2 = string2 + string + parameterInfo.getType().getName() + " " + string3 + " = " + string4 + ";\n";
                continue;
            }
            if (string4 != null) {
                string2 = string2 + string + "String " + string3 + " = \"" + string4 + "\";\n";
                continue;
            }
            string2 = string2 + string + "String " + string3 + " = null;\n";
        }
        return string2;
    }

    protected String getHeaderOrParameterDeclaration(List<ParameterInfo> list) {
        String string = "                 ";
        return this.getHeaderOrParameterDeclaration(list, string);
    }

    private String getTemplateParameterDefinition(List<ParameterInfo> list, String string, boolean bl) {
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        for (ParameterInfo parameterInfo : list) {
            String string3 = this.getParameterName(parameterInfo);
            String string4 = null;
            if (bl) {
                string4 = this.findParamValue(parameterInfo);
                if (parameterInfo.getType() != String.class) {
                    stringBuffer.append("{\"" + string3 + "\", \"" + string4 + "\".toString()},\n");
                    continue;
                }
                if (string4 != null) {
                    stringBuffer.append("{\"{" + string3 + "}\", \"" + string4 + "\"},\n");
                    continue;
                }
                stringBuffer.append("{\"{" + string3 + "}\", null},\n");
                continue;
            }
            stringBuffer.append("{\"{" + string3 + "}\", " + string3 + "},\n");
        }
        string2 = stringBuffer.toString();
        if (list.size() > 0) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        Object object = "";
        object = (String)object + "             String[][] " + string + " = new String[][]{\n";
        object = (String)object + "                 " + string2 + "\n";
        object = (String)object + "             };\n";
        return object;
    }

    private String findParamValue(ParameterInfo parameterInfo) {
        return Util.findParamValue((ParameterInfo)parameterInfo);
    }

    protected void createRestConnectionFile(Project project) throws IOException {
        SourceGroup[] sourceGroupArray = SourceGroupSupport.getJavaSourceGroups(project);
        String string = "org.netbeans.saas";
        FileObject fileObject = SourceGroupSupport.getFolderForPackage(sourceGroupArray[0], string, true);
        JavaSourceHelper.createJavaSource("Templates/SaaSServices/RestConnection.java", fileObject, string, "RestConnection");
        String string2 = "Templates/SaaSServices/RestResponse.java";
        JavaSource javaSource = JavaSourceHelper.createJavaSource(string2, fileObject, string, "RestResponse");
    }
}

