/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client.cli.commands;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.subversion.client.cli.SvnCommand;

public class VersionCommand
extends SvnCommand {
    private List<String> output = new ArrayList<String>();
    private boolean unsupportedVersion = false;

    protected int getCommand() {
        return 0;
    }

    public void prepareCommand(SvnCommand.Arguments arguments) throws IOException {
        arguments.add("--version");
    }

    protected void config(File file, String string, String string2, SvnCommand.Arguments arguments) {
        arguments.addConfigDir(file);
    }

    public void outputText(String string) {
        if (string == null || string.trim().equals("")) {
            return;
        }
        this.output.add(string);
        super.outputText(string);
    }

    public boolean checkForErrors() {
        Integer n = this.getExitCode();
        if (n == null || !n.equals(0)) {
            return false;
        }
        boolean bl = false;
        for (String string : this.output) {
            if ((string = string.trim()).length() == 0) continue;
            bl = true;
            if (string.indexOf("version 0.") <= -1 && string.indexOf("version 1.0") <= -1 && string.indexOf("version 1.1") <= -1 && string.indexOf("version 1.2") <= -1) continue;
            this.unsupportedVersion = true;
            return false;
        }
        return bl;
    }

    public boolean isUnsupportedVersion() {
        return this.unsupportedVersion;
    }

    public boolean isSupportedJavaHl() {
        for (String string : this.output) {
            if (string.indexOf("version 1.3") <= -1 && string.indexOf("version 1.4") <= -1 && string.indexOf("version 1.5") <= -1) continue;
            return true;
        }
        return false;
    }

    public String getOutput() {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this.output) {
            stringBuffer.append(string);
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }
}

