/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.codegen;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class DatabaseURL {
    public static DatabaseURL detect(String string) {
        MySQLURL mySQLURL = new MySQLURL(string);
        return mySQLURL.matches() ? mySQLURL : null;
    }

    abstract boolean matches();

    public abstract Server getServer();

    public abstract String getHost();

    public abstract String getPort();

    public abstract String getDatabase();

    private static final class MySQLURL
    extends DatabaseURL {
        private static final Pattern PATTERN = Pattern.compile("jdbc:mysql://([^/]+)(/(.*))?");
        private final String url;
        private final Matcher matcher;
        private String host;
        private String port;

        public MySQLURL(String string) {
            this.url = string;
            this.matcher = PATTERN.matcher(string);
        }

        boolean matches() {
            boolean bl = this.matcher.matches();
            if (bl) {
                String string = this.matcher.group(1);
                if (string != null) {
                    String[] stringArray = string.split(":");
                    this.host = stringArray[0].trim();
                    if (stringArray.length > 1) {
                        this.port = stringArray[1].trim();
                    }
                }
                if (this.host == null || this.host.length() == 0) {
                    bl = false;
                }
            }
            return bl;
        }

        public Server getServer() {
            return Server.MYSQL;
        }

        public String getHost() {
            return this.host;
        }

        public String getPort() {
            return this.port;
        }

        public String getDatabase() {
            String string = this.matcher.group(3);
            if (string == null) {
                return null;
            }
            if ((string = string.trim()).length() == 0) {
                return null;
            }
            return string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Server {
        MYSQL;

    }
}

