/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.nav.NavUtils;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.api.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTError;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.InterfaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CompletionContextFinder {
    private static final String NAMESPACE_FALSE_TOKEN = "NAMESPACE_FALSE_TOKEN";
    private static final List<Object[]> CLASS_NAME_TOKENCHAINS = Arrays.asList({PHPTokenId.PHP_NEW}, {PHPTokenId.PHP_NEW, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_NEW, PHPTokenId.WHITESPACE, "NAMESPACE_FALSE_TOKEN"}, {PHPTokenId.PHP_NEW, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING});
    private static final List<Object[]> FUNCTION_NAME_TOKENCHAINS = Arrays.asList({PHPTokenId.PHP_FUNCTION}, {PHPTokenId.PHP_FUNCTION, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_FUNCTION, PHPTokenId.WHITESPACE, "NAMESPACE_FALSE_TOKEN"}, {PHPTokenId.PHP_FUNCTION, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING});
    private static final List<Object[]> USE_KEYWORD_TOKENS = Arrays.asList({PHPTokenId.PHP_USE}, {PHPTokenId.PHP_USE, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_USE, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_USE, PHPTokenId.WHITESPACE, "NAMESPACE_FALSE_TOKEN"});
    private static final List<Object[]> NAMESPACE_KEYWORD_TOKENS = Arrays.asList({PHPTokenId.PHP_NAMESPACE}, {PHPTokenId.PHP_NAMESPACE, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_NAMESPACE, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_NAMESPACE, PHPTokenId.WHITESPACE, "NAMESPACE_FALSE_TOKEN"});
    private static final List<Object[]> INSTANCEOF_TOKENCHAINS = Arrays.asList({PHPTokenId.PHP_INSTANCEOF}, {PHPTokenId.PHP_INSTANCEOF, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_INSTANCEOF, PHPTokenId.WHITESPACE, "NAMESPACE_FALSE_TOKEN"}, {PHPTokenId.PHP_INSTANCEOF, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING});
    private static final List<Object[]> CATCH_TOKENCHAINS = Arrays.asList({PHPTokenId.PHP_CATCH, PHPTokenId.PHP_TOKEN}, {PHPTokenId.PHP_CATCH, PHPTokenId.PHP_TOKEN, "NAMESPACE_FALSE_TOKEN"}, {PHPTokenId.PHP_CATCH, PHPTokenId.WHITESPACE, PHPTokenId.PHP_TOKEN}, {PHPTokenId.PHP_CATCH, PHPTokenId.WHITESPACE, PHPTokenId.PHP_TOKEN, "NAMESPACE_FALSE_TOKEN"}, {PHPTokenId.PHP_CATCH, PHPTokenId.WHITESPACE, PHPTokenId.PHP_TOKEN, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_CATCH, PHPTokenId.WHITESPACE, PHPTokenId.PHP_TOKEN, PHPTokenId.WHITESPACE, "NAMESPACE_FALSE_TOKEN"}, {PHPTokenId.PHP_CATCH, PHPTokenId.WHITESPACE, PHPTokenId.PHP_TOKEN, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_INSTANCEOF, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_INSTANCEOF, PHPTokenId.WHITESPACE, "NAMESPACE_FALSE_TOKEN"}, {PHPTokenId.PHP_INSTANCEOF, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING});
    private static final List<Object[]> CLASS_MEMBER_TOKENCHAINS = Arrays.asList({PHPTokenId.PHP_OBJECT_OPERATOR}, {PHPTokenId.PHP_OBJECT_OPERATOR, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_OBJECT_OPERATOR, PHPTokenId.PHP_VARIABLE}, {PHPTokenId.PHP_OBJECT_OPERATOR, PHPTokenId.PHP_TOKEN}, {PHPTokenId.PHP_OBJECT_OPERATOR, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_OBJECT_OPERATOR, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_OBJECT_OPERATOR, PHPTokenId.WHITESPACE, PHPTokenId.PHP_VARIABLE}, {PHPTokenId.PHP_OBJECT_OPERATOR, PHPTokenId.WHITESPACE, PHPTokenId.PHP_TOKEN});
    private static final List<Object[]> STATIC_CLASS_MEMBER_TOKENCHAINS = Arrays.asList({PHPTokenId.PHP_PAAMAYIM_NEKUDOTAYIM}, {PHPTokenId.PHP_PAAMAYIM_NEKUDOTAYIM, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_PAAMAYIM_NEKUDOTAYIM, PHPTokenId.PHP_VARIABLE}, {PHPTokenId.PHP_PAAMAYIM_NEKUDOTAYIM, PHPTokenId.PHP_TOKEN}, {PHPTokenId.PHP_PAAMAYIM_NEKUDOTAYIM, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_PAAMAYIM_NEKUDOTAYIM, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_PAAMAYIM_NEKUDOTAYIM, PHPTokenId.WHITESPACE, PHPTokenId.PHP_VARIABLE}, {PHPTokenId.PHP_PAAMAYIM_NEKUDOTAYIM, PHPTokenId.WHITESPACE, PHPTokenId.PHP_TOKEN});
    private static final PHPTokenId[] COMMENT_TOKENS = new PHPTokenId[]{PHPTokenId.PHP_COMMENT_START, PHPTokenId.PHP_COMMENT, PHPTokenId.PHP_LINE_COMMENT, PHPTokenId.PHP_COMMENT_END};
    private static final List<Object[]> PHPDOC_TOKENCHAINS = Arrays.asList({PHPTokenId.PHPDOC_COMMENT_START}, {PHPTokenId.PHPDOC_COMMENT});
    private static final List<Object[]> FUNCTION_TOKENCHAINS = Arrays.asList({PHPTokenId.PHP_FUNCTION}, {PHPTokenId.PHP_FUNCTION, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_FUNCTION, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING});
    private static final List<Object[]> CLASS_CONTEXT_KEYWORDS_TOKENCHAINS = Arrays.asList({PHPTokenId.PHP_PRIVATE}, {PHPTokenId.PHP_PRIVATE, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_PRIVATE, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_PROTECTED}, {PHPTokenId.PHP_PROTECTED, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_PROTECTED, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_PUBLIC}, {PHPTokenId.PHP_PUBLIC, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_PUBLIC, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_STATIC}, {PHPTokenId.PHP_STATIC, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_STATIC, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_ABSTRACT}, {PHPTokenId.PHP_ABSTRACT, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_ABSTRACT, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_FINAL}, {PHPTokenId.PHP_FINAL, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_FINAL, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_CURLY_OPEN}, {PHPTokenId.PHP_LINE_COMMENT}, {PHPTokenId.PHP_LINE_COMMENT, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_LINE_COMMENT, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_COMMENT_END}, {PHPTokenId.PHP_COMMENT_END, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_COMMENT_END, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_COMMENT_END, PHPTokenId.PHP_STRING}, {PHPTokenId.PHPDOC_COMMENT_END}, {PHPTokenId.PHPDOC_COMMENT_END, PHPTokenId.WHITESPACE}, {PHPTokenId.PHPDOC_COMMENT_END, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHPDOC_COMMENT_END, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_CURLY_CLOSE}, {PHPTokenId.PHP_CURLY_CLOSE, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_CURLY_CLOSE, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_CURLY_OPEN}, {PHPTokenId.PHP_CURLY_OPEN, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_CURLY_OPEN, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_SEMICOLON}, {PHPTokenId.PHP_SEMICOLON, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_SEMICOLON, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING});
    private static final List<Object[]> SERVER_ARRAY_TOKENCHAINS = Collections.singletonList(new Object[]{PHPTokenId.PHP_VARIABLE, PHPTokenId.PHP_TOKEN});
    private static final List<String> SERVER_ARRAY_TOKENTEXTS = Arrays.asList("$_SERVER", "[");
    static final Collection<PHPTokenId> CTX_DELIMITERS = Arrays.asList(PHPTokenId.PHP_SEMICOLON, PHPTokenId.PHP_CURLY_OPEN, PHPTokenId.PHP_CURLY_CLOSE, PHPTokenId.PHP_RETURN, PHPTokenId.PHP_OPERATOR, PHPTokenId.PHP_ECHO, PHPTokenId.PHP_EVAL, PHPTokenId.PHP_NEW, PHPTokenId.PHP_NOT, PHPTokenId.PHP_CASE, PHPTokenId.PHP_IF, PHPTokenId.PHP_ELSE, PHPTokenId.PHP_ELSEIF, PHPTokenId.PHP_PRINT, PHPTokenId.PHP_FOR, PHPTokenId.PHP_FOREACH, PHPTokenId.PHP_WHILE, PHPTokenId.PHPDOC_COMMENT_END, PHPTokenId.PHP_COMMENT_END, PHPTokenId.PHP_LINE_COMMENT, PHPTokenId.PHP_CONSTANT_ENCAPSED_STRING, PHPTokenId.PHP_ENCAPSED_AND_WHITESPACE, PHPTokenId.T_OPEN_TAG_WITH_ECHO, PHPTokenId.PHP_OPENTAG, PHPTokenId.PHP_CASTING);

    CompletionContextFinder() {
    }

    @NonNull
    static CompletionContext findCompletionContext(ParserResult parserResult, int n) {
        TokenHierarchy tokenHierarchy = parserResult.getSnapshot().getTokenHierarchy();
        if (tokenHierarchy == null) {
            return CompletionContext.NONE;
        }
        TokenSequence<PHPTokenId> tokenSequence = LexUtilities.getPHPTokenSequence(tokenHierarchy, n);
        if (tokenSequence == null) {
            return CompletionContext.NONE;
        }
        tokenSequence.move(n);
        boolean bl = tokenSequence.moveNext();
        if (!bl && !tokenSequence.movePrevious()) {
            return CompletionContext.NONE;
        }
        Token token = tokenSequence.token();
        PHPTokenId pHPTokenId = (PHPTokenId)token.id();
        int n2 = tokenSequence.token().offset(tokenHierarchy);
        CompletionContext completionContext = CompletionContextFinder.getClsIfaceDeclContext((Token<PHPTokenId>)token, n - n2, tokenSequence);
        if (completionContext != null) {
            return completionContext;
        }
        if (CompletionContextFinder.acceptTokenChains(tokenSequence, USE_KEYWORD_TOKENS, bl)) {
            return CompletionContext.USE_KEYWORD;
        }
        if (CompletionContextFinder.acceptTokenChains(tokenSequence, NAMESPACE_KEYWORD_TOKENS, bl)) {
            return CompletionContext.NAMESPACE_KEYWORD;
        }
        if (CompletionContextFinder.acceptTokenChains(tokenSequence, CLASS_NAME_TOKENCHAINS, bl)) {
            return CompletionContext.NEW_CLASS;
        }
        if (CompletionContextFinder.acceptTokenChains(tokenSequence, CLASS_MEMBER_TOKENCHAINS, bl)) {
            return CompletionContext.CLASS_MEMBER;
        }
        if (CompletionContextFinder.acceptTokenChains(tokenSequence, STATIC_CLASS_MEMBER_TOKENCHAINS, bl)) {
            return CompletionContext.STATIC_CLASS_MEMBER;
        }
        if (pHPTokenId == PHPTokenId.PHP_COMMENT) {
            return CompletionContextFinder.getCompletionContextInComment(tokenSequence, n, parserResult);
        }
        if (CompletionContextFinder.isOneOfTokens(tokenSequence, COMMENT_TOKENS)) {
            return CompletionContext.NONE;
        }
        if (CompletionContextFinder.acceptTokenChains(tokenSequence, PHPDOC_TOKENCHAINS, bl)) {
            return CompletionContext.PHPDOC;
        }
        if (CompletionContextFinder.acceptTokenChains(tokenSequence, CATCH_TOKENCHAINS, bl)) {
            return CompletionContext.TYPE_NAME;
        }
        if (CompletionContextFinder.acceptTokenChains(tokenSequence, INSTANCEOF_TOKENCHAINS, bl)) {
            return CompletionContext.TYPE_NAME;
        }
        if (CompletionContextFinder.isInsideClassIfaceDeclarationBlock(parserResult, n, tokenSequence)) {
            if (CompletionContextFinder.acceptTokenChains(tokenSequence, CLASS_CONTEXT_KEYWORDS_TOKENCHAINS, bl)) {
                return CompletionContext.CLASS_CONTEXT_KEYWORDS;
            }
            if (CompletionContextFinder.acceptTokenChains(tokenSequence, FUNCTION_TOKENCHAINS, bl)) {
                return CompletionContext.METHOD_NAME;
            }
            CompletionContext completionContext2 = CompletionContextFinder.getParamaterContext((Token<PHPTokenId>)token, n, tokenSequence);
            if (completionContext2 != null) {
                return completionContext2;
            }
            return CompletionContext.NONE;
        }
        if (CompletionContextFinder.acceptTokenChains(tokenSequence, FUNCTION_NAME_TOKENCHAINS, bl)) {
            return CompletionContext.NONE;
        }
        switch (pHPTokenId) {
            case T_INLINE_HTML: {
                return CompletionContext.HTML;
            }
            case PHP_CONSTANT_ENCAPSED_STRING: {
                char c = tokenSequence.token().text().charAt(0);
                if (c == '\"') {
                    if (CompletionContextFinder.acceptTokenChains(tokenSequence, SERVER_ARRAY_TOKENCHAINS, bl) && CompletionContextFinder.acceptTokenChainTexts(tokenSequence, SERVER_ARRAY_TOKENTEXTS)) {
                        return CompletionContext.SERVER_ENTRY_CONSTANTS;
                    }
                    return CompletionContext.STRING;
                }
                if (c == '\'' && CompletionContextFinder.acceptTokenChains(tokenSequence, SERVER_ARRAY_TOKENCHAINS, bl) && CompletionContextFinder.acceptTokenChainTexts(tokenSequence, SERVER_ARRAY_TOKENTEXTS)) {
                    return CompletionContext.SERVER_ENTRY_CONSTANTS;
                }
                return CompletionContext.NONE;
            }
        }
        if (CompletionContextFinder.isEachOfTokens(CompletionContextFinder.getLeftPreceedingTokens(tokenSequence), new PHPTokenId[]{PHPTokenId.PHP_GLOBAL, PHPTokenId.WHITESPACE})) {
            return CompletionContext.GLOBAL;
        }
        CompletionContext completionContext3 = CompletionContextFinder.getParamaterContext((Token<PHPTokenId>)token, n, tokenSequence);
        if (completionContext3 != null) {
            return completionContext3;
        }
        return CompletionContext.EXPRESSION;
    }

    private static boolean isOneOfTokens(TokenSequence tokenSequence, PHPTokenId[] pHPTokenIdArray) {
        TokenId tokenId = tokenSequence.token().id();
        for (PHPTokenId pHPTokenId : pHPTokenIdArray) {
            if (!((Object)((Object)pHPTokenId)).equals(tokenId)) continue;
            return true;
        }
        return false;
    }

    private static boolean isOneOfTokens(Token[] tokenArray, PHPTokenId[] pHPTokenIdArray) {
        for (Token token : tokenArray) {
            TokenId tokenId = token.id();
            for (PHPTokenId pHPTokenId : pHPTokenIdArray) {
                if (!((Object)((Object)pHPTokenId)).equals(tokenId)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isEachOfTokens(Token[] tokenArray, PHPTokenId[] pHPTokenIdArray) {
        HashSet<PHPTokenId> hashSet = new HashSet<PHPTokenId>();
        for (Token token : tokenArray) {
            TokenId tokenId = token.id();
            for (PHPTokenId pHPTokenId : pHPTokenIdArray) {
                if (!pHPTokenId.equals(tokenId)) continue;
                hashSet.add(pHPTokenId);
            }
        }
        return hashSet.size() == pHPTokenIdArray.length;
    }

    private static boolean acceptTokenChainTexts(TokenSequence tokenSequence, List<String> list) {
        int n = tokenSequence.offset();
        boolean bl = true;
        boolean bl2 = tokenSequence.movePrevious();
        for (int i = list.size() - 1; i >= 0; --i) {
            String string = list.get(i);
            if (!bl2) {
                bl = false;
                break;
            }
            if (!TokenUtilities.textEquals((CharSequence)string, (CharSequence)tokenSequence.token().text())) {
                bl = false;
                break;
            }
            bl2 = tokenSequence.movePrevious();
        }
        tokenSequence.move(n);
        tokenSequence.moveNext();
        return bl;
    }

    private static boolean acceptTokenChains(TokenSequence tokenSequence, List<Object[]> list, boolean bl) {
        for (Object[] objectArray : list) {
            if (!CompletionContextFinder.acceptTokenChain(tokenSequence, objectArray, bl)) continue;
            return true;
        }
        return false;
    }

    private static boolean acceptTokenChain(TokenSequence tokenSequence, Object[] objectArray, boolean bl) {
        int n = tokenSequence.offset();
        boolean bl2 = true;
        boolean bl3 = bl ? tokenSequence.movePrevious() : true;
        for (int i = objectArray.length - 1; i >= 0; --i) {
            Object object = objectArray[i];
            if (!bl3) {
                bl2 = false;
                break;
            }
            if (object instanceof PHPTokenId) {
                if (tokenSequence.token().id() == object) {
                    bl3 = tokenSequence.movePrevious();
                    continue;
                }
                bl2 = false;
                break;
            }
            if (object == NAMESPACE_FALSE_TOKEN) {
                if (CompletionContextFinder.consumeNameSpace(tokenSequence)) continue;
                bl2 = false;
                break;
            }
            assert (false) : "Unsupported token type: " + object.getClass().getName();
        }
        tokenSequence.move(n);
        tokenSequence.moveNext();
        return bl2;
    }

    private static boolean consumeNameSpace(TokenSequence tokenSequence) {
        boolean bl = false;
        if (tokenSequence.token().id() != PHPTokenId.PHP_NS_SEPARATOR && tokenSequence.token().id() != PHPTokenId.PHP_STRING) {
            return false;
        }
        if (tokenSequence.token().id() == PHPTokenId.PHP_NS_SEPARATOR) {
            bl = true;
        }
        do {
            if (!tokenSequence.movePrevious()) {
                return false;
            }
            if (tokenSequence.token().id() != PHPTokenId.PHP_NS_SEPARATOR) continue;
            bl = true;
        } while (tokenSequence.token().id() == PHPTokenId.PHP_NS_SEPARATOR || tokenSequence.token().id() == PHPTokenId.PHP_STRING);
        return bl;
    }

    private static Token[] getLeftPreceedingTokens(TokenSequence tokenSequence) {
        Token[] tokenArray = CompletionContextFinder.getPreceedingTokens(tokenSequence);
        if (tokenArray.length == 0) {
            return tokenArray;
        }
        Token[] tokenArray2 = new Token[tokenArray.length - 1];
        System.arraycopy(tokenArray, 1, tokenArray2, 0, tokenArray2.length);
        return tokenArray2;
    }

    private static Token[] getPreceedingTokens(TokenSequence tokenSequence) {
        int n = tokenSequence.offset();
        LinkedList<Token> linkedList = new LinkedList<Token>();
        boolean bl = true;
        if (tokenSequence.moveNext()) {
            boolean bl2 = bl = tokenSequence.movePrevious() && tokenSequence.movePrevious();
        }
        if (bl) {
            Token token = tokenSequence.token();
            while (token != null && !CTX_DELIMITERS.contains(token.id())) {
                linkedList.addFirst(token);
                if (!tokenSequence.movePrevious()) break;
                token = tokenSequence.token();
            }
        }
        tokenSequence.move(n);
        tokenSequence.moveNext();
        return linkedList.toArray(new Token[linkedList.size()]);
    }

    @CheckForNull
    private static CompletionContext getClsIfaceDeclContext(Token<PHPTokenId> token, int n, TokenSequence<PHPTokenId> tokenSequence) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        Token<PHPTokenId> token2 = null;
        List<? extends Token<PHPTokenId>> list = CompletionContextFinder.getPreceedingLineTokens(token, n, tokenSequence);
        for (Token<PHPTokenId> token3 : list) {
            boolean bl7;
            TokenId tokenId = token3.id();
            boolean bl8 = bl7 = !bl2 && !bl && !bl3 && !bl4 && !bl5;
            if (tokenId.equals((Object)PHPTokenId.PHP_CLASS)) {
                bl = true;
                break;
            }
            if (tokenId.equals((Object)PHPTokenId.PHP_INTERFACE)) {
                bl2 = true;
                break;
            }
            if (tokenId.equals((Object)PHPTokenId.PHP_EXTENDS)) {
                bl3 = true;
                continue;
            }
            if (tokenId.equals((Object)PHPTokenId.PHP_IMPLEMENTS)) {
                bl4 = true;
                continue;
            }
            if (tokenId.equals((Object)PHPTokenId.PHP_NS_SEPARATOR)) {
                bl5 = true;
                continue;
            }
            if (bl7 && tokenId.equals((Object)PHPTokenId.PHP_STRING)) {
                bl6 = true;
                token2 = token3;
                continue;
            }
            if (!bl7 || !tokenId.equals((Object)PHPTokenId.PHP_CURLY_OPEN)) continue;
            return null;
        }
        if (bl || bl2) {
            if (bl4) {
                return CompletionContext.INTERFACE_NAME;
            }
            if (bl3) {
                if (bl6 && bl && token2 != null && n == 0 && list.size() > 0 && list.get(0).text().equals(token2.text())) {
                    return CompletionContext.CLASS_NAME;
                }
                if (bl6 && bl) {
                    return CompletionContext.IMPLEMENTS;
                }
                if (!bl6 && bl) {
                    return CompletionContext.CLASS_NAME;
                }
                if (bl2) {
                    return CompletionContext.INTERFACE_NAME;
                }
                return !bl6 ? (bl ? CompletionContext.CLASS_NAME : CompletionContext.INTERFACE_NAME) : (bl ? CompletionContext.IMPLEMENTS : CompletionContext.INTERFACE_NAME);
            }
            if (bl2) {
                return !bl6 ? CompletionContext.NONE : CompletionContext.EXTENDS;
            }
            if (bl) {
                return !bl6 ? CompletionContext.NONE : CompletionContext.INHERITANCE;
            }
        }
        return null;
    }

    @CheckForNull
    private static CompletionContext getParamaterContext(Token<PHPTokenId> token, int n, TokenSequence<PHPTokenId> tokenSequence) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = true;
        int n2 = tokenSequence.offset();
        int n3 = -1;
        tokenSequence.moveNext();
        while (tokenSequence.movePrevious()) {
            ++n3;
            Token token2 = tokenSequence.token();
            PHPTokenId pHPTokenId = (PHPTokenId)token2.id();
            if (CTX_DELIMITERS.contains((Object)pHPTokenId)) break;
            if (bl) continue;
            if (!bl2 && bl4) {
                if (CompletionContextFinder.isParamSeparator((Token<PHPTokenId>)token2)) {
                    bl2 = true;
                    continue;
                }
                if (CompletionContextFinder.isAcceptedPrefix((Token<PHPTokenId>)token2)) {
                    int n4;
                    if (CompletionContextFinder.isNamespaceSeparator((Token<PHPTokenId>)token2)) {
                        bl3 = true;
                        continue;
                    }
                    if (!bl3 && CompletionContextFinder.isString((Token<PHPTokenId>)token2)) {
                        n4 = token2.offset(null) + token2.text().length();
                        if (n > n4) {
                            bl4 = false;
                        }
                    } else if ((CompletionContextFinder.isReference((Token<PHPTokenId>)token2) || CompletionContextFinder.isRightBracket((Token<PHPTokenId>)token2) || CompletionContextFinder.isVariable((Token<PHPTokenId>)token2)) && n >= (n4 = token2.offset(null) + token2.text().length())) {
                        bl4 = false;
                    }
                    bl3 = false;
                    continue;
                }
                bl4 = false;
                continue;
            }
            if (!CompletionContextFinder.isFunctionDeclaration((Token<PHPTokenId>)token2)) continue;
            bl = true;
            break;
        }
        tokenSequence.move(n2);
        tokenSequence.moveNext();
        return bl && bl2 ? CompletionContext.TYPE_NAME : (bl ? CompletionContext.NONE : null);
    }

    private static boolean isNamespaceSeparator(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_NS_SEPARATOR);
    }

    private static boolean isFunctionDeclaration(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_FUNCTION);
    }

    private static boolean isVariable(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_VARIABLE);
    }

    private static boolean isReference(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_TOKEN) && "&".contentEquals(token.text());
    }

    private static boolean isLeftBracket(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_TOKEN) && "(".contentEquals(token.text());
    }

    private static boolean isRightBracket(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_TOKEN) && ")".contentEquals(token.text());
    }

    private static boolean isParamSeparator(Token<PHPTokenId> token) {
        return CompletionContextFinder.isComma(token) || CompletionContextFinder.isLeftBracket(token);
    }

    private static boolean isAcceptedPrefix(Token<PHPTokenId> token) {
        return CompletionContextFinder.isVariable(token) || CompletionContextFinder.isReference(token) || CompletionContextFinder.isRightBracket(token) || CompletionContextFinder.isString(token) || CompletionContextFinder.isWhiteSpace(token) || CompletionContextFinder.isNamespaceSeparator(token);
    }

    private static boolean isComma(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_TOKEN) && ",".contentEquals(token.text());
    }

    private static boolean isWhiteSpace(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.WHITESPACE);
    }

    private static boolean isString(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_STRING);
    }

    static boolean lineContainsAny(Token<PHPTokenId> token, int n, TokenSequence<PHPTokenId> tokenSequence, List<PHPTokenId> list) {
        List<? extends Token<PHPTokenId>> list2 = CompletionContextFinder.getPreceedingLineTokens(token, n, tokenSequence);
        for (Token<PHPTokenId> token2 : list2) {
            if (!list.contains(token2.id())) continue;
            return true;
        }
        return false;
    }

    private static List<? extends Token<PHPTokenId>> getPreceedingLineTokens(Token<PHPTokenId> token, int n, TokenSequence<PHPTokenId> tokenSequence) {
        int n2 = tokenSequence.offset();
        LinkedList<Token> linkedList = new LinkedList<Token>();
        if (token.id() != PHPTokenId.WHITESPACE || ((Object)token.text().subSequence(0, Math.min(token.text().length(), n))).toString().indexOf("\n") == -1) {
            Token token2;
            while (tokenSequence.movePrevious() && ((token2 = tokenSequence.token()).id() != PHPTokenId.WHITESPACE || ((Object)token2.text()).toString().indexOf("\n") == -1)) {
                linkedList.addLast(token2);
            }
        }
        tokenSequence.move(n2);
        tokenSequence.moveNext();
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized boolean isInsideClassIfaceDeclarationBlock(ParserResult parserResult, int n, TokenSequence tokenSequence) {
        List<ASTNode> list = NavUtils.underCaret(parserResult, CompletionContextFinder.lexerToASTOffset(parserResult, n));
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        for (ASTNode aSTNode : list) {
            if (aSTNode instanceof FunctionDeclaration) {
                bl2 = true;
                if (!bl3) continue;
                bl5 = true;
                continue;
            }
            if (aSTNode instanceof MethodDeclaration) {
                bl = true;
                continue;
            }
            if (aSTNode instanceof ClassDeclaration) {
                bl3 = true;
                if (!bl2) continue;
                bl4 = true;
                continue;
            }
            if (!(aSTNode instanceof InterfaceDeclaration)) continue;
            bl3 = true;
        }
        if (bl2 && !bl && !bl3) {
            final StringBuilder stringBuilder = new StringBuilder();
            new DefaultVisitor(){

                public void visit(ASTError aSTError) {
                    super.visit(aSTError);
                    stringBuilder.append(aSTError.toString());
                }
            }.scan(Utils.getRoot(parserResult));
            if (stringBuilder.length() == 0) {
                return false;
            }
        }
        if (bl4 && !bl5) {
            return true;
        }
        int n2 = tokenSequence.offset();
        try {
            int n3 = 0;
            int n4 = 0;
            while (tokenSequence.movePrevious()) {
                boolean bl6;
                Token token = tokenSequence.token();
                TokenId tokenId = token.id();
                if (tokenId.equals((Object)PHPTokenId.PHP_CURLY_OPEN)) {
                    ++n3;
                    continue;
                }
                if (tokenId.equals((Object)PHPTokenId.PHP_CURLY_CLOSE)) {
                    ++n4;
                    continue;
                }
                if ((tokenId.equals((Object)PHPTokenId.PHP_FUNCTION) || tokenId.equals((Object)PHPTokenId.PHP_WHILE) || tokenId.equals((Object)PHPTokenId.PHP_IF) || tokenId.equals((Object)PHPTokenId.PHP_FOR) || tokenId.equals((Object)PHPTokenId.PHP_FOREACH) || tokenId.equals((Object)PHPTokenId.PHP_TRY) || tokenId.equals((Object)PHPTokenId.PHP_CATCH)) && n3 > n4) {
                    boolean bl7 = false;
                    return bl7;
                }
                if (!tokenId.equals((Object)PHPTokenId.PHP_CLASS) && !tokenId.equals((Object)PHPTokenId.PHP_INTERFACE)) continue;
                boolean bl8 = bl6 = n3 > 0 && n3 > n4;
                return bl8;
            }
        }
        finally {
            tokenSequence.move(n2);
            tokenSequence.moveNext();
        }
        return false;
    }

    static CompletionContext getCompletionContextInComment(TokenSequence<PHPTokenId> tokenSequence, int n, ParserResult parserResult) {
        Token token = tokenSequence.token();
        CharSequence charSequence = token.text();
        if (charSequence == null || charSequence.length() == 0) {
            return CompletionContext.NONE;
        }
        int n2 = n - tokenSequence.offset() - 1;
        char c = '\u0000';
        if (n2 > -1) {
            c = charSequence.charAt(n2--);
            while (-1 < n2 && !Character.isWhitespace(c) && c != '$') {
                c = charSequence.charAt(n2);
                --n2;
            }
        }
        if (n2 < charSequence.length() && c == '$') {
            return CompletionContext.STRING;
        }
        return CompletionContext.TYPE_NAME;
    }

    static int lexerToASTOffset(PHPParseResult pHPParseResult, int n) {
        return n;
    }

    static int lexerToASTOffset(ParserResult parserResult, int n) {
        int n2 = 0;
        if (parserResult instanceof PHPParseResult) {
            PHPParseResult pHPParseResult = (PHPParseResult)parserResult;
            n2 = CompletionContextFinder.lexerToASTOffset(pHPParseResult, n);
        }
        return n2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum KeywordCompletionType {
        SIMPLE,
        CURSOR_INSIDE_BRACKETS,
        ENDS_WITH_CURLY_BRACKETS,
        ENDS_WITH_SPACE,
        ENDS_WITH_SEMICOLON,
        ENDS_WITH_COLON;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum CompletionContext {
        EXPRESSION,
        HTML,
        CLASS_NAME,
        INTERFACE_NAME,
        TYPE_NAME,
        STRING,
        CLASS_MEMBER,
        STATIC_CLASS_MEMBER,
        PHPDOC,
        INHERITANCE,
        EXTENDS,
        IMPLEMENTS,
        METHOD_NAME,
        CLASS_CONTEXT_KEYWORDS,
        SERVER_ENTRY_CONSTANTS,
        NONE,
        NEW_CLASS,
        GLOBAL,
        NAMESPACE_KEYWORD,
        USE_KEYWORD;

    }
}

