/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects;

import javax.swing.text.Document;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.ruby.rhtml.spi.DtdResolver;
import org.netbeans.modules.ruby.rubyproject.RubyBaseProject;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

public final class RailsDtdResolver
implements DtdResolver {
    private static final String DEFAULT_FALLBACK_DTD = "-//W3C//DTD XHTML 1.0 Strict//EN";
    private static final String RHTML_DTD_PROPERTY = "rhtml.doctype";

    public String getIdentifier(Document document) {
        FileObject fileObject = RailsDtdResolver.getFileObject(document);
        if (fileObject == null) {
            return null;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return null;
        }
        RubyBaseProject rubyBaseProject = (RubyBaseProject)project.getLookup().lookup(RubyBaseProject.class);
        if (rubyBaseProject == null) {
            return null;
        }
        String string = rubyBaseProject.evaluator().getProperty(RHTML_DTD_PROPERTY);
        return string != null ? string : DEFAULT_FALLBACK_DTD;
    }

    private static FileObject getFileObject(Document document) {
        Object object = document.getProperty("stream");
        if (object instanceof FileObject) {
            return (FileObject)object;
        }
        if (object instanceof DataObject) {
            return ((DataObject)object).getPrimaryFile();
        }
        return null;
    }
}

