/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.netbeans.api.project.Project;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.railsprojects.RailsFileLocator;
import org.netbeans.modules.ruby.railsprojects.RailsProject;
import org.netbeans.modules.ruby.rubyproject.Migrations;
import org.netbeans.modules.ruby.rubyproject.RubyFileLocator;
import org.netbeans.modules.ruby.rubyproject.rake.RakeRunner;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.LifecycleManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.Actions;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MigrateAction
extends SystemAction
implements ContextAwareAction {
    private static final Logger LOGGER = Logger.getLogger(MigrateAction.class.getName());

    public String getName() {
        return NbBundle.getMessage(MigrateAction.class, (String)"LBL_rake_migrate");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        assert (false) : "Action should never be called without a context";
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new ContextAction(lookup);
    }

    private static JMenu createMenu(RailsProject railsProject) {
        return new LazyMenu(railsProject);
    }

    static void buildMenu(JMenu jMenu, RailsProject railsProject) {
        JMenuItem jMenuItem = new JMenuItem(NbBundle.getMessage(MigrateAction.class, (String)"CurrentVersion"));
        jMenuItem.addActionListener(new MigrateMenuItemHandler(railsProject, -1L));
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(NbBundle.getMessage(MigrateAction.class, (String)"Version0", (Object)0));
        jMenuItem.addActionListener(new MigrateMenuItemHandler(railsProject, 0L));
        jMenu.add(jMenuItem);
        List list = Migrations.getMigrations((Project)railsProject);
        HashMap<Long, String> hashMap = new HashMap<Long, String>(list.size());
        for (Migrations.Migration migration : list) {
            hashMap.put(migration.getVersion(), "- " + migration.getDescription());
        }
        if (!hashMap.isEmpty()) {
            jMenu.addSeparator();
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(hashMap.keySet());
            Collections.sort(arrayList);
            MigrateAction.buildMenu(railsProject, jMenu, 0, arrayList.size() - 1, arrayList, hashMap);
        }
    }

    private static void buildMenu(RailsProject railsProject, JMenu jMenu, int n, int n2, List<Long> list, Map<Long, String> map) {
        int n3 = 20;
        int n4 = 15;
        if (n2 - n > n3) {
            int n5 = n2 - n;
            int n6 = (int)Math.sqrt(n5);
            if (n6 < n4) {
                n4 = n6;
            }
            int n7 = n5 / n4;
            if (n5 % n4 == 0) {
                --n4;
            }
            for (int i = 0; i <= n4; ++i) {
                int n8 = i * n7 + n;
                int n9 = (i + 1) * n7 - 1 + n;
                if (n8 > n2) {
                    return;
                }
                if (n9 > n2) {
                    n9 = n2;
                } else if (n9 == n2 - 1) {
                    n9 = n2;
                }
                if (n9 == n8) {
                    MigrateAction.buildMenu(railsProject, jMenu, n8, n9, list, map);
                    continue;
                }
                long l = list.get(n8);
                long l2 = list.get(n9);
                JMenu jMenu2 = new JMenu(NbBundle.getMessage(MigrateAction.class, (String)"VersionXtoY", (Object)Long.toString(l), (Object)Long.toString(l2)));
                MigrateAction.buildMenu(railsProject, jMenu2, n8, n9, list, map);
                jMenu.add(jMenu2);
            }
            return;
        }
        for (int i = n; i <= n2; ++i) {
            long l = list.get(i);
            String string = map.get(l);
            if (string == null) {
                string = "";
            }
            JMenuItem jMenuItem = new JMenuItem(NbBundle.getMessage(MigrateAction.class, (String)"VersionX", (Object)Long.toString(l), (Object)string));
            jMenuItem.addActionListener(new MigrateMenuItemHandler(railsProject, l));
            jMenu.add(jMenuItem);
        }
    }

    private static final class MigrateMenuItemHandler
    implements ActionListener,
    Runnable {
        private final RailsProject project;
        private final long version;
        private static final String WARN_ON_CLEAR_PREF_ID = "confirmMigratingToVersion0";

        public MigrateMenuItemHandler(RailsProject railsProject, long l) {
            this.project = railsProject;
            this.version = l;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RequestProcessor.getDefault().post((Runnable)this);
        }

        public void run() {
            if (!RubyPlatform.hasValidRake((Project)this.project, (boolean)true)) {
                return;
            }
            LifecycleManager.getDefault().saveAll();
            RailsFileLocator railsFileLocator = new RailsFileLocator(Lookup.EMPTY, (Project)this.project);
            String string = NbBundle.getMessage(MigrateAction.class, (String)"Migration");
            File file = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
            if (this.version == 0L && !this.confirmReset()) {
                return;
            }
            RakeRunner rakeRunner = new RakeRunner((Project)this.project);
            rakeRunner.setPWD(file);
            rakeRunner.setDisplayName(string);
            rakeRunner.setFileLocator((RubyFileLocator)railsFileLocator);
            rakeRunner.showWarnings(true);
            if (this.version != -1L) {
                rakeRunner.setParameters(new String[]{"VERSION=" + Long.toString(this.version)});
            }
            rakeRunner.run(new String[]{"db:migrate"});
        }

        private boolean confirmReset() {
            Preferences preferences = NbPreferences.forModule(MigrateAction.class);
            if (!preferences.getBoolean(WARN_ON_CLEAR_PREF_ID, true)) {
                return true;
            }
            JCheckBox jCheckBox = new JCheckBox(NbBundle.getMessage(MigrateAction.class, (String)"ShowConfirmDialog"));
            jCheckBox.setSelected(true);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)NbBundle.getMessage(MigrateAction.class, (String)"ConfirmReset"), NbBundle.getMessage(MigrateAction.class, (String)"ConfirmResetTitle"));
            Object[] objectArray = new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.NO_OPTION, DialogDescriptor.CANCEL_OPTION};
            dialogDescriptor.setOptions(objectArray);
            dialogDescriptor.setClosingOptions(objectArray);
            dialogDescriptor.setAdditionalOptions(new Object[]{jCheckBox});
            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
            if (object.equals(NotifyDescriptor.OK_OPTION) || object.equals(NotifyDescriptor.NO_OPTION)) {
                preferences.putBoolean(WARN_ON_CLEAR_PREF_ID, jCheckBox.isSelected());
            }
            return object.equals(NotifyDescriptor.OK_OPTION);
        }
    }

    private static final class LazyMenu
    extends JMenu {
        private final RailsProject project;
        private boolean initialized = false;

        public LazyMenu(RailsProject railsProject) {
            super(((MigrateAction)SystemAction.get(MigrateAction.class)).getName());
            this.project = railsProject;
        }

        public JPopupMenu getPopupMenu() {
            if (!this.initialized) {
                this.initialized = true;
                super.removeAll();
                MigrateAction.buildMenu(this, this.project);
            }
            return super.getPopupMenu();
        }
    }

    private static final class ContextAction
    extends AbstractAction
    implements Presenter.Popup {
        private final RailsProject project;

        public ContextAction(Lookup lookup) {
            super(((MigrateAction)SystemAction.get(MigrateAction.class)).getName());
            Collection collection = lookup.lookupAll(RailsProject.class);
            this.project = collection.size() == 1 ? (RailsProject)((Object)collection.iterator().next()) : null;
            super.setEnabled(this.project != null);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            assert (false) : "Action should not be called directly";
        }

        public JMenuItem getPopupPresenter() {
            if (this.project != null) {
                return MigrateAction.createMenu(this.project);
            }
            return new Actions.MenuItem((Action)this, false);
        }

        public void setEnabled(boolean bl) {
            assert (false) : "No modifications to enablement status permitted";
        }
    }
}

