/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.infrastructure;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.java.hints.infrastructure.CreatorBasedLazyFixList;
import org.netbeans.modules.java.hints.infrastructure.ErrorHintsProvider;
import org.netbeans.modules.java.hints.infrastructure.HintsTask;
import org.netbeans.modules.java.hints.infrastructure.SuggestionsTask;
import org.netbeans.spi.editor.hints.Context;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.LazyFixList;
import org.netbeans.spi.editor.hints.PositionRefresher;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaHintsPositionRefresher
implements PositionRefresher {
    private static final Logger LOG = Logger.getLogger(JavaHintsPositionRefresher.class.getName());

    public Map<String, List<ErrorDescription>> getErrorDescriptionsAt(final Context context, final Document document) {
        final JavaSource javaSource = JavaSource.forDocument((Document)document);
        final HashMap<String, List<ErrorDescription>> hashMap = new HashMap<String, List<ErrorDescription>>();
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    javaSource.runUserActionTask((Task)new RefreshTask(hashMap, context, document), true);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        };
        ProgressUtils.runOffEventDispatchThread((Runnable)runnable, (String)NbBundle.getMessage(JavaHintsPositionRefresher.class, (String)"Refresh_hints"), (AtomicBoolean)context.getCancel(), (boolean)false);
        return hashMap;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RefreshTask
    implements Task<CompilationController> {
        private final Map<String, List<ErrorDescription>> eds;
        private final Context ctx;
        private final Document doc;

        public RefreshTask(Map<String, List<ErrorDescription>> map, Context context, Document document) {
            this.eds = map;
            this.ctx = context;
            this.doc = document;
        }

        public void run(CompilationController compilationController) throws Exception {
            LazyFixList lazyFixList;
            compilationController.toPhase(JavaSource.Phase.RESOLVED);
            int n = this.ctx.getPosition();
            if (this.ctx.isCanceled()) {
                return;
            }
            SuggestionsTask suggestionsTask = new SuggestionsTask();
            suggestionsTask.run((CompilationInfo)compilationController);
            this.eds.put(SuggestionsTask.class.getName(), suggestionsTask.getSuggestions());
            if (this.ctx.isCanceled()) {
                return;
            }
            int n2 = Utilities.getRowStart((BaseDocument)((BaseDocument)this.doc), (int)n);
            int n3 = Utilities.getRowEnd((BaseDocument)((BaseDocument)this.doc), (int)n);
            TreeSet<ErrorDescription> treeSet = new TreeSet<ErrorDescription>(new Comparator<ErrorDescription>(){

                @Override
                public int compare(ErrorDescription errorDescription, ErrorDescription errorDescription2) {
                    return errorDescription.toString().equals(errorDescription2.toString()) ? 0 : 1;
                }
            });
            HashSet<Tree> hashSet = new HashSet<Tree>();
            HintsTask hintsTask = new HintsTask();
            for (int i = n2; i <= n3; ++i) {
                TreePath treePath = compilationController.getTreeUtilities().pathFor(i);
                Tree tree = treePath.getLeaf();
                if (tree.getKind() == Tree.Kind.BLOCK || hashSet.contains(tree)) continue;
                lazyFixList = hintsTask.computeHints((CompilationInfo)compilationController, treePath);
                if (LOG.isLoggable(Level.FINE) && lazyFixList.size() != 0) {
                    LOG.fine("### RowPosition: " + i + " leaf: " + tree + " Kind: " + (Object)((Object)tree.getKind()) + " Err: " + lazyFixList.toString());
                }
                treeSet.addAll((Collection<ErrorDescription>)lazyFixList);
                hashSet.add(tree);
            }
            this.eds.put(HintsTask.class.getName(), new ArrayList<ErrorDescription>(treeSet));
            if (this.ctx.isCanceled()) {
                return;
            }
            List<ErrorDescription> list = new ErrorHintsProvider().computeErrors((CompilationInfo)compilationController, this.doc, n);
            for (ErrorDescription errorDescription : list) {
                lazyFixList = errorDescription.getFixes();
                if (!(lazyFixList instanceof CreatorBasedLazyFixList)) continue;
                ((CreatorBasedLazyFixList)errorDescription.getFixes()).compute((CompilationInfo)compilationController, this.ctx.getCancel());
            }
            this.eds.put(ErrorHintsProvider.class.getName(), list);
        }
    }
}

