/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.type.WildcardType;
import javax.swing.JComponent;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.MissingHashCode;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportNonAccessibleElement
extends AbstractHint
implements ElementVisitor<Boolean, Void>,
TypeVisitor<Boolean, Void> {
    private volatile transient boolean stop;

    public ExportNonAccessibleElement() {
        super(true, true, AbstractHint.HintSeverity.WARNING, new String[0]);
    }

    @Override
    public Set<Tree.Kind> getTreeKinds() {
        return EnumSet.of(Tree.Kind.METHOD, Tree.Kind.CLASS, Tree.Kind.VARIABLE);
    }

    @Override
    public List<ErrorDescription> run(CompilationInfo compilationInfo, TreePath treePath) {
        this.stop = false;
        Element element = compilationInfo.getTrees().getElement(treePath);
        if (element == null) {
            return null;
        }
        Boolean bl = element.accept(this, null);
        if (bl.booleanValue()) {
            Element element2 = element;
            while (true) {
                if (this.stop) {
                    return null;
                }
                if (element2 == null || element2.getKind() == ElementKind.PACKAGE) break;
                if (!element2.getModifiers().contains((Object)Modifier.PUBLIC) && !element2.getModifiers().contains((Object)Modifier.PROTECTED)) {
                    return null;
                }
                element2 = element2.getEnclosingElement();
            }
            int[] nArray = null;
            switch (treePath.getLeaf().getKind()) {
                case METHOD: {
                    nArray = compilationInfo.getTreeUtilities().findNameSpan((MethodTree)treePath.getLeaf());
                    break;
                }
                case CLASS: {
                    nArray = compilationInfo.getTreeUtilities().findNameSpan((ClassTree)treePath.getLeaf());
                    break;
                }
                case VARIABLE: {
                    nArray = compilationInfo.getTreeUtilities().findNameSpan((VariableTree)treePath.getLeaf());
                }
            }
            if (nArray != null) {
                ErrorDescription errorDescription = ErrorDescriptionFactory.createErrorDescription((Severity)this.getSeverity().toEditorSeverity(), (String)NbBundle.getMessage(ExportNonAccessibleElement.class, (String)"MSG_ExportNonAccessibleElement"), (FileObject)compilationInfo.getFileObject(), (int)nArray[0], (int)nArray[1]);
                return Collections.singletonList(errorDescription);
            }
        }
        return null;
    }

    @Override
    public String getId() {
        return this.getClass().getName();
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(MissingHashCode.class, (String)"MSG_ExportNonAccessibleElement");
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(MissingHashCode.class, (String)"HINT_ExportNonAccessibleElement");
    }

    @Override
    public void cancel() {
        this.stop = true;
    }

    public Preferences getPreferences() {
        return null;
    }

    @Override
    public JComponent getCustomizer(Preferences preferences) {
        return null;
    }

    @Override
    public Boolean visit(Element element, Void void_) {
        return false;
    }

    @Override
    public Boolean visit(Element element) {
        return false;
    }

    @Override
    public Boolean visitPackage(PackageElement packageElement, Void void_) {
        return false;
    }

    @Override
    public Boolean visitType(TypeElement typeElement, Void void_) {
        for (TypeParameterElement typeParameterElement : typeElement.getTypeParameters()) {
            if (this.stop) {
                return false;
            }
            for (TypeMirror typeMirror : typeParameterElement.getBounds()) {
                if (this.stop) {
                    return false;
                }
                if (!typeMirror.accept(this, void_).booleanValue()) continue;
                return true;
            }
        }
        TypeMirror typeMirror = typeElement.getSuperclass();
        if (typeMirror.getKind() == TypeKind.DECLARED && !((DeclaredType)typeMirror).asElement().getKind().isInterface()) {
            return false;
        }
        return typeMirror.accept(this, void_);
    }

    @Override
    public Boolean visitVariable(VariableElement variableElement, Void void_) {
        if (!this.isVisible(variableElement)) {
            return false;
        }
        return variableElement.asType().accept(this, void_);
    }

    @Override
    public Boolean visitExecutable(ExecutableElement executableElement, Void void_) {
        if (!this.isVisible(executableElement)) {
            return false;
        }
        for (VariableElement variableElement : executableElement.getParameters()) {
            if (this.stop) {
                return false;
            }
            if (!variableElement.asType().accept(this, void_).booleanValue()) continue;
            return true;
        }
        return executableElement.getReturnType().accept(this, void_);
    }

    @Override
    public Boolean visitTypeParameter(TypeParameterElement typeParameterElement, Void void_) {
        return false;
    }

    @Override
    public Boolean visitUnknown(Element element, Void void_) {
        return false;
    }

    @Override
    public Boolean visit(TypeMirror typeMirror, Void void_) {
        return false;
    }

    @Override
    public Boolean visit(TypeMirror typeMirror) {
        return false;
    }

    @Override
    public Boolean visitPrimitive(PrimitiveType primitiveType, Void void_) {
        return false;
    }

    @Override
    public Boolean visitNull(NullType nullType, Void void_) {
        return false;
    }

    @Override
    public Boolean visitArray(ArrayType arrayType, Void void_) {
        return arrayType.getComponentType().accept(this, void_);
    }

    @Override
    public Boolean visitDeclared(DeclaredType declaredType, Void void_) {
        if (!this.isVisible(declaredType.asElement())) {
            return true;
        }
        for (TypeMirror typeMirror : declaredType.getTypeArguments()) {
            if (this.stop) {
                return false;
            }
            if (!typeMirror.accept(this, void_).booleanValue()) continue;
            return true;
        }
        return declaredType.getEnclosingType().accept(this, void_);
    }

    @Override
    public Boolean visitError(ErrorType errorType, Void void_) {
        return false;
    }

    @Override
    public Boolean visitTypeVariable(TypeVariable typeVariable, Void void_) {
        return typeVariable.getLowerBound().accept(this, void_) != false && typeVariable.getUpperBound().accept(this, void_) != false;
    }

    @Override
    public Boolean visitWildcard(WildcardType wildcardType, Void void_) {
        TypeMirror typeMirror = wildcardType.getExtendsBound();
        TypeMirror typeMirror2 = wildcardType.getSuperBound();
        return typeMirror != null && typeMirror.accept(this, void_) != false || typeMirror2 != null && typeMirror2.accept(this, void_) != false;
    }

    @Override
    public Boolean visitExecutable(ExecutableType executableType, Void void_) {
        return false;
    }

    @Override
    public Boolean visitNoType(NoType noType, Void void_) {
        return false;
    }

    @Override
    public Boolean visitUnknown(TypeMirror typeMirror, Void void_) {
        return false;
    }

    private boolean isVisible(Element ... elementArray) {
        return this.isVisible(Arrays.asList(elementArray));
    }

    private boolean isVisible(Collection<? extends Element> collection) {
        for (Element element : collection) {
            if (this.stop) {
                return false;
            }
            if (!element.getModifiers().contains((Object)Modifier.PUBLIC) && !element.getModifiers().contains((Object)Modifier.PROTECTED)) continue;
            return true;
        }
        return false;
    }

    private static final class FixImpl
    implements Fix {
        private TreePathHandle handle;
        private FileObject file;
        private String msg;
        private static final Set<Tree.Kind> DECLARATION = EnumSet.of(Tree.Kind.CLASS, Tree.Kind.METHOD, Tree.Kind.VARIABLE);

        public FixImpl(String string, TreePathHandle treePathHandle, FileObject fileObject) {
            this.handle = treePathHandle;
            this.file = fileObject;
            this.msg = string;
        }

        public String getText() {
            return NbBundle.getMessage(MissingHashCode.class, (String)this.msg);
        }

        public ChangeInfo implement() throws IOException {
            ModificationResult modificationResult = JavaSource.forFileObject((FileObject)this.file).runModificationTask((Task)new Task<WorkingCopy>(){

                public void run(WorkingCopy workingCopy) throws Exception {
                    workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                    Element element = FixImpl.this.handle.resolveElement((CompilationInfo)workingCopy);
                    Tree tree = workingCopy.getTrees().getTree(element);
                    if (tree.getKind() == Tree.Kind.CLASS) {
                        ClassTree classTree = (ClassTree)tree;
                        HashSet<Modifier> hashSet = new HashSet<Modifier>(classTree.getModifiers().getFlags());
                        hashSet.remove((Object)Modifier.PUBLIC);
                        hashSet.remove((Object)Modifier.PROTECTED);
                        ModifiersTree modifiersTree = workingCopy.getTreeMaker().Modifiers(hashSet, classTree.getModifiers().getAnnotations());
                        workingCopy.rewrite((Tree)classTree.getModifiers(), (Tree)modifiersTree);
                        return;
                    }
                    if (tree.getKind() == Tree.Kind.METHOD) {
                        MethodTree methodTree = (MethodTree)tree;
                        HashSet<Modifier> hashSet = new HashSet<Modifier>(methodTree.getModifiers().getFlags());
                        hashSet.remove((Object)Modifier.PUBLIC);
                        hashSet.remove((Object)Modifier.PROTECTED);
                        ModifiersTree modifiersTree = workingCopy.getTreeMaker().Modifiers(hashSet, methodTree.getModifiers().getAnnotations());
                        workingCopy.rewrite((Tree)methodTree.getModifiers(), (Tree)modifiersTree);
                        return;
                    }
                    if (tree.getKind() == Tree.Kind.VARIABLE) {
                        VariableTree variableTree = (VariableTree)tree;
                        HashSet<Modifier> hashSet = new HashSet<Modifier>(variableTree.getModifiers().getFlags());
                        hashSet.remove((Object)Modifier.PUBLIC);
                        hashSet.remove((Object)Modifier.PROTECTED);
                        ModifiersTree modifiersTree = workingCopy.getTreeMaker().Modifiers(hashSet, variableTree.getModifiers().getAnnotations());
                        workingCopy.rewrite((Tree)variableTree.getModifiers(), (Tree)modifiersTree);
                        return;
                    }
                }
            });
            modificationResult.commit();
            return null;
        }

        public String toString() {
            return "FixExportNonAccessibleElement";
        }
    }
}

