/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.nodes;

import java.awt.Image;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnnotatedAbstractNode
extends AbstractNode
implements FileStatusListener,
Runnable {
    private Set<FileObject> files;
    private Map<FileSystem, FileStatusListener> fileSystemListeners;
    private RequestProcessor.Task task;
    private final Object privateLock = new Object();
    private boolean iconChange;
    private boolean nameChange;

    public AnnotatedAbstractNode(Children children, Lookup lookup) {
        super(children, lookup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setFiles(Set<FileObject> set) {
        if (this.fileSystemListeners != null) {
            for (Map.Entry<FileSystem, FileStatusListener> object2 : this.fileSystemListeners.entrySet()) {
                object2.getKey().removeFileStatusListener(object2.getValue());
            }
        }
        this.fileSystemListeners = new HashMap<FileSystem, FileStatusListener>();
        Object object = this.privateLock;
        synchronized (object) {
            this.files = set;
            if (set == null) {
                return;
            }
            HashSet<FileSystem> hashSet = new HashSet<FileSystem>();
            for (FileObject fileObject : set) {
                ErrorManager errorManager;
                try {
                    FileSystem fileStateInvalidException = fileObject.getFileSystem();
                    if (hashSet.contains(fileStateInvalidException)) continue;
                    hashSet.add(fileStateInvalidException);
                    errorManager = FileUtil.weakFileStatusListener((FileStatusListener)this, (Object)fileStateInvalidException);
                    fileStateInvalidException.addFileStatusListener((FileStatusListener)errorManager);
                    this.fileSystemListeners.put(fileStateInvalidException, (FileStatusListener)errorManager);
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    errorManager = ErrorManager.getDefault();
                    errorManager.annotate((Throwable)fileStateInvalidException, 0, "Cannot get " + fileObject + " filesystem, ignoring...", null, null, null);
                    errorManager.notify(1, (Throwable)fileStateInvalidException);
                }
            }
        }
        this.fireIconChange();
        this.fireOpenedIconChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean bl;
        boolean bl2;
        Object object = this.privateLock;
        synchronized (object) {
            bl2 = this.iconChange;
            bl = this.nameChange;
            this.iconChange = false;
            this.nameChange = false;
        }
        if (bl2) {
            this.fireIconChange();
            this.fireOpenedIconChange();
        }
        if (bl) {
            this.fireDisplayNameChange(null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void annotationChanged(FileStatusEvent fileStatusEvent) {
        if (this.task == null) {
            this.task = RequestProcessor.getDefault().create((Runnable)this);
        }
        Object object = this.privateLock;
        synchronized (object) {
            if (!this.iconChange && fileStatusEvent.isIconChange() || !this.nameChange && fileStatusEvent.isNameChange()) {
                for (FileObject fileObject : this.files) {
                    if (!fileStatusEvent.hasChanged(fileObject)) continue;
                    this.iconChange |= fileStatusEvent.isIconChange();
                    this.nameChange |= fileStatusEvent.isNameChange();
                }
            }
        }
        this.task.schedule(50);
    }

    protected abstract Image getIconImpl(int var1);

    protected abstract Image getOpenedIconImpl(int var1);

    public final Image getIcon(int n) {
        Image image = this.getIconImpl(n);
        return this.annotateImpl(image, n);
    }

    public final Image getOpenedIcon(int n) {
        Image image = this.getOpenedIconImpl(n);
        return this.annotateImpl(image, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image annotateImpl(Image image, int n) {
        Object object = this.privateLock;
        synchronized (object) {
            if (this.files != null && this.files.size() > 0) {
                try {
                    Iterator<FileObject> iterator = this.files.iterator();
                    assert (iterator.hasNext());
                    FileObject fileObject = iterator.next();
                    assert (fileObject != null);
                    FileSystem fileSystem = fileObject.getFileSystem();
                    assert (fileSystem != null);
                    return fileSystem.getStatus().annotateIcon(image, n, this.files);
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    ErrorManager.getDefault().notify(1, (Throwable)fileStateInvalidException);
                }
            }
        }
        return image;
    }
}

