/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;

class ActivationClassBuilder
extends ExpressionClassBuilder {
    private LocalField targetResultSetField;
    private LocalField cursorResultSetField;
    private MethodBuilder closeActivationMethod;

    ActivationClassBuilder(String string, CompilerContext compilerContext) throws StandardException {
        super(string, null, compilerContext);
        this.executeMethod = this.beginExecuteMethod();
    }

    public String getPackageName() {
        return "org.apache.derby.exe.";
    }

    String getBaseClassName() {
        return "org.apache.derby.impl.sql.execute.BaseActivation";
    }

    public int getRowCount() throws StandardException {
        return this.myCompCtx.getNumResultSets();
    }

    public void setNumSubqueries() {
        int n = this.myCompCtx.getNumSubquerys();
        if (n == 0) {
            return;
        }
        this.constructor.pushThis();
        this.constructor.push(n);
        this.constructor.putField("org.apache.derby.impl.sql.execute.BaseActivation", "numSubqueries", "int");
        this.constructor.endStatement();
    }

    public MethodBuilder beginExecuteMethod() throws StandardException {
        MethodBuilder methodBuilder = this.cb.newMethodBuilder(1, "org.apache.derby.iapi.sql.ResultSet", "execute");
        methodBuilder.addThrownException("org.apache.derby.iapi.error.StandardException");
        methodBuilder.pushThis();
        methodBuilder.push("execute");
        methodBuilder.callMethod((short)182, "org.apache.derby.impl.sql.execute.BaseActivation", "throwIfClosed", "void", 1);
        methodBuilder.pushThis();
        methodBuilder.callMethod((short)182, "org.apache.derby.impl.sql.execute.BaseActivation", "startExecution", "void", 0);
        return methodBuilder;
    }

    MethodBuilder startResetMethod() {
        MethodBuilder methodBuilder = this.cb.newMethodBuilder(1, "void", "reset");
        methodBuilder.addThrownException("org.apache.derby.iapi.error.StandardException");
        methodBuilder.pushThis();
        methodBuilder.callMethod((short)183, "org.apache.derby.impl.sql.execute.BaseActivation", "reset", "void", 0);
        return methodBuilder;
    }

    void finishExecuteMethod(boolean bl) {
        this.executeMethod.pushThis();
        this.executeMethod.getField("org.apache.derby.impl.sql.execute.BaseActivation", "resultSet", "org.apache.derby.iapi.sql.ResultSet");
        if (bl) {
            this.executeMethod.dup();
            this.executeMethod.cast("org.apache.derby.iapi.sql.execute.NoPutResultSet");
            this.executeMethod.callMethod((short)185, null, "markAsTopResultSet", "void", 0);
        }
        this.executeMethod.methodReturn();
        this.executeMethod.complete();
        this.getClassBuilder().newFieldWithAccessors("getExecutionCount", "setExecutionCount", 4, true, "int");
        this.getClassBuilder().newFieldWithAccessors("getRowCountCheckVector", "setRowCountCheckVector", 4, true, "java.util.Vector");
        this.getClassBuilder().newFieldWithAccessors("getStalePlanCheckInterval", "setStalePlanCheckInterval", 4, true, "int");
        if (this.closeActivationMethod != null) {
            this.closeActivationMethod.methodReturn();
            this.closeActivationMethod.complete();
        }
    }

    void addCursorPositionCode() {
        MethodBuilder methodBuilder = this.cb.newMethodBuilder(1, "org.apache.derby.iapi.sql.execute.CursorResultSet", "getTargetResultSet");
        methodBuilder.getField(this.targetResultSetField);
        methodBuilder.methodReturn();
        methodBuilder.complete();
        methodBuilder = this.cb.newMethodBuilder(1, "org.apache.derby.iapi.sql.execute.CursorResultSet", "getCursorResultSet");
        methodBuilder.getField(this.cursorResultSetField);
        methodBuilder.methodReturn();
        methodBuilder.complete();
    }

    void rememberCursorTarget(MethodBuilder methodBuilder) {
        this.targetResultSetField = this.cb.addField("org.apache.derby.iapi.sql.execute.CursorResultSet", "targetResultSet", 2);
        methodBuilder.cast("org.apache.derby.iapi.sql.execute.CursorResultSet");
        methodBuilder.putField(this.targetResultSetField);
        methodBuilder.cast("org.apache.derby.iapi.sql.execute.NoPutResultSet");
    }

    void rememberCursor(MethodBuilder methodBuilder) {
        this.cursorResultSetField = this.cb.addField("org.apache.derby.iapi.sql.execute.CursorResultSet", "cursorResultSet", 2);
        methodBuilder.cast("org.apache.derby.iapi.sql.execute.CursorResultSet");
        methodBuilder.putField(this.cursorResultSetField);
        methodBuilder.cast("org.apache.derby.iapi.sql.ResultSet");
    }

    protected LocalField getCurrentSetup() {
        if (this.cdtField != null) {
            return this.cdtField;
        }
        LocalField localField = super.getCurrentSetup();
        this.executeMethod.getField(localField);
        this.executeMethod.callMethod((short)182, null, "forget", "void", 0);
        return localField;
    }

    MethodBuilder getCloseActivationMethod() {
        if (this.closeActivationMethod == null) {
            this.closeActivationMethod = this.cb.newMethodBuilder(1, "void", "closeActivationAction");
            this.closeActivationMethod.addThrownException("java.lang.Exception");
        }
        return this.closeActivationMethod;
    }
}

