/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.InputStreamUtil;
import org.apache.derby.iapi.services.io.NewByteArrayInputStream;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.Resetable;
import org.apache.derby.impl.jdbc.BinaryToRawStream;
import org.apache.derby.impl.jdbc.ConnectionChild;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.Util;

final class EmbedBlob
extends ConnectionChild
implements Blob {
    private boolean isBytes;
    private InputStream myStream;
    private long myLength = -1L;
    private byte[] myBytes;
    private long pos;
    private BinaryToRawStream biStream;
    private static int BLOB_BUF_SIZE = 4096;
    private byte[] buf;
    private boolean isValid = true;

    EmbedBlob(byte[] byArray, EmbedConnection embedConnection) {
        super(embedConnection);
        this.myBytes = byArray;
        this.isBytes = true;
        this.myLength = this.myBytes.length;
    }

    protected EmbedBlob(DataValueDescriptor dataValueDescriptor, EmbedConnection embedConnection) throws StandardException {
        super(embedConnection);
        this.myStream = dataValueDescriptor.getStream();
        if (this.myStream == null) {
            this.isBytes = true;
            byte[] byArray = dataValueDescriptor.getBytes();
            this.myLength = byArray.length;
            this.myBytes = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.myBytes, 0, byArray.length);
        } else {
            block4: {
                this.isBytes = false;
                try {
                    ((Resetable)((Object)this.myStream)).initStream();
                }
                catch (StandardException standardException) {
                    if (!standardException.getMessageId().equals("40XD0")) break block4;
                    throw StandardException.newException("XJ073.S");
                }
            }
            this.buf = new byte[BLOB_BUF_SIZE];
        }
        this.pos = 0L;
    }

    private void setPosition(long l) throws StandardException, IOException {
        if (this.isBytes) {
            this.pos = l;
        } else {
            ((Resetable)((Object)this.myStream)).resetStream();
            this.biStream = new BinaryToRawStream(this.myStream, this);
            this.pos = 0L;
            while (this.pos < l) {
                int n = this.biStream.read(this.buf, 0, (int)Math.min(l - this.pos, (long)BLOB_BUF_SIZE));
                if (n <= 0) {
                    throw StandardException.newException("XJ079.S");
                }
                this.pos += (long)n;
            }
        }
    }

    private int read() throws IOException {
        int n;
        if (this.isBytes) {
            if (this.pos >= (long)this.myBytes.length) {
                return -1;
            }
            n = this.myBytes[(int)this.pos];
        } else {
            n = this.biStream.read();
        }
        ++this.pos;
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public long length() throws SQLException {
        block12: {
            this.checkValidity();
            if (this.myLength != -1L) {
                return this.myLength;
            }
            var1_1 = false;
            var2_2 = this.getConnectionSynchronization();
            // MONITORENTER : var2_2
            v0 = var1_1 = this.getEmbedConnection().isClosed() == false;
            if (var1_1) {
                this.setupContextStack();
            }
            this.setPosition(0L);
            this.myLength = this.biStream.getLength();
            if (this.myLength == -1L) break block12;
            this.biStream.close();
            var3_4 = this.myLength;
            // MONITOREXIT : var2_2
            if (var1_1 == false) return var3_4;
            this.restoreContextStack();
            return var3_4;
        }
        while (true) {
            if ((var3_5 = this.biStream.read(this.buf)) == -1) {
                this.myLength = this.pos;
                this.biStream.close();
                var3_6 = this.pos;
                // MONITOREXIT : var2_2
                if (var1_1 == false) return var3_6;
                ** break;
            }
            this.pos += (long)var3_5;
        }
        {
            catch (Throwable var2_3) {
                throw this.handleMyExceptions(var2_3);
            }
        }
lbl34:
        // 1 sources

        this.restoreContextStack();
        return var3_6;
        catch (Throwable var6_7) {
            if (var1_1 == false) throw var6_7;
            this.restoreContextStack();
            throw var6_7;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getBytes(long l, int n) throws SQLException {
        this.checkValidity();
        boolean bl = false;
        try {
            byte[] byArray;
            if (l < 1L) {
                throw StandardException.newException("XJ070.S", new Long(l));
            }
            if (n < 0) {
                throw StandardException.newException("XJ071.S", new Integer(n));
            }
            if (this.isBytes) {
                if ((long)(this.myBytes.length + 1) < l) {
                    throw StandardException.newException("XJ076.S", new Long(l));
                }
                int n2 = this.myBytes.length - (int)l + 1;
                int n3 = n > n2 ? n2 : n;
                byArray = new byte[n3];
                System.arraycopy(this.myBytes, (int)l - 1, byArray, 0, n3);
            } else {
                Object object = this.getConnectionSynchronization();
                synchronized (object) {
                    boolean bl2 = bl = !this.getEmbedConnection().isClosed();
                    if (bl) {
                        this.setupContextStack();
                    }
                    this.setPosition(l - 1L);
                    byArray = new byte[n];
                    int n4 = InputStreamUtil.readLoop(this.biStream, byArray, 0, n);
                    this.pos += (long)n4;
                    if (n4 < n) {
                        byte[] byArray2 = new byte[n4];
                        System.arraycopy(byArray, 0, byArray2, 0, n4);
                        byte[] byArray3 = byArray2;
                        return byArray3;
                    }
                }
            }
            byte[] byArray4 = byArray;
            return byArray4;
        }
        catch (StandardException standardException) {
            StandardException standardException2;
            if (!standardException.getMessageId().equals("XJ079.S")) throw this.handleMyExceptions(standardException2);
            standardException2 = StandardException.newException("XJ076.S", new Long(l));
            throw this.handleMyExceptions(standardException2);
        }
        catch (Throwable throwable) {
            throw this.handleMyExceptions(throwable);
        }
        finally {
            if (bl) {
                this.restoreContextStack();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getBinaryStream() throws SQLException {
        this.checkValidity();
        boolean bl = false;
        try {
            if (this.isBytes) {
                NewByteArrayInputStream newByteArrayInputStream = new NewByteArrayInputStream(this.myBytes);
                return newByteArrayInputStream;
            }
            Object object = this.getConnectionSynchronization();
            synchronized (object) {
                try {
                    boolean bl2 = bl = !this.getEmbedConnection().isClosed();
                    if (bl) {
                        this.setupContextStack();
                    }
                    this.setPosition(0L);
                    BinaryToRawStream binaryToRawStream = this.biStream;
                    return binaryToRawStream;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        throw this.handleMyExceptions(throwable2);
                    }
                }
            }
        }
        finally {
            if (bl) {
                this.restoreContextStack();
            }
        }
    }

    /*
     * Exception decompiling
     */
    public long position(byte[] var1_1, long var2_2) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 2[TRYBLOCK]], but top level block is 13[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean checkMatch(byte[] byArray) throws IOException {
        for (int i = 1; i < byArray.length; ++i) {
            int n = this.read();
            if (n >= 0 && n == byArray[i]) continue;
            return false;
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    public long position(Blob var1_1, long var2_2) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 15[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean checkMatch(Blob blob) throws IOException {
        int n;
        InputStream inputStream;
        try {
            inputStream = blob.getBinaryStream();
        }
        catch (SQLException sQLException) {
            return false;
        }
        if (inputStream == null) {
            return false;
        }
        int n2 = inputStream.read();
        if (n2 < 0) {
            return false;
        }
        do {
            if ((n2 = inputStream.read()) >= 0) continue;
            return true;
        } while (n2 == (n = this.read()) && n >= 0);
        return false;
    }

    private SQLException handleMyExceptions(Throwable throwable) throws SQLException {
        if (throwable instanceof StandardException && ((StandardException)throwable).getMessageId().equals("40XD0")) {
            throwable = StandardException.newException("XJ073.S");
        }
        return this.handleException(throwable);
    }

    protected void finalize() {
        if (!this.isBytes) {
            ((Resetable)((Object)this.myStream)).closeStream();
        }
    }

    public int setBytes(long l, byte[] byArray) throws SQLException {
        throw Util.notImplemented();
    }

    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        throw Util.notImplemented();
    }

    public OutputStream setBinaryStream(long l) throws SQLException {
        throw Util.notImplemented();
    }

    public void truncate(long l) throws SQLException {
        throw Util.notImplemented();
    }

    public void free() throws SQLException {
        if (!this.isValid) {
            return;
        }
        this.isValid = false;
        this.myLength = -1L;
        if (!this.isBytes) {
            ((Resetable)((Object)this.myStream)).closeStream();
        } else {
            this.myBytes = null;
        }
    }

    public InputStream getBinaryStream(long l, long l2) throws SQLException {
        throw Util.notImplemented();
    }

    private void checkValidity() throws SQLException {
        if (!this.isValid) {
            throw this.newSQLException("XJ215.S");
        }
    }
}

