/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projects;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.util.WeakListeners;

class LineTranslations {
    private static LineTranslations translations;
    private ChangeListener changedFilesListener;
    private Map<Object, Registry> timeStampToRegistry = new WeakHashMap<Object, Registry>();
    private Map<LineBreakpoint, BreakpointLineUpdater> lineUpdaters = new HashMap<LineBreakpoint, BreakpointLineUpdater>();
    private Map<Object, Map<LineBreakpoint, Integer>> originalBreakpointLines = new WeakHashMap<Object, Map<LineBreakpoint, Integer>>();
    private Map<Object, PropertyChangeListener> breakpointListeners = new WeakHashMap<Object, PropertyChangeListener>();

    private LineTranslations() {
    }

    static synchronized LineTranslations getTranslations() {
        if (translations == null) {
            translations = new LineTranslations();
        }
        return translations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createTimeStamp(Object object) {
        Set set = DataObject.getRegistry().getModifiedSet();
        Registry registry = new Registry();
        LineTranslations lineTranslations = this;
        synchronized (lineTranslations) {
            this.timeStampToRegistry.put(object, registry);
            for (DataObject dataObject : set) {
                registry.register(dataObject);
            }
            if (this.changedFilesListener == null) {
                this.changedFilesListener = new ChangedFilesListener();
                DataObject.getRegistry().addChangeListener(this.changedFilesListener);
            }
        }
    }

    synchronized void disposeTimeStamp(Object object) {
        this.timeStampToRegistry.remove(object);
        if (this.timeStampToRegistry.isEmpty()) {
            DataObject.getRegistry().removeChangeListener(this.changedFilesListener);
            this.changedFilesListener = null;
        }
        this.originalBreakpointLines.remove(object);
        this.breakpointListeners.remove(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getOriginalLineNumber(LineBreakpoint lineBreakpoint, final Object object) {
        PropertyChangeListener propertyChangeListener;
        Object object2;
        Map<LineBreakpoint, Integer> map;
        LineTranslations lineTranslations = this;
        synchronized (lineTranslations) {
            map = this.originalBreakpointLines.get(object);
            if (map != null) {
                object2 = map.get(lineBreakpoint);
                if (object2 != null) {
                    return (Integer)object2;
                }
            } else {
                map = new WeakHashMap<LineBreakpoint, Integer>();
                this.originalBreakpointLines.put(object, map);
            }
        }
        int n = this.getOriginalLineNumber(lineBreakpoint.getURL(), lineBreakpoint.getLineNumber(), object);
        object2 = this;
        synchronized (object2) {
            map.put(lineBreakpoint, n);
            propertyChangeListener = new PropertyChangeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("lineNumber".equals(propertyChangeEvent.getPropertyName())) {
                        Map map;
                        LineTranslations lineTranslations = LineTranslations.this;
                        synchronized (lineTranslations) {
                            map = (Map)LineTranslations.this.originalBreakpointLines.get(object);
                            if (map == null) {
                                return;
                            }
                        }
                        lineTranslations = (LineBreakpoint)propertyChangeEvent.getSource();
                        int n = LineTranslations.this.getOriginalLineNumber(lineTranslations.getURL(), lineTranslations.getLineNumber(), object);
                        LineTranslations lineTranslations2 = LineTranslations.this;
                        synchronized (lineTranslations2) {
                            map.put(lineTranslations, n);
                        }
                    }
                }
            };
            this.breakpointListeners.put(object, propertyChangeListener);
        }
        lineBreakpoint.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)propertyChangeListener, (Object)lineBreakpoint));
        return n;
    }

    int getOriginalLineNumber(String string, int n, Object object) {
        if (object == null) {
            return n;
        }
        Line.Set set = this.getLineSet(string, object);
        if (set == null) {
            return n;
        }
        try {
            return set.getOriginalLineNumber(set.getCurrent(n));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateTimeStamp(Object object, String string) {
        DataObject dataObject = LineTranslations.getDataObject(string);
        LineTranslations lineTranslations = this;
        synchronized (lineTranslations) {
            Registry registry = this.timeStampToRegistry.get(object);
            registry.register(dataObject);
            Map<LineBreakpoint, Integer> map = this.originalBreakpointLines.get(object);
            if (map != null) {
                HashSet<LineBreakpoint> hashSet = new HashSet<LineBreakpoint>(map.keySet());
                for (LineBreakpoint lineBreakpoint : hashSet) {
                    if (!string.equals(lineBreakpoint.getURL())) continue;
                    map.remove(lineBreakpoint);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Line.Set getLineSet(String string, Object object) {
        LineTranslations lineTranslations;
        DataObject dataObject = LineTranslations.getDataObject(string);
        if (dataObject == null) {
            return null;
        }
        if (object != null) {
            lineTranslations = this;
            synchronized (lineTranslations) {
                Line.Set set;
                Registry registry = this.timeStampToRegistry.get(object);
                if (registry != null && (set = registry.getLineSet(dataObject)) != null) {
                    return set;
                }
            }
        }
        if ((lineTranslations = (LineCookie)dataObject.getCookie(LineCookie.class)) == null) {
            return null;
        }
        return lineTranslations.getLineSet();
    }

    Line getLine(String string, int n, Object object) {
        Line.Set set = this.getLineSet(string, object);
        if (set == null) {
            return null;
        }
        try {
            if (object == null) {
                return set.getCurrent(n - 1);
            }
            return set.getOriginal(n - 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerForLineUpdates(LineBreakpoint lineBreakpoint) {
        DataObject dataObject = LineTranslations.getDataObject(lineBreakpoint.getURL());
        if (dataObject != null) {
            BreakpointLineUpdater breakpointLineUpdater = new BreakpointLineUpdater(lineBreakpoint, dataObject);
            try {
                breakpointLineUpdater.attach();
                LineTranslations lineTranslations = this;
                synchronized (lineTranslations) {
                    this.lineUpdaters.put(lineBreakpoint, breakpointLineUpdater);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterFromLineUpdates(LineBreakpoint lineBreakpoint) {
        BreakpointLineUpdater breakpointLineUpdater;
        LineTranslations lineTranslations = this;
        synchronized (lineTranslations) {
            breakpointLineUpdater = this.lineUpdaters.remove(lineBreakpoint);
        }
        if (breakpointLineUpdater != null) {
            breakpointLineUpdater.detach();
        }
    }

    private static DataObject getDataObject(String string) {
        FileObject fileObject;
        try {
            fileObject = URLMapper.findFileObject((URL)new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        if (fileObject == null) {
            return null;
        }
        try {
            return DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return null;
        }
    }

    private class BreakpointLineUpdater
    implements PropertyChangeListener {
        private final LineBreakpoint lb;
        private DataObject dataObject;
        private Line line;
        private boolean updatingLine = false;

        public BreakpointLineUpdater(LineBreakpoint lineBreakpoint, DataObject dataObject) {
            this.lb = lineBreakpoint;
            this.dataObject = dataObject;
        }

        public synchronized void attach() throws IOException {
            LineCookie lineCookie = (LineCookie)this.dataObject.getCookie(LineCookie.class);
            if (lineCookie == null) {
                return;
            }
            this.lb.addPropertyChangeListener((PropertyChangeListener)this);
            try {
                this.line = lineCookie.getLineSet().getCurrent(this.lb.getLineNumber() - 1);
                this.line.addPropertyChangeListener((PropertyChangeListener)this);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }

        public synchronized void detach() {
            this.lb.removePropertyChangeListener((PropertyChangeListener)this);
            if (this.line != null) {
                this.line.removePropertyChangeListener((PropertyChangeListener)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void update(Line line) {
            try {
                int n;
                BreakpointLineUpdater breakpointLineUpdater = this;
                synchronized (breakpointLineUpdater) {
                    this.updatingLine = true;
                    n = line.getLineNumber() + 1;
                }
                this.lb.setLineNumber(n);
            }
            finally {
                BreakpointLineUpdater breakpointLineUpdater = this;
                synchronized (breakpointLineUpdater) {
                    this.updatingLine = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object;
            BreakpointLineUpdater breakpointLineUpdater;
            boolean bl;
            Line line;
            String string = propertyChangeEvent.getPropertyName();
            BreakpointLineUpdater breakpointLineUpdater2 = this;
            synchronized (breakpointLineUpdater2) {
                line = this.line;
                bl = this.updatingLine;
            }
            if ("lineNumber".equals(string) && line == propertyChangeEvent.getSource()) {
                this.update(line);
                return;
            }
            if (!bl && "lineNumber".equals(string)) {
                breakpointLineUpdater = this;
                synchronized (breakpointLineUpdater) {
                    this.line.removePropertyChangeListener((PropertyChangeListener)this);
                    if (this.dataObject == null) {
                        return;
                    }
                    breakpointLineUpdater2 = this.dataObject;
                }
                try {
                    object = (LineCookie)breakpointLineUpdater2.getCookie(LineCookie.class);
                    breakpointLineUpdater = object.getLineSet().getCurrent(this.lb.getLineNumber() - 1);
                    breakpointLineUpdater.addPropertyChangeListener(this);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    breakpointLineUpdater = null;
                }
                object = this;
                synchronized (object) {
                    this.line = breakpointLineUpdater;
                }
            }
            if ("url".equals(string)) {
                breakpointLineUpdater2 = LineTranslations.getDataObject(this.lb.getURL());
                if (breakpointLineUpdater2 != null) {
                    object = (LineCookie)breakpointLineUpdater2.getCookie(LineCookie.class);
                    try {
                        breakpointLineUpdater = object.getLineSet().getCurrent(this.lb.getLineNumber() - 1);
                        breakpointLineUpdater.addPropertyChangeListener(this);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        breakpointLineUpdater = null;
                    }
                } else {
                    breakpointLineUpdater = null;
                }
                object = this;
                synchronized (object) {
                    this.line.removePropertyChangeListener((PropertyChangeListener)this);
                    this.dataObject = breakpointLineUpdater2;
                    this.line = breakpointLineUpdater;
                }
            }
        }
    }

    private class ChangedFilesListener
    implements ChangeListener {
        private ChangedFilesListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stateChanged(ChangeEvent changeEvent) {
            HashSet hashSet = new HashSet(DataObject.getRegistry().getModifiedSet());
            LineTranslations lineTranslations = LineTranslations.this;
            synchronized (lineTranslations) {
                for (Registry registry : LineTranslations.this.timeStampToRegistry.values()) {
                    for (DataObject dataObject : hashSet) {
                        registry.registerIfNotThere(dataObject);
                    }
                }
            }
        }
    }

    private static class Registry {
        private Map<DataObject, Line.Set> dataObjectToLineSet = new HashMap<DataObject, Line.Set>();

        private Registry() {
        }

        synchronized void register(DataObject dataObject) {
            LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
            if (lineCookie == null) {
                return;
            }
            this.dataObjectToLineSet.put(dataObject, lineCookie.getLineSet());
        }

        synchronized void registerIfNotThere(DataObject dataObject) {
            if (!this.dataObjectToLineSet.containsKey(dataObject)) {
                this.register(dataObject);
            }
        }

        synchronized Line.Set getLineSet(DataObject dataObject) {
            return this.dataObjectToLineSet.get(dataObject);
        }
    }
}

