/*
 * Decompiled with CFR 0.152.
 */
package freemind.view.mindmapview;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ImageIcon;

public class MultipleImage
extends ImageIcon {
    private Vector mImages = new Vector();
    private double zoomFactor = 1.0;
    private boolean isDirty;

    public MultipleImage(double zoom) {
        this.zoomFactor = zoom;
        this.isDirty = true;
    }

    public int getImageCount() {
        return this.mImages.size();
    }

    public void addImage(ImageIcon image) {
        this.mImages.add(image);
        this.setImage(image.getImage());
        this.isDirty = true;
    }

    public Image getImage() {
        if (!this.isDirty) {
            return super.getImage();
        }
        int w = this.getIconWidth();
        int h = this.getIconHeight();
        if (w == 0 || h == 0) {
            return null;
        }
        BufferedImage outImage = new BufferedImage(w, h, 2);
        Graphics2D g = outImage.createGraphics();
        double myX = 0.0;
        Iterator i = this.mImages.iterator();
        while (i.hasNext()) {
            ImageIcon currentIcon = (ImageIcon)i.next();
            double pwidth = (double)currentIcon.getIconWidth() * this.zoomFactor;
            AffineTransform inttrans = AffineTransform.getScaleInstance(this.zoomFactor, this.zoomFactor);
            g.drawImage(currentIcon.getImage(), inttrans, null);
            g.translate(pwidth, 0.0);
            myX += pwidth;
        }
        g.dispose();
        this.setImage(outImage);
        this.isDirty = false;
        return super.getImage();
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.getImage() != null) {
            super.paintIcon(c, g, x, y);
        }
    }

    public int getIconWidth() {
        int myX = 0;
        for (int i = 0; i < this.mImages.size(); ++i) {
            myX += ((ImageIcon)this.mImages.get(i)).getIconWidth();
        }
        return (int)((double)myX * this.zoomFactor);
    }

    public int getIconHeight() {
        int myY = 0;
        for (int i = 0; i < this.mImages.size(); ++i) {
            int otherHeight = ((ImageIcon)this.mImages.get(i)).getIconHeight();
            if (otherHeight <= myY) continue;
            myY = otherHeight;
        }
        return (int)((double)myY * this.zoomFactor);
    }
}

