/*
 * Decompiled with CFR 0.152.
 */
package freemind.controller.filter;

import freemind.controller.Controller;
import freemind.controller.filter.Filter;
import freemind.controller.filter.condition.Condition;
import freemind.modes.MindMap;
import freemind.modes.MindMapNode;
import freemind.view.mindmapview.MapView;
import freemind.view.mindmapview.NodeView;
import java.util.LinkedList;
import java.util.ListIterator;

public class DefaultFilter
implements Filter {
    private Condition condition = null;
    private int options = 0;

    public DefaultFilter(Condition condition, boolean areAnchestorsShown, boolean areDescendantsShown) {
        this.condition = condition;
        this.options = 3;
        if (areAnchestorsShown) {
            this.options += 4;
        }
        this.options += 16;
        if (areDescendantsShown) {
            this.options += 8;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyFilter(Controller c) {
        if (this.condition != null) {
            try {
                c.getFrame().setWaitingCursor(true);
                MindMap map = c.getModel();
                MapView mapView = c.getView();
                MindMapNode root = map.getRootNode();
                DefaultFilter.resetFilter(root);
                if (this.filterChildren(root, c, this.condition.checkNode(c, root), false)) {
                    DefaultFilter.addFilterResult(root, 4);
                }
                DefaultFilter.selectVisibleNode(mapView);
            }
            finally {
                c.getFrame().setWaitingCursor(false);
            }
        }
    }

    public static void selectVisibleNode(MapView mapView) {
        LinkedList selectedNodes = mapView.getSelecteds();
        int lastSelectedIndex = selectedNodes.size() - 1;
        if (lastSelectedIndex == -1) {
            return;
        }
        ListIterator iterator = selectedNodes.listIterator(lastSelectedIndex);
        while (iterator.hasPrevious()) {
            NodeView previous = (NodeView)iterator.previous();
            if (previous.getModel().isVisible()) continue;
            mapView.toggleSelected(previous);
        }
        NodeView selected = mapView.getSelected();
        if (!selected.getModel().isVisible()) {
            selected = DefaultFilter.getNearestVisibleParent(selected);
            mapView.selectAsTheOnlyOneSelected(selected);
        }
        mapView.setSiblingMaxLevel(selected.getModel().getNodeLevel());
    }

    private static NodeView getNearestVisibleParent(NodeView selectedNode) {
        if (selectedNode.getModel().isVisible()) {
            return selectedNode;
        }
        return DefaultFilter.getNearestVisibleParent(selectedNode.getParentView());
    }

    private boolean filterChildren(MindMapNode parent, Controller c, boolean isAncestorSelected, boolean isAncestorEclipsed) {
        ListIterator iterator = parent.childrenUnfolded();
        boolean isDescendantSelected = false;
        while (iterator.hasNext()) {
            MindMapNode node = (MindMapNode)iterator.next();
            isDescendantSelected = this.applyFilter(node, c, isAncestorSelected, isAncestorEclipsed, isDescendantSelected);
        }
        return isDescendantSelected;
    }

    private boolean applyFilter(MindMapNode node, Controller c, boolean isAncestorSelected, boolean isAncestorEclipsed, boolean isDescendantSelected) {
        boolean conditionSatisfied;
        DefaultFilter.resetFilter(node);
        if (isAncestorSelected) {
            DefaultFilter.addFilterResult(node, 8);
        }
        if (conditionSatisfied = this.condition.checkNode(c, node)) {
            isDescendantSelected = true;
            DefaultFilter.addFilterResult(node, 2);
        } else {
            DefaultFilter.addFilterResult(node, 32);
        }
        if (isAncestorEclipsed) {
            DefaultFilter.addFilterResult(node, 16);
        }
        if (this.filterChildren(node, c, conditionSatisfied || isAncestorSelected, !conditionSatisfied || isAncestorEclipsed)) {
            DefaultFilter.addFilterResult(node, 4);
            isDescendantSelected = true;
        }
        return isDescendantSelected;
    }

    public boolean isVisible(MindMapNode node) {
        if (this.condition == null) {
            return true;
        }
        int filterResult = node.getFilterInfo().get();
        return ((this.options & 4) != 0 || (this.options & 0x10) >= (filterResult & 0x10)) && (this.options & filterResult & 0xFFFFFFEF) != 0;
    }

    public static void resetFilter(MindMapNode node) {
        node.getFilterInfo().reset();
    }

    static void addFilterResult(MindMapNode node, int flag) {
        node.getFilterInfo().add(flag);
    }

    public boolean areMatchedShown() {
        return true;
    }

    public boolean areHiddenShown() {
        return false;
    }

    public boolean areAncestorsShown() {
        return 0 != (this.options & 4);
    }

    public boolean areDescendantsShown() {
        return 0 != (this.options & 8);
    }

    public boolean areEclipsedShown() {
        return true;
    }

    public Object getCondition() {
        return this.condition;
    }
}

