/*
 * Decompiled with CFR 0.152.
 */
package freemind.common;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import freemind.common.PropertyBean;
import freemind.common.PropertyControl;
import freemind.common.TextTranslator;
import freemind.main.Resources;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class NumberProperty
extends PropertyBean
implements PropertyControl {
    String description;
    String label;
    private JSpinner spinner;
    private final int min;
    private final int max;
    private final int step;

    public NumberProperty(String description, String label, int min, int max, int step) {
        this.min = min;
        this.max = max;
        this.step = step;
        this.spinner = new JSpinner(new SpinnerNumberModel(min, min, max, step));
        this.description = description;
        this.label = label;
        this.spinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent pE) {
                NumberProperty.this.firePropertyChangeEvent();
            }
        });
    }

    public String getDescription() {
        return this.description;
    }

    public String getLabel() {
        return this.label;
    }

    public void setValue(String value) {
        int intValue = this.min;
        try {
            int parsedIntValue;
            intValue = parsedIntValue = Integer.parseInt(value);
            int stepModul = (intValue - this.min) % this.step;
            if (intValue < this.min || intValue > this.max || stepModul != 0) {
                System.err.println("Actual value of property " + this.getLabel() + " is not in the allowed range: " + value);
                intValue = this.min;
            }
        }
        catch (NumberFormatException e) {
            Resources.getInstance().logException(e);
        }
        this.spinner.setValue(new Integer(intValue));
    }

    public String getValue() {
        return this.spinner.getValue().toString();
    }

    public void layout(DefaultFormBuilder builder, TextTranslator pTranslator) {
        JLabel label = builder.append(pTranslator.getText(this.getLabel()), (Component)this.spinner);
        label.setToolTipText(pTranslator.getText(this.getDescription()));
    }

    public void setEnabled(boolean pEnabled) {
        this.spinner.setEnabled(pEnabled);
    }
}

