/*
 * Decompiled with CFR 0.152.
 */
package freemind.view.mindmapview;

import freemind.controller.Controller;
import freemind.main.FreeMindMain;
import freemind.main.HtmlTools;
import freemind.main.Resources;
import freemind.main.Tools;
import freemind.modes.MindIcon;
import freemind.modes.MindMapCloud;
import freemind.modes.MindMapNode;
import freemind.modes.NodeAdapter;
import freemind.view.mindmapview.BubbleMainView;
import freemind.view.mindmapview.CloudView;
import freemind.view.mindmapview.EdgeView;
import freemind.view.mindmapview.MainView;
import freemind.view.mindmapview.MapView;
import freemind.view.mindmapview.MultipleImage;
import freemind.view.mindmapview.NodeMotionListenerView;
import freemind.view.mindmapview.NodeViewFactory;
import freemind.view.mindmapview.NodeViewLayout;
import freemind.view.mindmapview.attributeview.AttributeView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeNode;

public class NodeView
extends JComponent
implements TreeModelListener {
    private static int FOLDING_SYMBOL_WIDTH = -1;
    protected MindMapNode model;
    protected MapView map;
    private MainView mainView;
    private AttributeView attributeView;
    protected static final Color dragColor = Color.lightGray;
    private boolean left = true;
    private boolean isLong = false;
    public static final int DRAGGED_OVER_NO = 0;
    public static final int DRAGGED_OVER_SON = 1;
    public static final int DRAGGED_OVER_SIBLING = 2;
    public static final int DRAGGED_OVER_SON_LEFT = 3;
    static final int ALIGN_BOTTOM = -1;
    static final int ALIGN_CENTER = 0;
    static final int ALIGN_TOP = 1;
    private static final Point zeroPoint = new Point(0, 0);
    private static Logger logger;
    private Object viewDeletionEvent;
    private int maxToolTipWidth;
    private NodeView preferredChild;
    private JComponent contentPane;
    protected NodeMotionListenerView motionListenerView;
    static final int SPACE_AROUND = 50;

    protected NodeView(MindMapNode model, int position, MapView map, Container parent) {
        if (logger == null) {
            logger = map.getController().getFrame().getLogger(this.getClass().getName());
        }
        this.setFocusCycleRoot(true);
        this.model = model;
        this.map = map;
        TreeNode parentNode = model.getParent();
        int index = parentNode == null ? 0 : parentNode.getIndex(model);
        this.createAttributeView();
        parent.add((Component)this, index);
        if (!model.isRoot()) {
            this.motionListenerView = new NodeMotionListenerView(this);
            map.add((Component)this.motionListenerView, map.getComponentCount() - 1);
        }
    }

    void setMainView(MainView newMainView) {
        if (this.mainView != null) {
            int i;
            Container c = this.mainView.getParent();
            for (i = c.getComponentCount() - 1; i >= 0 && this.mainView != c.getComponent(i); --i) {
            }
            c.remove(i);
            this.mainView.removeMouseListener(this.map.getNodeMouseMotionListener());
            this.mainView.removeMouseMotionListener(this.map.getNodeMouseMotionListener());
            this.mainView.removeKeyListener(this.map.getNodeKeyListener());
            c.add((Component)newMainView, i);
        } else {
            this.add(newMainView);
        }
        this.mainView = newMainView;
        this.mainView.addMouseListener(this.map.getNodeMouseMotionListener());
        this.mainView.addMouseMotionListener(this.map.getNodeMouseMotionListener());
        this.mainView.addKeyListener(this.map.getNodeKeyListener());
        this.addDragListener(this.map.getNodeDragListener());
        this.addDropListener(this.map.getNodeDropListener());
    }

    protected void removeFromMap() {
        this.setFocusCycleRoot(false);
        this.getParent().remove(this);
        if (this.motionListenerView != null) {
            this.map.remove(this.motionListenerView);
        }
    }

    void addDragListener(DragGestureListener dgl) {
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this.getMainView(), 0x40000003, dgl);
    }

    void addDropListener(DropTargetListener dtl) {
        DropTarget dropTarget = new DropTarget(this.getMainView(), dtl);
        dropTarget.setActive(true);
    }

    public boolean isRoot() {
        return this.getModel().isRoot();
    }

    public boolean getIsLong() {
        return this.isLong;
    }

    public boolean isSiblingOf(NodeView myNodeView) {
        return this.getParentView() == myNodeView.getParentView();
    }

    public boolean isChildOf(NodeView myNodeView) {
        return this.getParentView() == myNodeView;
    }

    public boolean isParentOf(NodeView myNodeView) {
        return this == myNodeView.getParentView();
    }

    public MindMapNode getModel() {
        return this.model;
    }

    public void getCoordinates(LinkedList inList) {
        this.getCoordinates(inList, 0, false, 0, 0);
    }

    private void getCoordinates(LinkedList inList, int additionalDistanceForConvexHull, boolean byChildren, int transX, int transY) {
        if (!this.isVisible()) {
            return;
        }
        if (this.isContentVisible()) {
            MindMapCloud cloud = this.getModel().getCloud();
            if (byChildren && cloud != null) {
                additionalDistanceForConvexHull += CloudView.getAdditionalHeigth(cloud, this) / 5;
            }
            int x = transX + this.getContent().getX() - this.getDeltaX();
            int y = transY + this.getContent().getY() - this.getDeltaY();
            int width = this.getMainViewWidthWithFoldingMark();
            int heightWithFoldingMark = this.getMainViewHeightWithFoldingMark();
            int height = Math.max(heightWithFoldingMark, this.getContent().getHeight());
            inList.addLast(new Point(-additionalDistanceForConvexHull + x, -additionalDistanceForConvexHull + y));
            inList.addLast(new Point(-additionalDistanceForConvexHull + x, additionalDistanceForConvexHull + y + height));
            inList.addLast(new Point(additionalDistanceForConvexHull + x + width, additionalDistanceForConvexHull + y + height));
            inList.addLast(new Point(additionalDistanceForConvexHull + x + width, -additionalDistanceForConvexHull + y));
        }
        LinkedList childrenViews = this.getChildrenViews();
        ListIterator children_it = childrenViews.listIterator();
        while (children_it.hasNext()) {
            NodeView child = (NodeView)children_it.next();
            child.getCoordinates(inList, additionalDistanceForConvexHull, true, transX + child.getX(), transY + child.getY());
        }
    }

    public void setText(String string) {
        this.mainView.setText(string);
    }

    public String getText() {
        return this.mainView.getText();
    }

    protected int getMainViewWidthWithFoldingMark() {
        return this.mainView.getMainViewWidthWithFoldingMark();
    }

    protected int getMainViewHeightWithFoldingMark() {
        return this.mainView.getMainViewHeightWithFoldingMark();
    }

    public int getDeltaX() {
        return this.mainView.getDeltaX();
    }

    public int getDeltaY() {
        return this.mainView.getDeltaY();
    }

    public void requestFocus() {
        this.mainView.requestFocusInWindow();
    }

    public boolean focused() {
        return this.mainView.hasFocus();
    }

    public int getAdditionalCloudHeigth() {
        if (!this.isContentVisible()) {
            return 0;
        }
        MindMapCloud cloud = this.getModel().getCloud();
        if (cloud != null) {
            return CloudView.getAdditionalHeigth(cloud, this);
        }
        return 0;
    }

    public boolean isSelected() {
        return this.getMap().isSelected(this);
    }

    public boolean isLeft() {
        return this.getModel().isLeft();
    }

    protected void setModel(MindMapNode model) {
        this.model = model;
    }

    public MapView getMap() {
        return this.map;
    }

    boolean isParentHidden() {
        Container parent = this.getParent();
        if (!(parent instanceof NodeView)) {
            return false;
        }
        NodeView parentView = (NodeView)parent;
        return !parentView.isContentVisible();
    }

    public NodeView getParentView() {
        Container parent = this.getParent();
        if (parent instanceof NodeView) {
            return (NodeView)parent;
        }
        return null;
    }

    public NodeView getVisibleParentView() {
        Container parent = this.getParent();
        if (!(parent instanceof NodeView)) {
            return null;
        }
        NodeView parentView = (NodeView)parent;
        if (parentView.isContentVisible()) {
            return parentView;
        }
        return parentView.getVisibleParentView();
    }

    public LinkedList getChildrenViews() {
        LinkedList<NodeView> childrenViews = new LinkedList<NodeView>();
        Component[] components = this.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof NodeView)) continue;
            NodeView view = (NodeView)components[i];
            childrenViews.add(view);
        }
        return childrenViews;
    }

    protected LinkedList getSiblingViews() {
        return this.getParentView().getChildrenViews();
    }

    Point getMainViewOutPoint(NodeView targetView, Point destinationPoint) {
        NodeViewLayout layoutManager = (NodeViewLayout)this.getLayout();
        Point out = layoutManager.getMainViewOutPoint(this, targetView, destinationPoint);
        return out;
    }

    Point getMainViewInPoint() {
        NodeViewLayout layoutManager = (NodeViewLayout)this.getLayout();
        Point in = layoutManager.getMainViewInPoint(this);
        return in;
    }

    public Point getLinkPoint(Point declination) {
        Point linkPoint;
        int y;
        int x;
        if (declination != null) {
            x = this.getMap().getZoomed(declination.x);
            y = this.getMap().getZoomed(declination.y);
        } else {
            x = 1;
            y = 0;
        }
        if (this.isLeft()) {
            x = -x;
        }
        if (y != 0) {
            int absLinkY;
            int absLinkX;
            double ctgLine;
            double ctgRect = Math.abs((double)this.getContent().getWidth() / (double)this.getContent().getHeight());
            if (ctgRect > (ctgLine = Math.abs((double)x / (double)y))) {
                absLinkX = Math.abs(x * this.getContent().getHeight() / (2 * y));
                absLinkY = this.getContent().getHeight() / 2;
            } else {
                absLinkX = this.getContent().getWidth() / 2;
                absLinkY = Math.abs(y * this.getContent().getWidth() / (2 * x));
            }
            linkPoint = new Point(this.getContent().getWidth() / 2 + (x > 0 ? absLinkX : -absLinkX), this.getContent().getHeight() / 2 + (y > 0 ? absLinkY : -absLinkY));
        } else {
            linkPoint = new Point(x > 0 ? this.getContent().getWidth() : 0, this.getContent().getHeight() / 2);
        }
        linkPoint.translate(this.getContent().getX(), this.getContent().getY());
        this.convertPointToMap(linkPoint);
        return linkPoint;
    }

    protected void convertPointToMap(Point p) {
        Tools.convertPointToAncestor((Component)this, p, this.getMap());
    }

    int getAlignment() {
        return this.mainView.getAlignment();
    }

    protected NodeView getNextPage() {
        if (this.getModel().isRoot()) {
            return this;
        }
        NodeView sibling = this.getNextVisibleSibling();
        if (sibling == this) {
            return this;
        }
        for (NodeView nextSibling = sibling.getNextVisibleSibling(); nextSibling != sibling && sibling.getParentView() == nextSibling.getParentView(); nextSibling = nextSibling.getNextVisibleSibling()) {
            sibling = nextSibling;
        }
        return sibling;
    }

    protected NodeView getPreviousPage() {
        if (this.getModel().isRoot()) {
            return this;
        }
        NodeView sibling = this.getPreviousVisibleSibling();
        if (sibling == this) {
            return this;
        }
        for (NodeView previousSibling = sibling.getPreviousVisibleSibling(); previousSibling != sibling && sibling.getParentView() == previousSibling.getParentView(); previousSibling = previousSibling.getPreviousVisibleSibling()) {
            sibling = previousSibling;
        }
        return sibling;
    }

    protected NodeView getNextVisibleSibling() {
        NodeView first;
        NodeView lastSibling = this;
        NodeView sibling = this;
        while (!sibling.getModel().isRoot()) {
            lastSibling = sibling;
            if ((sibling = sibling.getNextSiblingSingle()) != lastSibling) break;
            sibling = sibling.getParentView();
        }
        while (sibling.getModel().getNodeLevel() < this.getMap().getSiblingMaxLevel() && (first = sibling.getFirst(sibling.isRoot() ? lastSibling : null, this.isLeft(), !this.isLeft())) != null) {
            sibling = first;
        }
        if (sibling.isRoot()) {
            return this;
        }
        return sibling;
    }

    NodeView getFirst(Component startAfter, boolean leftOnly, boolean rightOnly) {
        Component[] components = this.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (startAfter != null) {
                if (components[i] != startAfter) continue;
                startAfter = null;
                continue;
            }
            if (!(components[i] instanceof NodeView)) continue;
            NodeView view = (NodeView)components[i];
            if (leftOnly && !view.isLeft() || rightOnly && view.isLeft()) continue;
            if (view.isContentVisible()) {
                return view;
            }
            NodeView child = view.getFirst(null, leftOnly, rightOnly);
            if (child == null) continue;
            return child;
        }
        return null;
    }

    public boolean isContentVisible() {
        return this.getModel().isVisible();
    }

    private NodeView getLast(Component startBefore, boolean leftOnly, boolean rightOnly) {
        Component[] components = this.getComponents();
        for (int i = components.length - 1; i >= 0; --i) {
            if (startBefore != null) {
                if (components[i] != startBefore) continue;
                startBefore = null;
                continue;
            }
            if (!(components[i] instanceof NodeView)) continue;
            NodeView view = (NodeView)components[i];
            if (leftOnly && !view.isLeft() || rightOnly && view.isLeft()) continue;
            if (view.isContentVisible()) {
                return view;
            }
            NodeView child = view.getLast(null, leftOnly, rightOnly);
            if (child == null) continue;
            return child;
        }
        return null;
    }

    LinkedList getLeft(boolean onlyVisible) {
        LinkedList all = this.getChildrenViews();
        LinkedList<NodeView> left = new LinkedList<NodeView>();
        ListIterator e = all.listIterator();
        while (e.hasNext()) {
            NodeView node = (NodeView)e.next();
            if (node == null || !node.isLeft()) continue;
            left.add(node);
        }
        return left;
    }

    LinkedList getRight(boolean onlyVisible) {
        LinkedList all = this.getChildrenViews();
        LinkedList<NodeView> right = new LinkedList<NodeView>();
        ListIterator e = all.listIterator();
        while (e.hasNext()) {
            NodeView node = (NodeView)e.next();
            if (node == null || node.isLeft()) continue;
            right.add(node);
        }
        return right;
    }

    protected NodeView getPreviousVisibleSibling() {
        NodeView last;
        NodeView previousSibling = this;
        NodeView sibling = this;
        while (!sibling.getModel().isRoot()) {
            previousSibling = sibling;
            if ((sibling = sibling.getPreviousSiblingSingle()) != previousSibling) break;
            sibling = sibling.getParentView();
        }
        while (sibling.getModel().getNodeLevel() < this.getMap().getSiblingMaxLevel() && (last = sibling.getLast(sibling.isRoot() ? previousSibling : null, this.isLeft(), !this.isLeft())) != null) {
            sibling = last;
        }
        if (sibling.isRoot()) {
            return this;
        }
        return sibling;
    }

    protected NodeView getNextSiblingSingle() {
        LinkedList v = null;
        v = this.getParentView().getModel().isRoot() ? (this.isLeft() ? this.getParentView().getLeft(true) : this.getParentView().getRight(true)) : this.getParentView().getChildrenViews();
        int index = v.indexOf(this);
        for (int i = index + 1; i < v.size(); ++i) {
            NodeView nextView = (NodeView)v.get(i);
            if (nextView.isContentVisible()) {
                return nextView;
            }
            NodeView first = nextView.getFirst(null, false, false);
            if (first == null) continue;
            return first;
        }
        return this;
    }

    protected NodeView getPreviousSiblingSingle() {
        LinkedList v = null;
        v = this.getParentView().getModel().isRoot() ? (this.isLeft() ? this.getParentView().getLeft(true) : this.getParentView().getRight(true)) : this.getParentView().getChildrenViews();
        int index = v.indexOf(this);
        for (int i = index - 1; i >= 0; --i) {
            NodeView nextView = (NodeView)v.get(i);
            if (nextView.isContentVisible()) {
                return nextView;
            }
            NodeView last = nextView.getLast(null, false, false);
            if (last == null) continue;
            return last;
        }
        return this;
    }

    void insert() {
        ListIterator it = this.getModel().childrenFolded();
        while (it.hasNext()) {
            this.insert((MindMapNode)it.next(), 0);
        }
    }

    NodeView insert(MindMapNode newNode, int position) {
        NodeView newView = NodeViewFactory.getInstance().newNodeView(newNode, position, this.getMap(), this);
        newView.insert();
        return newView;
    }

    void remove() {
        ListIterator e = this.getChildrenViews().listIterator();
        while (e.hasNext()) {
            ((NodeView)e.next()).remove();
        }
        if (this.isSelected()) {
            this.getMap().deselect(this);
        }
        this.getMap().getModel().getModeController().onViewRemovedHook(this);
        this.removeFromMap();
        if (this.attributeView != null) {
            this.attributeView.viewRemoved();
        }
        this.getModel().removeViewer(this);
    }

    void update() {
        this.updateStyle();
        if (!this.isContentVisible()) {
            this.mainView.setVisible(false);
            return;
        }
        this.mainView.setVisible(true);
        this.updateTextColor();
        this.updateFont();
        this.updateIcons();
        this.createAttributeView();
        if (this.attributeView != null) {
            this.attributeView.update();
        }
        this.updateText();
        this.updateToolTip();
        this.revalidate();
    }

    public void createAttributeView() {
        if (this.attributeView == null && this.model.getAttributes().getNode() != null) {
            this.attributeView = new AttributeView(this);
        }
    }

    void repaintSelected() {
        this.updateTextColor();
        this.repaint();
    }

    private void updateText() {
        String[] lines;
        String nodeText = ((Object)this.getModel()).toString();
        boolean isHtml = nodeText.startsWith("<html>");
        boolean widthMustBeRestricted = false;
        if (!isHtml) {
            lines = nodeText.split("\n");
            for (int line = 0; line < lines.length; ++line) {
                this.setText(lines[line]);
                boolean bl = widthMustBeRestricted = this.mainView.getPreferredSize().width > this.map.getZoomed(this.map.getMaxNodeWidth()) + this.mainView.getIconWidth();
                if (widthMustBeRestricted) break;
            }
            boolean bl = this.isLong = widthMustBeRestricted || lines.length > 1;
        }
        if (isHtml) {
            String htmlLongNodeHead;
            if (nodeText.indexOf("<img") >= 0 && nodeText.indexOf("<base ") < 0) {
                try {
                    nodeText = "<html><base href=\"" + this.map.getModel().getURL() + "\">" + nodeText.substring(6);
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
            if ((htmlLongNodeHead = this.map.getController().getFrame().getProperty("html_long_node_head")) != null && !htmlLongNodeHead.equals("")) {
                nodeText = nodeText.matches("(?ims).*<head>.*") ? nodeText.replaceFirst("(?ims).*<head>.*", "<head>" + htmlLongNodeHead) : nodeText.replaceFirst("(?ims)<html>", "<html><head>" + htmlLongNodeHead + "</head>");
            }
            if (nodeText.length() < 30000) {
                this.setText(nodeText);
                widthMustBeRestricted = this.mainView.getPreferredSize().width > this.map.getZoomed(this.map.getMaxNodeWidth()) + this.mainView.getIconWidth();
            } else {
                widthMustBeRestricted = true;
            }
            if (widthMustBeRestricted) {
                nodeText = nodeText.replaceFirst("(?i)<body>", "<body width=\"" + this.map.getMaxNodeWidth() + "\">");
            }
            this.setText(nodeText);
        } else if (nodeText.startsWith("<table>")) {
            lines = nodeText.split("\n");
            lines[0] = lines[0].substring(7);
            int startingLine = lines[0].matches("\\s*") ? 1 : 0;
            String text = "<html><table border=1 style=\"border-color: white\">";
            for (int line = startingLine; line < lines.length; ++line) {
                text = text + "<tr><td style=\"border-color: white;\">" + HtmlTools.toXMLEscapedText(lines[line]).replaceAll("\t", "<td style=\"border-color: white\">");
            }
            this.setText(text);
        } else if (this.isLong) {
            String text = HtmlTools.plainToHTML(nodeText);
            if (widthMustBeRestricted) {
                text = text.replaceFirst("(?i)<p>", "<p width=\"" + this.map.getMaxNodeWidth() + "\">");
            }
            this.setText(text);
        } else {
            this.setText(nodeText);
        }
    }

    private void updateFont() {
        Font font = this.getModel().getFont();
        Font font2 = font = font == null ? this.map.getController().getDefaultFont() : font;
        if (font != null) {
            this.mainView.setFont(font);
        } else {
            System.err.println("NodeView.update(): default font is null.");
        }
    }

    private void updateIcons() {
        Object myIcon;
        this.updateIconPosition();
        MultipleImage iconImages = new MultipleImage(1.0);
        boolean iconPresent = false;
        FreeMindMain frame = this.map.getController().getFrame();
        Map stateIcons = this.getModel().getStateIcons();
        Iterator i = stateIcons.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            iconPresent = true;
            myIcon = (ImageIcon)stateIcons.get(key);
            iconImages.addImage((ImageIcon)myIcon);
        }
        List icons = this.getModel().getIcons();
        Iterator i2 = icons.iterator();
        while (i2.hasNext()) {
            myIcon = (MindIcon)i2.next();
            iconPresent = true;
            iconImages.addImage(((MindIcon)myIcon).getIcon());
        }
        String link = ((NodeAdapter)this.getModel()).getLink();
        if (link != null) {
            iconPresent = true;
            String iconPath = "images/Link.png";
            if (link.startsWith("#")) {
                iconPath = "images/LinkLocal.png";
            } else if (link.startsWith("mailto:")) {
                iconPath = "images/Mail.png";
            } else if (Tools.executableByExtension(link)) {
                iconPath = "images/Executable.png";
            }
            ImageIcon icon = new ImageIcon(frame.getResource(iconPath));
            iconImages.addImage(icon);
        }
        this.setIcon(iconPresent ? iconImages : null);
    }

    private void updateIconPosition() {
        this.getMainView().setHorizontalTextPosition(this.isLeft() ? 10 : 11);
    }

    private void updateTextColor() {
        Color color = this.getModel().getColor();
        if (color == null) {
            color = MapView.standardNodeTextColor;
        }
        this.mainView.setForeground(color);
    }

    boolean useSelectionColors() {
        return this.isSelected() && !MapView.standardDrawRectangleForSelection && !this.map.isCurrentlyPrinting();
    }

    void updateStyle() {
        if (this.mainView != null && (this.mainView.getStyle().equals(this.model.getStyle()) || this.model.isRoot())) {
            return;
        }
        MainView newMainView = NodeViewFactory.getInstance().newMainView(this.model);
        this.setMainView(newMainView);
        if (this.map.getSelected() == this) {
            this.requestFocus();
        }
    }

    public void updateToolTip() {
        SortedMap tooltips = this.getModel().getToolTip();
        if (tooltips.size() == 0) {
            this.mainView.setToolTipText(null);
        } else {
            StringBuffer text = new StringBuffer("<html><table width=\"" + this.getMaxToolTipWidth() + "\">");
            Iterator i = tooltips.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                String value = (String)tooltips.get(key);
                value = value.replaceAll("</html>", "");
                text.append("<tr><td>");
                text.append(value);
                text.append("</td></tr>");
            }
            text.append("</table></html>");
            this.mainView.setToolTipText(text.toString());
        }
    }

    public int getMaxToolTipWidth() {
        if (this.maxToolTipWidth == 0) {
            try {
                this.maxToolTipWidth = this.map.getController().getIntProperty("max_tooltip_width", 600);
            }
            catch (NumberFormatException e) {
                this.maxToolTipWidth = 600;
            }
        }
        return this.maxToolTipWidth;
    }

    public void setIcon(MultipleImage image) {
        this.mainView.setIcon(image);
    }

    void updateAll() {
        this.update();
        this.invalidate();
        ListIterator e = this.getChildrenViews().listIterator();
        while (e.hasNext()) {
            NodeView child = (NodeView)e.next();
            child.updateAll();
        }
    }

    String getStyle() {
        return this.mainView.getStyle();
    }

    protected Color getSelectedColor() {
        return MapView.standardSelectColor;
    }

    protected static Color getAntiColor1(Color c) {
        float[] hsb = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
        hsb[0] = (float)((double)hsb[0] + 0.4);
        if (hsb[0] > 1.0f) {
            hsb[0] = hsb[0] - 1.0f;
        }
        hsb[1] = 1.0f;
        hsb[2] = 0.7f;
        return Color.getHSBColor(hsb[0], hsb[1], hsb[2]);
    }

    protected static Color getAntiColor2(Color c) {
        float[] hsb = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
        hsb[0] = (float)((double)hsb[0] - 0.4);
        if (hsb[0] < 0.0f) {
            hsb[0] = hsb[0] + 1.0f;
        }
        hsb[1] = 1.0f;
        hsb[2] = 0.8f;
        return Color.getHSBColor(hsb[0], hsb[1], hsb[2]);
    }

    public int getShift() {
        return this.map.getZoomed(this.model.calcShiftY());
    }

    public int getVGap() {
        return this.map.getZoomed(this.model.getVGap());
    }

    public int getHGap() {
        return this.map.getZoomed(this.model.getHGap());
    }

    public MainView getMainView() {
        return this.mainView;
    }

    void syncronizeAttributeView() {
        if (this.attributeView != null) {
            this.attributeView.syncronizeAttributeView();
        }
    }

    public Font getTextFont() {
        return this.getMainView().getFont();
    }

    public Color getTextColor() {
        Color color = this.getModel().getColor();
        if (color == null) {
            color = MapView.standardNodeTextColor;
        }
        return color;
    }

    public AttributeView getAttributeView() {
        if (this.attributeView == null) {
            this.model.createAttributeTableModel();
            this.attributeView = new AttributeView(this);
        }
        return this.attributeView;
    }

    public NodeView getPreferredVisibleChild(boolean left) {
        if (this.preferredChild != null && left == this.preferredChild.isLeft() && this.preferredChild.getParent() == this) {
            if (this.preferredChild.isContentVisible()) {
                return this.preferredChild;
            }
            NodeView newSelected = this.preferredChild.getPreferredVisibleChild(left);
            if (newSelected != null) {
                return newSelected;
            }
        }
        if (!this.getModel().isLeaf()) {
            int yGap = Integer.MAX_VALUE;
            NodeView baseComponent = this.isContentVisible() ? this : this.getVisibleParentView();
            int ownY = baseComponent.getMainView().getY() + baseComponent.getMainView().getHeight() / 2;
            NodeView newSelected = null;
            for (int i = 0; i < this.getComponentCount(); ++i) {
                NodeView childView;
                Component c = this.getComponent(i);
                if (!(c instanceof NodeView) || (childView = (NodeView)c).isLeft() != left || !childView.isContentVisible() && (childView = childView.getPreferredVisibleChild(left)) == null) continue;
                Point childPoint = new Point(0, childView.getMainView().getHeight() / 2);
                Tools.convertPointToAncestor((Component)childView.getMainView(), childPoint, baseComponent);
                int gapToChild = Math.abs(childPoint.y - ownY);
                if (gapToChild >= yGap) break;
                newSelected = childView;
                this.preferredChild = (NodeView)c;
                yGap = gapToChild;
            }
            return newSelected;
        }
        return null;
    }

    public void setPreferredChild(NodeView view) {
        this.preferredChild = view;
        Container parent = this.getParent();
        if (view == null) {
            return;
        }
        if (parent instanceof NodeView) {
            ((NodeView)parent).setPreferredChild(this);
        }
    }

    public void treeNodesChanged(TreeModelEvent e) {
        this.update();
    }

    public void treeNodesInserted(TreeModelEvent e) {
        if (this.getModel().isFolded()) {
            return;
        }
        int[] childIndices = e.getChildIndices();
        for (int i = 0; i < childIndices.length; ++i) {
            int index = childIndices[i];
            this.insert((MindMapNode)this.getModel().getChildAt(index), index);
        }
        this.revalidate();
    }

    public void treeNodesRemoved(TreeModelEvent e) {
        this.getMap().resetShiftSelectionOrigin();
        if (this.getModel().isFolded()) {
            return;
        }
        int[] childIndices = e.getChildIndices();
        boolean preferredChildIsLeft = this.preferredChild != null && this.preferredChild.isLeft();
        for (int i = childIndices.length - 1; i >= 0; --i) {
            int index = childIndices[i];
            NodeView node = (NodeView)this.getComponent(index);
            if (node == this.preferredChild) {
                NodeView candidate;
                Component c;
                int j;
                this.preferredChild = null;
                for (j = index + 1; j < this.getComponentCount() && (c = this.getComponent(j)) instanceof NodeView; ++j) {
                    candidate = (NodeView)c;
                    if (!candidate.isVisible() || node.isLeft() != candidate.isLeft()) continue;
                    this.preferredChild = candidate;
                    break;
                }
                if (this.preferredChild == null) {
                    for (j = index - 1; j >= 0 && (c = this.getComponent(j)) instanceof NodeView; --j) {
                        candidate = (NodeView)c;
                        if (!candidate.isVisible() || node.isLeft() != candidate.isLeft()) continue;
                        this.preferredChild = candidate;
                        break;
                    }
                }
            }
            node.remove();
        }
        NodeView preferred = this.getPreferredVisibleChild(preferredChildIsLeft);
        if (preferred != null) {
            this.getMap().selectAsTheOnlyOneSelected(preferred);
        } else {
            this.getMap().selectAsTheOnlyOneSelected(this);
        }
        this.revalidate();
    }

    public void treeStructureChanged(TreeModelEvent e) {
        this.getMap().resetShiftSelectionOrigin();
        ListIterator i = this.getChildrenViews().listIterator();
        while (i.hasNext()) {
            ((NodeView)i.next()).remove();
        }
        this.insert();
        if (this.map.getSelected() == null) {
            this.map.selectAsTheOnlyOneSelected(this);
        }
        this.map.revalidateSelecteds();
        this.revalidate();
    }

    public int getZoomedFoldingSymbolHalfWidth() {
        if (FOLDING_SYMBOL_WIDTH == -1) {
            FOLDING_SYMBOL_WIDTH = Resources.getInstance().getIntProperty("foldingsymbolwidth", 8);
        }
        int preferredFoldingSymbolHalfWidth = (int)((float)FOLDING_SYMBOL_WIDTH * this.map.getZoom() / 2.0f);
        return Math.min(preferredFoldingSymbolHalfWidth, this.getHeight() / 2);
    }

    public void paintFoldingMark(Graphics2D g) {
        if (this.getModel().isFolded()) {
            Point out = this.getMainViewOutPoint(null, null);
            Tools.convertPointToAncestor((Component)this.getMainView(), out, this);
            Controller controller = this.getMap().getController();
            Object renderingHint = controller.setEdgesRenderingHint(g);
            this.mainView.paintFoldingMark(this, g, out);
            Tools.restoreAntialiasing(g, renderingHint);
        }
    }

    public JComponent getContent() {
        return this.contentPane == null ? this.mainView : this.contentPane;
    }

    public Container getContentPane() {
        if (this.contentPane == null) {
            this.contentPane = NodeViewFactory.getInstance().newContentPane(this);
            int index = this.getComponentCount() - 1;
            this.remove(index);
            this.contentPane.add(this.mainView);
            this.add((Component)this.contentPane, index);
        }
        return this.contentPane;
    }

    public NodeMotionListenerView getMotionListenerView() {
        return this.motionListenerView;
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        if (this.motionListenerView != null) {
            this.motionListenerView.invalidate();
        }
    }

    public void setVisible(boolean isVisible) {
        super.setVisible(isVisible);
        if (this.motionListenerView != null) {
            this.motionListenerView.setVisible(isVisible);
        }
    }

    private void paintCloudsAndEdges(Graphics2D g) {
        Object renderingHint = this.map.getController().setEdgesRenderingHint(g);
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component component = this.getComponent(i);
            if (!(component instanceof NodeView)) continue;
            NodeView nodeView = (NodeView)component;
            if (nodeView.isContentVisible()) {
                Point p = new Point();
                Tools.convertPointToAncestor((Component)nodeView, p, this);
                g.translate(p.x, p.y);
                nodeView.paintCloud(g);
                g.translate(-p.x, -p.y);
                EdgeView edge = NodeViewFactory.getInstance().getEdge(nodeView);
                edge.paint(nodeView, g);
                continue;
            }
            nodeView.paintCloudsAndEdges(g);
        }
        Tools.restoreAntialiasing(g, renderingHint);
    }

    public void paint(Graphics g) {
        boolean isRoot = this.isRoot();
        if (isRoot) {
            this.paintCloud(g);
        }
        if (this.isContentVisible()) {
            Graphics2D g2d = (Graphics2D)g;
            this.paintCloudsAndEdges(g2d);
            super.paint(g);
            g2d.setStroke(BubbleMainView.DEF_STROKE);
            if (!isRoot) {
                this.paintFoldingMark(g2d);
            }
        } else {
            super.paint(g);
        }
    }

    private void paintCloud(Graphics g) {
        if (this.isContentVisible() && this.model.getCloud() != null) {
            CloudView cloud = new CloudView(this.model.getCloud(), this);
            cloud.paint(g);
        }
    }

    public String toString() {
        return ((Object)this.getModel()).toString() + ", " + super.toString();
    }

    Rectangle getInnerBounds() {
        int space = this.getMap().getZoomed(50);
        return new Rectangle(space, space, this.getWidth() - 2 * space, this.getHeight() - 2 * space);
    }

    public boolean contains(int x, int y) {
        int space = this.getMap().getZoomed(50) - 2 * this.getZoomedFoldingSymbolHalfWidth();
        return x >= space && x < this.getWidth() - space && y >= space && y < this.getHeight() - space;
    }

    public Color getTextBackground() {
        Color modelBackgroundColor = this.getModel().getBackgroundColor();
        if (modelBackgroundColor != null) {
            return modelBackgroundColor;
        }
        return this.getBackgroundColor();
    }

    private Color getBackgroundColor() {
        MindMapCloud cloud = this.getModel().getCloud();
        if (cloud != null) {
            return cloud.getColor();
        }
        if (this.isRoot()) {
            return this.getMap().getBackground();
        }
        return this.getParentView().getBackgroundColor();
    }
}

