/*
 * Decompiled with CFR 0.152.
 */
package freemind.controller;

import freemind.controller.Controller;
import freemind.modes.MindMapArrowLink;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPopupMenu;

public class MapMouseMotionListener
implements MouseMotionListener,
MouseListener {
    private MapMouseMotionReceiver mReceiver;
    private final Controller c;

    public MapMouseMotionListener(Controller controller) {
        this.c = controller;
    }

    public void register(MapMouseMotionReceiver receiver) {
        this.mReceiver = receiver;
    }

    public void deregister() {
        this.mReceiver = null;
    }

    private void handlePopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            JPopupMenu popup = null;
            MindMapArrowLink obj = this.c.getView().detectCollision(e.getPoint());
            if (obj != null) {
                popup = this.c.getModeController().getPopupForModel(obj);
            }
            if (popup == null) {
                popup = this.c.getFrame().getFreeMindMenuBar().getMapsPopupMenu();
            }
            popup.show(e.getComponent(), e.getX(), e.getY());
            popup.setVisible(true);
        }
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        if (this.mReceiver != null) {
            this.mReceiver.mouseDragged(e);
        }
    }

    public void mouseClicked(MouseEvent e) {
        this.c.getView().selectAsTheOnlyOneSelected(this.c.getView().getSelected());
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.handlePopup(e);
        } else if (this.mReceiver != null) {
            this.mReceiver.mousePressed(e);
        }
        e.consume();
    }

    public void mouseReleased(MouseEvent e) {
        if (this.mReceiver != null) {
            this.mReceiver.mouseReleased(e);
        }
        this.handlePopup(e);
        e.consume();
        this.c.getView().setMoveCursor(false);
    }

    public static interface MapMouseMotionReceiver {
        public void mouseDragged(MouseEvent var1);

        public void mousePressed(MouseEvent var1);

        public void mouseReleased(MouseEvent var1);
    }
}

