/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.browser.test;

import java.awt.Window;
import java.util.List;
import java.util.concurrent.Callable;
import javax.swing.SwingUtilities;
import junit.framework.Assert;
import org.mozilla.browser.MozillaAutomation;
import org.mozilla.browser.MozillaExecutor;
import org.mozilla.browser.MozillaInitialization;
import org.mozilla.browser.MozillaPanel;
import org.mozilla.browser.test.MozillaTest;

public class PopupTest
extends MozillaTest {
    private static final String TEST_URL = PopupTest.resolveURL("popup.html");

    public void testOpen() {
        PopupTest.assertFalse((boolean)MozillaAutomation.blockingLoad(this.moz, TEST_URL));
        MozillaExecutor.mozAsyncExec(new Runnable(){

            public void run() {
                Assert.assertFalse((boolean)MozillaAutomation.click(PopupTest.this.moz, "Open1"));
            }
        });
        PopupTest.assertNotNull((Object)MozillaAutomation.waitForWindowWithTitle("Popup1", 3000));
        MozillaExecutor.mozSyncExec(new Runnable(){

            public void run() {
                Assert.assertFalse((boolean)MozillaAutomation.click(PopupTest.this.moz, "Close1"));
            }
        });
        PopupTest.assertNull((Object)MozillaAutomation.waitForNoWindowWithTitle("Popup1", 3000));
        MozillaExecutor.mozSyncExec(new Runnable(){

            public void run() {
                Assert.assertFalse((boolean)MozillaAutomation.click(PopupTest.this.moz, "Open1"));
            }
        });
        final MozillaPanel childMoz = MozillaAutomation.waitForWindowWithTitle("Popup1", 3000);
        Assert.assertNotNull((Object)childMoz);
        MozillaExecutor.mozSyncExec(new Runnable(){

            public void run() {
                Assert.assertFalse((boolean)MozillaAutomation.click(childMoz, "Close"));
            }
        });
        PopupTest.assertNull((Object)MozillaAutomation.waitForNoWindowWithTitle("Popup1", 3000));
    }

    public void testDouble() {
        this.testOpen();
        PopupTest.flushSwingJobs();
        this.testOpen();
    }

    public void testMixedOrder() {
        PopupTest.assertFalse((boolean)MozillaAutomation.blockingLoad(this.moz, TEST_URL));
        MozillaExecutor.mozSyncExec(new Runnable(){

            public void run() {
                Assert.assertFalse((boolean)MozillaAutomation.click(PopupTest.this.moz, "Open1"));
                Assert.assertFalse((boolean)MozillaAutomation.click(PopupTest.this.moz, "Open2"));
            }
        });
        PopupTest.assertNotNull((Object)MozillaAutomation.waitForWindowWithTitle("Popup1", 3000));
        PopupTest.assertNotNull((Object)MozillaAutomation.waitForWindowWithTitle("Popup2", 3000));
        MozillaExecutor.mozSyncExec(new Runnable(){

            public void run() {
                Assert.assertFalse((boolean)MozillaAutomation.click(PopupTest.this.moz, "Close2"));
            }
        });
        PopupTest.assertNotNull((Object)MozillaAutomation.waitForWindowWithTitle("Popup1", 3000));
        PopupTest.assertNull((Object)MozillaAutomation.waitForNoWindowWithTitle("Popup2", 3000));
        MozillaExecutor.mozSyncExec(new Runnable(){

            public void run() {
                Assert.assertFalse((boolean)MozillaAutomation.click(PopupTest.this.moz, "Close1"));
            }
        });
        PopupTest.assertNull((Object)MozillaAutomation.waitForNoWindowWithTitle("Popup1", 3000));
        PopupTest.assertNull((Object)MozillaAutomation.waitForNoWindowWithTitle("Popup2", 3000));
    }

    public void dis_testManyOpens() throws Exception {
        PopupTest.assertFalse((boolean)MozillaAutomation.blockingLoad(this.moz, TEST_URL));
        log.debug("opening...");
        MozillaExecutor.swingSyncExec(new Runnable(){

            public void run() {
                MozillaInitialization.getWinCreator().ensurePrecreatedWindows(20);
            }
        });
        for (int i = 0; i < 20; ++i) {
            MozillaExecutor.mozSyncExec(new Runnable(){

                public void run() {
                    Assert.assertFalse((boolean)MozillaAutomation.click(PopupTest.this.moz, "Open3"));
                }
            });
            PopupTest.flushMozillaJobs();
            PopupTest.flushSwingJobs();
        }
        log.debug("openned");
        log.debug("closing...");
        List<MozillaPanel> panels = MozillaAutomation.waitForNumWindowsWithTitle("Popup3", 20, 10000);
        PopupTest.assertEquals((int)20, (int)panels.size());
        for (MozillaPanel panel : panels) {
            Window win = SwingUtilities.getWindowAncestor(panel);
            win.setVisible(false);
            win.dispose();
        }
        PopupTest.assertNull((Object)MozillaAutomation.waitForNoWindowWithTitle("Popup3", 10000));
        panels = MozillaExecutor.mozSyncExec(new Callable<List<MozillaPanel>>(){

            @Override
            public List<MozillaPanel> call() throws Exception {
                return MozillaAutomation.getOpennedWindows();
            }
        });
        PopupTest.assertEquals((int)1, (int)panels.size());
        log.debug("closed");
    }

    public void testZZZ() {
    }
}

