/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.upload;

import com.google.inject.Provider;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.Resource;
import org.limewire.bittorrent.Torrent;
import org.limewire.bittorrent.TorrentManager;
import org.limewire.core.settings.SharingSettings;
import org.limewire.core.settings.UploadSettings;
import org.limewire.ui.swing.components.FocusJOptionPane;
import org.limewire.ui.swing.downloads.ShowUploadsInTrayAction;
import org.limewire.ui.swing.options.OptionsDialog;
import org.limewire.ui.swing.transfer.TransferTrayNavigator;
import org.limewire.ui.swing.upload.UploadMediator;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;

class UploadHeaderPopupMenu
extends JPopupMenu {
    @Resource(key="DownloadHeaderPopupMenu.upArrow")
    private Icon upArrow;
    @Resource(key="DownloadHeaderPopupMenu.downArrow")
    private Icon downArrow;
    private final UploadMediator uploadMediator;
    private final Provider<TorrentManager> torrentManager;
    private final Provider<TransferTrayNavigator> transferTrayNavigator;

    public UploadHeaderPopupMenu(UploadMediator uploadMediator, Provider<TorrentManager> torrentManager, Provider<TransferTrayNavigator> transferTrayNavigator) {
        this.uploadMediator = uploadMediator;
        this.torrentManager = torrentManager;
        this.transferTrayNavigator = transferTrayNavigator;
        GuiUtils.assignResources(this);
        this.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                UploadHeaderPopupMenu.this.removeAll();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                UploadHeaderPopupMenu.this.removeAll();
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                UploadHeaderPopupMenu.this.populate();
            }
        });
    }

    private void populate() {
        this.removeAll();
        this.add(new AbstractAction(I18n.tr("Pause All")){

            @Override
            public void actionPerformed(ActionEvent e) {
                UploadHeaderPopupMenu.this.uploadMediator.pauseAll();
            }
        }).setEnabled(this.uploadMediator.hasPausable());
        this.add(new AbstractAction(I18n.tr("Resume All")){

            @Override
            public void actionPerformed(ActionEvent e) {
                UploadHeaderPopupMenu.this.uploadMediator.resumeAll();
            }
        }).setEnabled(this.uploadMediator.hasResumable());
        this.add(this.createCancelSubMenu());
        this.addSeparator();
        this.add(this.createSortSubMenu());
        this.addSeparator();
        this.add(this.createClearFinishedMenuItem());
        this.addSeparator();
        JCheckBoxMenuItem includeUploads = new JCheckBoxMenuItem(new ShowUploadsInTrayAction(this.transferTrayNavigator));
        includeUploads.setSelected(UploadSettings.SHOW_UPLOADS_IN_TRAY.getValue());
        this.add(includeUploads);
        this.addSeparator();
        this.add(new TransferOptionsAction());
    }

    private JMenu createCancelSubMenu() {
        JMenu cancelSubMenu = new JMenu(I18n.tr("Cancel"));
        cancelSubMenu.add(new AbstractAction(I18n.tr("All Error")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (UploadHeaderPopupMenu.this.confirmCancel(I18n.tr("Cancel all error uploads?"))) {
                    UploadHeaderPopupMenu.this.uploadMediator.cancelAllError();
                }
            }
        }).setEnabled(this.uploadMediator.hasErrors());
        cancelSubMenu.add(new AbstractAction(I18n.tr("All Torrents")){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPanel message = new JPanel(new MigLayout("nogrid, fill, gapy 15"));
                message.setOpaque(false);
                message.add((Component)new JLabel(I18n.tr("Cancel uploading all torrents?")), "wrap");
                if (UploadHeaderPopupMenu.this.getNumDownloadingTorrents() > 0) {
                    message.add(new JLabel(I18n.tr("Note: Downloading torrents will be cancelled as well.", "")));
                }
                if (UploadHeaderPopupMenu.this.confirmCancel(message)) {
                    UploadHeaderPopupMenu.this.uploadMediator.cancelAllTorrents();
                }
            }
        }).setEnabled(this.uploadMediator.hasTorrents());
        cancelSubMenu.add(new AbstractAction(I18n.tr("All Uploads")){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPanel message = new JPanel(new MigLayout("nogrid, fill, gapy 15"));
                message.setOpaque(false);
                message.add((Component)new JLabel(I18n.tr("Cancel all uploads?")), "wrap");
                if (UploadHeaderPopupMenu.this.getNumDownloadingTorrents() > 0) {
                    message.add(new JLabel(I18n.tr("Note: Downloading torrents will be cancelled as well.", "")));
                }
                if (UploadHeaderPopupMenu.this.confirmCancel(message)) {
                    UploadHeaderPopupMenu.this.uploadMediator.cancelAll();
                }
            }
        }).setEnabled(this.uploadMediator.getUploadList().size() > 0);
        return cancelSubMenu;
    }

    private int getNumDownloadingTorrents() {
        if (!this.torrentManager.get().isInitialized() || !this.torrentManager.get().isValid()) {
            return 0;
        }
        int numDownloading = 0;
        for (Torrent torrent : this.torrentManager.get().getTorrents()) {
            if (torrent.isFinished()) continue;
            ++numDownloading;
        }
        return numDownloading;
    }

    private JMenu createSortSubMenu() {
        JMenu sortSubMenu = new JMenu(I18n.tr("Sort by"));
        JCheckBoxMenuItem orderStarted = new JCheckBoxMenuItem(new SortAction(I18n.tr("Order Started"), UploadMediator.SortOrder.ORDER_STARTED));
        JCheckBoxMenuItem name = new JCheckBoxMenuItem(new SortAction(I18n.tr("Name"), UploadMediator.SortOrder.NAME));
        JCheckBoxMenuItem progress = new JCheckBoxMenuItem(new SortAction(I18n.tr("Progress"), UploadMediator.SortOrder.PROGRESS));
        JCheckBoxMenuItem timeRemaining = new JCheckBoxMenuItem(new SortAction(I18n.tr("Time Left"), UploadMediator.SortOrder.TIME_REMAINING));
        JCheckBoxMenuItem speed = new JCheckBoxMenuItem(new SortAction(I18n.tr("Speed"), UploadMediator.SortOrder.SPEED));
        JCheckBoxMenuItem status = new JCheckBoxMenuItem(new SortAction(I18n.tr("Status"), UploadMediator.SortOrder.STATUS));
        JCheckBoxMenuItem fileType = new JCheckBoxMenuItem(new SortAction(I18n.tr("File Type"), UploadMediator.SortOrder.FILE_TYPE));
        JCheckBoxMenuItem extension = new JCheckBoxMenuItem(new SortAction(I18n.tr("File Extension"), UploadMediator.SortOrder.FILE_EXTENSION));
        JCheckBoxMenuItem userName = new JCheckBoxMenuItem(new SortAction(I18n.tr("User Name"), UploadMediator.SortOrder.USER_NAME));
        ButtonGroup sortButtonGroup = new ButtonGroup();
        sortButtonGroup.add(orderStarted);
        sortButtonGroup.add(name);
        sortButtonGroup.add(progress);
        sortButtonGroup.add(timeRemaining);
        sortButtonGroup.add(speed);
        sortButtonGroup.add(status);
        sortButtonGroup.add(fileType);
        sortButtonGroup.add(extension);
        sortButtonGroup.add(userName);
        sortSubMenu.add(orderStarted);
        sortSubMenu.add(name);
        sortSubMenu.add(progress);
        sortSubMenu.add(timeRemaining);
        sortSubMenu.add(speed);
        sortSubMenu.add(status);
        sortSubMenu.add(fileType);
        sortSubMenu.add(extension);
        sortSubMenu.add(userName);
        sortSubMenu.addSeparator();
        JMenuItem reverseSortButton = new JMenuItem(new ReverseSortAction());
        sortSubMenu.add((Component)reverseSortButton);
        return sortSubMenu;
    }

    private JCheckBoxMenuItem createClearFinishedMenuItem() {
        JCheckBoxMenuItem checkBoxMenuItem = new JCheckBoxMenuItem(I18n.tr("Clear When Finished"));
        checkBoxMenuItem.setSelected(SharingSettings.CLEAR_UPLOAD.getValue());
        checkBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JMenuItem menuItem = (JMenuItem)e.getSource();
                SharingSettings.CLEAR_UPLOAD.setValue(menuItem.isSelected());
            }
        });
        return checkBoxMenuItem;
    }

    private boolean confirmCancel(Object message) {
        return FocusJOptionPane.showConfirmDialog(GuiUtils.getMainFrame(), message, I18n.tr("Cancel"), 0, 3) == 0;
    }

    private static class TransferOptionsAction
    extends AbstractAction {
        public TransferOptionsAction() {
            super(I18n.tr("More Transfer Options..."));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ApplicationActionMap map = Application.getInstance().getContext().getActionManager().getActionMap();
            map.get("showOptionsDialog").actionPerformed(new ActionEvent(this, 1001, OptionsDialog.TRANSFERS));
        }
    }

    private class ReverseSortAction
    extends AbstractAction {
        public ReverseSortAction() {
            super(I18n.tr("Reverse Order"));
            this.putValue("SwingSelectedKey", UploadHeaderPopupMenu.this.uploadMediator.isSortAscending());
            this.putValue("SmallIcon", UploadHeaderPopupMenu.this.uploadMediator.isSortAscending() ? UploadHeaderPopupMenu.this.downArrow : UploadHeaderPopupMenu.this.upArrow);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean direction = !UploadHeaderPopupMenu.this.uploadMediator.isSortAscending();
            this.putValue("SmallIcon", direction ? UploadHeaderPopupMenu.this.downArrow : UploadHeaderPopupMenu.this.upArrow);
            UploadHeaderPopupMenu.this.uploadMediator.setSortOrder(UploadHeaderPopupMenu.this.uploadMediator.getSortOrder(), direction);
        }
    }

    private class SortAction
    extends AbstractAction {
        private final UploadMediator.SortOrder sortOrder;

        public SortAction(String title, UploadMediator.SortOrder sortOrder) {
            super(title);
            this.sortOrder = sortOrder;
            this.putValue("SwingSelectedKey", sortOrder == UploadHeaderPopupMenu.this.uploadMediator.getSortOrder());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UploadHeaderPopupMenu.this.uploadMediator.setSortOrder(this.sortOrder, UploadHeaderPopupMenu.this.uploadMediator.isSortAscending());
        }
    }
}

