/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.painter.factories;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Insets;
import org.jdesktop.application.Resource;
import org.jdesktop.swingx.painter.CompoundPainter;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.painter.RectanglePainter;
import org.limewire.ui.swing.painter.BorderPainter;
import org.limewire.ui.swing.painter.ComponentBackgroundPainter;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.PainterUtils;

@Singleton
public class MessagePainterFactory {
    @Resource
    private int arcWidth;
    @Resource
    private int arcHeight;
    private final GreenMessagePainterResources greenResources = new GreenMessagePainterResources();
    private final GrayMessagePainterResources grayResources = new GrayMessagePainterResources();

    @Inject
    public MessagePainterFactory() {
        GuiUtils.assignResources(this);
    }

    public Painter createGrayMessagePainter() {
        return this.createPainter(this.grayResources.backgroundGradientTop, this.grayResources.backgroundGradientBottom, this.grayResources.border, this.grayResources.bevelTop1, this.grayResources.bevelTop2, this.grayResources.bevelLeft, this.grayResources.bevelRightGradientTop, this.grayResources.bevelRightGradientBottom, this.grayResources.bevelBottom);
    }

    public Painter createGreenMessagePainter() {
        return this.createPainter(this.greenResources.backgroundGradientTop, this.greenResources.backgroundGradientBottom, this.greenResources.border, this.greenResources.bevelTop1, this.greenResources.bevelTop2, this.greenResources.bevelLeft, this.greenResources.bevelRightGradientTop, this.greenResources.bevelRightGradientBottom, this.greenResources.bevelBottom);
    }

    public Painter createGreenRectanglePainter() {
        return this.createRectanglePainter(this.grayResources.backgroundGradientTop, this.grayResources.backgroundGradientBottom, this.grayResources.border, this.grayResources.bevelTop1, this.grayResources.bevelTop2, this.grayResources.bevelLeft, this.grayResources.bevelRightGradientTop, this.grayResources.bevelRightGradientBottom, this.grayResources.bevelBottom);
    }

    private Painter createPainter(Color backgroundGradientTop, Color backgroundGradientBottom, Color border, Color bevelTop1, Color bevelTop2, Color bevelLeft, Color bevelRightGradientTop, Color bevelRightGradientBottom, Color bevelBottom) {
        GradientPaint background = new GradientPaint(0.0f, 0.0f, backgroundGradientTop, 0.0f, 1.0f, backgroundGradientBottom);
        GradientPaint bevelRight = new GradientPaint(0.0f, 0.0f, bevelRightGradientTop, 0.0f, 1.0f, bevelRightGradientBottom);
        return new ComponentBackgroundPainter(background, border, bevelLeft, bevelTop1, bevelTop2, bevelRight, bevelBottom, this.arcWidth, this.arcHeight, BorderPainter.AccentType.NONE);
    }

    private Painter createRectanglePainter(Color backgroundGradientTop, Color backgroundGradientBottom, Color border, Color bevelTop1, Color bevelTop2, Color bevelLeft, Color bevelRightGradientTop, Color bevelRightGradientBottom, Color bevelBottom) {
        GradientPaint background = new GradientPaint(0.0f, 0.0f, backgroundGradientTop, 0.0f, 1.0f, backgroundGradientBottom);
        GradientPaint bevelRight = new GradientPaint(0.0f, 0.0f, bevelRightGradientTop, 0.0f, 1.0f, bevelRightGradientBottom);
        RectanglePainter backgroundPainter = new RectanglePainter();
        backgroundPainter.setRounded(true);
        backgroundPainter.setFillPaint(background);
        backgroundPainter.setRoundWidth(0);
        backgroundPainter.setRoundHeight(0);
        backgroundPainter.setInsets(new Insets(2, 2, 2, 2));
        backgroundPainter.setBorderPaint(null);
        backgroundPainter.setPaintStretched(true);
        backgroundPainter.setFillVertical(true);
        backgroundPainter.setFillHorizontal(true);
        backgroundPainter.setAntialiasing(true);
        backgroundPainter.setCacheable(true);
        BorderPainter borderPainter = new BorderPainter(0, 0, border, bevelLeft, bevelTop1, bevelTop2, bevelRight, bevelBottom, BorderPainter.AccentType.SHADOW);
        borderPainter.setInsets(new Insets(0, -1, 0, 0));
        CompoundPainter painter = new CompoundPainter();
        painter.setPainters(backgroundPainter, borderPainter);
        painter.setCacheable(true);
        return painter;
    }

    private static class GrayMessagePainterResources {
        @Resource
        protected Color backgroundGradientTop = PainterUtils.TRASPARENT;
        @Resource
        protected Color backgroundGradientBottom = PainterUtils.TRASPARENT;
        @Resource
        protected Color border = PainterUtils.TRASPARENT;
        @Resource
        protected Color bevelTop1 = PainterUtils.TRASPARENT;
        @Resource
        protected Color bevelTop2 = PainterUtils.TRASPARENT;
        @Resource
        protected Color bevelLeft = PainterUtils.TRASPARENT;
        @Resource
        protected Color bevelRightGradientTop = PainterUtils.TRASPARENT;
        @Resource
        protected Color bevelRightGradientBottom = PainterUtils.TRASPARENT;
        @Resource
        protected Color bevelBottom = PainterUtils.TRASPARENT;

        public GrayMessagePainterResources() {
            GuiUtils.assignResources(this);
        }
    }

    private static class GreenMessagePainterResources {
        @Resource
        protected Color backgroundGradientTop = PainterUtils.TRASPARENT;
        @Resource
        protected Color backgroundGradientBottom = PainterUtils.TRASPARENT;
        @Resource
        protected Color border = PainterUtils.TRASPARENT;
        @Resource
        protected Color bevelTop1 = PainterUtils.TRASPARENT;
        @Resource
        protected Color bevelTop2 = PainterUtils.TRASPARENT;
        @Resource
        protected Color bevelLeft = PainterUtils.TRASPARENT;
        @Resource
        protected Color bevelRightGradientTop = PainterUtils.TRASPARENT;
        @Resource
        protected Color bevelRightGradientBottom = PainterUtils.TRASPARENT;
        @Resource
        protected Color bevelBottom = PainterUtils.TRASPARENT;

        public GreenMessagePainterResources() {
            GuiUtils.assignResources(this);
        }
    }
}

