/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.options;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.jdesktop.swingx.JXPanel;
import org.limewire.core.api.Application;
import org.limewire.ui.swing.components.FocusJOptionPane;
import org.limewire.ui.swing.components.LimeJDialog;
import org.limewire.ui.swing.options.AdvancedOptionPanel;
import org.limewire.ui.swing.options.FancyOptionTabButton;
import org.limewire.ui.swing.options.LibraryOptionPanel;
import org.limewire.ui.swing.options.MiscOptionPanel;
import org.limewire.ui.swing.options.OptionPanel;
import org.limewire.ui.swing.options.OptionTabItem;
import org.limewire.ui.swing.options.OptionsTabNavigator;
import org.limewire.ui.swing.options.SearchOptionPanel;
import org.limewire.ui.swing.options.TabItemListener;
import org.limewire.ui.swing.options.TransferOptionPanel;
import org.limewire.ui.swing.options.UnsafeTypeOptionPanelStateManager;
import org.limewire.ui.swing.options.actions.ApplyOptionAction;
import org.limewire.ui.swing.options.actions.CancelOptionAction;
import org.limewire.ui.swing.options.actions.HelpAction;
import org.limewire.ui.swing.options.actions.TabAction;
import org.limewire.ui.swing.painter.factories.BarPainterFactory;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.util.OSUtils;

public class OptionsDialog
extends LimeJDialog
implements OptionsTabNavigator {
    @Resource
    private Icon advancedIcon;
    @Resource
    private Icon transfersIcon;
    @Resource
    private Icon libraryIcon;
    @Resource
    private Icon miscIcon;
    @Resource
    private Icon searchIcon;
    public static final String LIBRARY = I18n.tr("My Files");
    public static final String SEARCH = I18n.tr("Search");
    public static final String TRANSFERS = I18n.tr("Transfers");
    public static final String SECURITY = I18n.tr("Security");
    public static final String MISC = I18n.tr("Misc");
    public static final String ADVANCED = I18n.tr("Advanced");
    private final Provider<LibraryOptionPanel> libraryOptionPanel;
    private final Provider<SearchOptionPanel> searchOptionPanel;
    private final Provider<TransferOptionPanel> transferOptionPanel;
    private final Provider<MiscOptionPanel> miscOptionPanel;
    private final Provider<AdvancedOptionPanel> advancedOptionPanel;
    private final UnsafeTypeOptionPanelStateManager unsafeTypeOptionPanelStateManager;
    private final Application application;
    private final Map<String, OptionTabItem> cards = new HashMap<String, OptionTabItem>();
    private final Map<String, OptionPanel> panels = new HashMap<String, OptionPanel>();
    private final List<String> list = new ArrayList<String>();
    private OptionTabItem selectedItem;
    private JPanel cardPanel;
    private CardLayout cardLayout;
    private JXPanel headerPanel;
    private JPanel footerPanel;
    private JButton helpButton;
    private JButton okButton;
    private JButton cancelButton;

    @Inject
    public OptionsDialog(Provider<LibraryOptionPanel> libraryOptionPanel, Provider<SearchOptionPanel> searchOptionPanel, Provider<TransferOptionPanel> transferOptionPanel, Provider<MiscOptionPanel> miscOptionPanel, Provider<AdvancedOptionPanel> advancedOptionPanel, BarPainterFactory barPainterFactory, UnsafeTypeOptionPanelStateManager unsafeTypeOptionPanelStateManager, Application application) {
        super(GuiUtils.getMainFrame(), OSUtils.isMacOSX() ? I18n.tr("Preferences") : I18n.tr("Options"), true);
        GuiUtils.assignResources(this);
        this.application = application;
        this.libraryOptionPanel = libraryOptionPanel;
        this.searchOptionPanel = searchOptionPanel;
        this.transferOptionPanel = transferOptionPanel;
        this.miscOptionPanel = miscOptionPanel;
        this.advancedOptionPanel = advancedOptionPanel;
        this.unsafeTypeOptionPanelStateManager = unsafeTypeOptionPanelStateManager;
        if (!OSUtils.isMacOSX()) {
            this.setSize(725, 556);
            this.setPreferredSize(this.getSize());
        } else {
            this.setSize(835, 607);
            this.setPreferredSize(this.getSize());
        }
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        this.createComponents(barPainterFactory);
        this.pack();
    }

    public void applyOptions() {
        boolean restartRequired = false;
        for (OptionPanel panel : this.panels.values()) {
            restartRequired |= panel.applyOptions();
        }
        if (restartRequired) {
            FocusJOptionPane.showMessageDialog(this, I18n.tr("One or more options will take effect the next time LimeWire is restarted."), I18n.tr("Message"), 1);
        }
    }

    private void createComponents(BarPainterFactory barPainterFactory) {
        this.setLayout(new BorderLayout());
        this.cardLayout = new CardLayout();
        this.cardPanel = new JPanel();
        this.cardPanel.setLayout(this.cardLayout);
        this.headerPanel = new JXPanel();
        this.headerPanel.setBackgroundPainter(barPainterFactory.createTopBarPainter());
        this.footerPanel = new JPanel();
        this.footerPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 8, 0));
        this.createFooter();
        this.createHeader();
        this.select(LIBRARY);
        this.add((Component)this.headerPanel, "North");
        this.add((Component)this.cardPanel, "Center");
        this.add((Component)this.footerPanel, "South");
    }

    private void createHeader() {
        this.headerPanel.setLayout(new MigLayout("insets 0 0 0 0, gap 0"));
        MoveDown down = new MoveDown();
        MoveUp up = new MoveUp();
        this.createButton(LIBRARY, this.libraryIcon, this.libraryOptionPanel, down, up);
        this.createButton(SEARCH, this.searchIcon, this.searchOptionPanel, down, up);
        this.createButton(TRANSFERS, this.transfersIcon, this.transferOptionPanel, down, up);
        this.createButton(MISC, this.miscIcon, this.miscOptionPanel, down, up);
        this.createButton(ADVANCED, this.advancedIcon, this.advancedOptionPanel, down, up);
    }

    private void createButton(String title, Icon icon, Provider<? extends OptionPanel> provider, MoveDown down, MoveUp up) {
        FancyOptionTabButton button = new FancyOptionTabButton(new TabAction(icon, this.addOptionTab(title, this, provider)));
        button.getActionMap().put("MOVE_DOWN", down);
        button.getInputMap(0).put(KeyStroke.getKeyStroke(40, 0), "MOVE_DOWN");
        button.getInputMap(0).put(KeyStroke.getKeyStroke(39, 0), "MOVE_DOWN");
        button.getActionMap().put("MOVE_UP", up);
        button.getInputMap(0).put(KeyStroke.getKeyStroke(38, 0), "MOVE_UP");
        button.getInputMap(0).put(KeyStroke.getKeyStroke(37, 0), "MOVE_UP");
        this.headerPanel.add(button);
    }

    private void createFooter() {
        this.footerPanel.setLayout(new MigLayout("insets 0 15 0 15, aligny 50%"));
        this.footerPanel.setBackground(GuiUtils.getMainFrame().getBackground());
        this.helpButton = new JButton(new HelpAction(this.application));
        this.okButton = new JButton(I18n.tr("OK"));
        this.okButton.addActionListener(new ApplyOptionAction(this));
        this.cancelButton = new JButton(I18n.tr("Cancel"));
        this.cancelButton.addActionListener(new CancelOptionAction(this));
        this.footerPanel.add((Component)this.helpButton, "push");
        this.footerPanel.add((Component)this.okButton, "split, tag ok");
        this.footerPanel.add((Component)this.cancelButton, "tag cancel");
    }

    @Override
    public OptionTabItem addOptionTab(String title, OptionsTabNavigator navigator, Provider<? extends OptionPanel> optionProvider) {
        return new OptionsTabItemImpl(title, navigator, optionProvider);
    }

    public void next() {
        for (int i = 0; i < this.list.size(); ++i) {
            if (!this.list.get(i).equals(this.selectedItem.getId())) continue;
            if (i == this.list.size() - 1) {
                this.select(this.list.get(0));
                break;
            }
            this.select(this.list.get(i + 1));
            break;
        }
    }

    public void previous() {
        for (int i = 0; i < this.list.size(); ++i) {
            if (!this.list.get(i).equals(this.selectedItem.getId())) continue;
            if (i == 0) {
                this.select(this.list.get(this.list.size() - 1));
                break;
            }
            this.select(this.list.get(i - 1));
            break;
        }
    }

    @Override
    public void select(String title) {
        if (this.selectedItem != null) {
            ((OptionsTabItemImpl)this.selectedItem).fireSelected(false);
        }
        this.selectedItem = this.cards.get(title);
        if (!this.panels.containsKey(title)) {
            this.createPanel(this.selectedItem.getId(), this.selectedItem.getOptionPanel());
        }
        ((OptionsTabItemImpl)this.selectedItem).fireSelected(true);
        this.cardLayout.show(this.cardPanel, title);
    }

    private void createPanel(String id, OptionPanel panel) {
        panel.setBackground(GuiUtils.getMainFrame().getBackground());
        this.panels.put(this.selectedItem.getId(), panel);
        this.cardPanel.add((Component)this.panels.get(this.selectedItem.getId()), this.selectedItem.getId());
        if (!this.selectedItem.getId().equals(LIBRARY)) {
            panel.initOptions();
        }
    }

    public void initOptions() {
        this.unsafeTypeOptionPanelStateManager.initOptions();
        for (OptionPanel optionPanel : this.panels.values()) {
            optionPanel.initOptions();
        }
    }

    private class OptionsTabItemImpl
    implements OptionTabItem {
        private final List<TabItemListener> listeners = new CopyOnWriteArrayList<TabItemListener>();
        private final String name;
        private final OptionsTabNavigator navigator;
        private final Provider<? extends OptionPanel> provider;

        public OptionsTabItemImpl(String title, OptionsTabNavigator navigator, Provider<? extends OptionPanel> optionProvider) {
            this.name = title;
            this.navigator = navigator;
            this.provider = optionProvider;
            OptionsDialog.this.cards.put(title, this);
            OptionsDialog.this.list.add(title);
        }

        @Override
        public String getId() {
            return this.name;
        }

        @Override
        public boolean isSelected() {
            return false;
        }

        @Override
        public void select() {
            this.navigator.select(this.name);
        }

        @Override
        public OptionPanel getOptionPanel() {
            return this.provider.get();
        }

        @Override
        public void addTabItemListener(TabItemListener listener) {
            this.listeners.add(listener);
        }

        @Override
        public void removeTabItemListener(TabItemListener listener) {
            this.listeners.remove(listener);
        }

        public void fireSelected(boolean selected) {
            for (TabItemListener listener : this.listeners) {
                listener.itemSelected(selected);
            }
        }
    }

    private class MoveUp
    extends AbstractAction {
        static final String KEY = "MOVE_UP";

        private MoveUp() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            OptionsDialog.this.previous();
        }
    }

    private class MoveDown
    extends AbstractAction {
        static final String KEY = "MOVE_DOWN";

        private MoveDown() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            OptionsDialog.this.next();
        }
    }
}

