/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.menu;

import com.google.inject.Inject;
import java.awt.Color;
import javax.swing.JMenuBar;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.jdesktop.application.Resource;
import org.limewire.ui.swing.action.MnemonicMenu;
import org.limewire.ui.swing.menu.FileMenu;
import org.limewire.ui.swing.menu.FriendsMenu;
import org.limewire.ui.swing.menu.HelpMenu;
import org.limewire.ui.swing.menu.ToolsMenu;
import org.limewire.ui.swing.menu.ViewMenu;
import org.limewire.ui.swing.util.GuiUtils;

public class LimeMenuBar
extends JMenuBar {
    @Resource
    private Color backgroundColor;

    @Inject
    LimeMenuBar(FileMenu fileMenu, FriendsMenu friendMenu, ViewMenu viewMenu, HelpMenu helpMenu, ToolsMenu toolsMenu) {
        GuiUtils.assignResources(this);
        this.setBackground(this.backgroundColor);
        fileMenu.setBackground(this.backgroundColor);
        viewMenu.setBackground(this.backgroundColor);
        friendMenu.setBackground(this.backgroundColor);
        toolsMenu.setBackground(this.backgroundColor);
        helpMenu.setBackground(this.backgroundColor);
        this.add(fileMenu);
        this.add(viewMenu);
        this.add(friendMenu);
        this.add(toolsMenu);
        this.add(helpMenu);
        MenuListener listener = new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent e) {
                ((MnemonicMenu)e.getSource()).removeAll();
            }

            @Override
            public void menuDeselected(MenuEvent e) {
                ((MnemonicMenu)e.getSource()).removeAll();
            }

            @Override
            public void menuSelected(MenuEvent e) {
                ((MnemonicMenu)e.getSource()).createMenuItems();
            }
        };
        fileMenu.addMenuListener(listener);
        viewMenu.addMenuListener(listener);
        friendMenu.addMenuListener(listener);
        toolsMenu.addMenuListener(listener);
        helpMenu.addMenuListener(listener);
    }
}

