/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.filter;

import ca.odell.glazedlists.CollectionList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FunctionList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.UniqueList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.matchers.Matcher;
import ca.odell.glazedlists.swing.DefaultEventListModel;
import ca.odell.glazedlists.swing.DefaultEventSelectionModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXList;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.limewire.collection.glazedlists.GlazedListsFactory;
import org.limewire.friend.api.Friend;
import org.limewire.ui.swing.components.HyperlinkButton;
import org.limewire.ui.swing.components.RolloverCursorListener;
import org.limewire.ui.swing.filter.AbstractFilter;
import org.limewire.ui.swing.filter.FilterPopupPanel;
import org.limewire.ui.swing.filter.FilterableItem;
import org.limewire.ui.swing.filter.SourceItem;
import org.limewire.ui.swing.filter.SourceMatcher;
import org.limewire.ui.swing.filter.UniqueListFactory;
import org.limewire.ui.swing.util.I18n;
import org.limewire.util.Objects;

class SourceFilter<E extends FilterableItem>
extends AbstractFilter<E> {
    private final JPanel panel = new JPanel();
    private final JLabel label = new JLabel();
    private final JXList list = new JXList();
    private final HyperlinkButton moreButton = new HyperlinkButton();
    private final List<FriendListener> friendListenerList = new ArrayList<FriendListener>();
    private EventList<SourceItem> sourceList;
    private UniqueListFactory<SourceItem> uniqueSourceListFactory;
    private UniqueList<SourceItem> uniqueSourceList;
    private EventList<SourceItem> friendList;
    private UniqueListFactory<SourceItem> uniqueFriendListFactory;
    private UniqueList<SourceItem> uniqueFriendList;
    private UniqueList<SourceItem> currentUniqueList;
    private SortedList<SourceItem> sortedList;
    private DefaultEventListModel<SourceItem> listModel;
    private DefaultEventSelectionModel<SourceItem> selectionModel;
    private DefaultEventSelectionModel<SourceItem> popupSelectionModel;
    private SelectionListener selectionListener;
    private FilterPopupPanel filterPopupPanel;
    private boolean anyFriendFound;

    public SourceFilter(EventList<E> resultsList) {
        AbstractFilter.FilterResources resources = this.getResources();
        this.panel.setLayout(new MigLayout("insets 0 0 0 0, gap 0!", "[left,grow]", ""));
        this.panel.setOpaque(false);
        this.label.setFont(resources.getHeaderFont());
        this.label.setForeground(resources.getHeaderColor());
        this.label.setText(I18n.tr("From"));
        this.list.setCellRenderer((ListCellRenderer)new SourceCellRenderer(resources.getBackground(), BorderFactory.createEmptyBorder(1, 7, 0, 7), false));
        this.list.setFont(resources.getRowFont());
        this.list.setForeground(resources.getRowColor());
        this.list.setOpaque(false);
        this.list.setRolloverEnabled(true);
        this.list.setSelectionMode(0);
        this.list.setHighlighters(new ColorHighlighter(HighlightPredicate.ROLLOVER_ROW, resources.getHighlightBackground(), resources.getHighlightForeground()));
        new RolloverCursorListener().install(this.list);
        this.moreButton.setAction(new MoreAction());
        this.moreButton.setBorder(BorderFactory.createEmptyBorder(0, 1, 1, 1));
        this.moreButton.setContentAreaFilled(false);
        this.moreButton.setFocusPainted(false);
        this.moreButton.setFont(resources.getRowFont());
        this.moreButton.setHorizontalTextPosition(10);
        this.moreButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (SourceFilter.this.filterPopupPanel != null) {
                    SourceFilter.this.filterPopupPanel.setPopupTriggered(true);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (SourceFilter.this.filterPopupPanel != null) {
                    SourceFilter.this.filterPopupPanel.setPopupTriggered(false);
                }
            }
        });
        this.initialize(resultsList);
        this.list.setPrototypeCellValue("Type");
        int listHeight = 3 * this.list.getFixedCellHeight();
        this.panel.add((Component)this.label, "gap 6 6, wrap");
        this.panel.add((Component)this.list, "hmax " + listHeight + ", grow, wrap");
        this.panel.add((Component)this.moreButton, "gap 6 6");
    }

    private void initialize(EventList<E> resultsList) {
        this.sourceList = this.createSourceList(resultsList);
        this.uniqueSourceListFactory = new UniqueListFactory<SourceItem>(this.sourceList, new SourceItemComparator());
        this.uniqueSourceListFactory.setName(I18n.tr("Sources"));
        this.uniqueSourceList = this.uniqueSourceListFactory.getUniqueList();
        this.friendList = this.createFriendList(resultsList);
        this.uniqueFriendListFactory = new UniqueListFactory<SourceItem>(this.friendList, new SourceItemComparator());
        this.uniqueFriendListFactory.setName(I18n.tr("Friends"));
        this.uniqueFriendList = this.uniqueFriendListFactory.getUniqueList();
        this.uniqueSourceList.addListEventListener(new ListEventListener<SourceItem>(){

            @Override
            public void listChanged(ListEvent<SourceItem> listChanges) {
                SourceFilter.this.updateAnonymousFound();
                SourceFilter.this.updateAnyFriendFound();
                SourceFilter.this.updateMoreVisibility();
            }
        });
        this.uniqueFriendList.addListEventListener(new ListEventListener<SourceItem>(){

            @Override
            public void listChanged(ListEvent<SourceItem> listChanges) {
                SourceFilter.this.updateMoreVisibility();
            }
        });
        this.currentUniqueList = this.uniqueFriendList;
        this.updateMoreVisibility();
        this.updateFilterList();
    }

    private void updateFilterList() {
        if (this.selectionListener != null) {
            this.list.removeListSelectionListener(this.selectionListener);
        }
        if (this.listModel != null) {
            this.listModel.dispose();
        }
        if (this.selectionModel != null) {
            this.selectionModel.dispose();
        }
        if (this.sortedList != null) {
            this.sortedList.dispose();
        }
        this.sortedList = GlazedListsFactory.sortedList(this.currentUniqueList, new SourceItemCountComparator());
        this.listModel = new DefaultEventListModel<SourceItem>(this.sortedList);
        this.selectionModel = new DefaultEventSelectionModel<SourceItem>(this.sortedList);
        this.list.setSelectionModel(this.selectionModel);
        this.list.setModel(this.listModel);
        this.selectionListener = new SelectionListener(this.selectionModel);
        this.list.addListSelectionListener(this.selectionListener);
    }

    public void addFriendListener(FriendListener listener) {
        this.friendListenerList.add(listener);
    }

    public void removeFriendListener(FriendListener listener) {
        this.friendListenerList.remove(listener);
    }

    @Override
    public JComponent getComponent() {
        return this.panel;
    }

    @Override
    public void reset() {
        if (this.selectionModel != null) {
            this.selectionModel.clearSelection();
        }
        if (this.popupSelectionModel != null) {
            this.popupSelectionModel.clearSelection();
        }
        this.deactivate();
    }

    @Override
    public void dispose() {
        this.uniqueSourceListFactory.dispose();
        this.uniqueFriendListFactory.dispose();
        ((TransformedList)this.sourceList).dispose();
        ((TransformedList)this.friendList).dispose();
    }

    @Override
    protected void activate(String activeText, Matcher<E> matcher) {
        super.activate(activeText, matcher);
        this.getComponent().setVisible(false);
    }

    @Override
    protected void deactivate() {
        super.deactivate();
        this.getComponent().setVisible(this.anyFriendFound);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName()).append("[");
        buf.append("uniqueItems=").append(this.currentUniqueList.size());
        buf.append(", active=").append(this.isActive());
        EventList<SourceItem> selectedList = this.selectionModel.getSelected();
        buf.append(", selection=").append(selectedList.size() > 0 ? selectedList.get(0) : "null");
        buf.append("]");
        return buf.toString();
    }

    private EventList<SourceItem> createSourceList(EventList<E> resultsList) {
        CollectionList.Model model = new CollectionList.Model<E, SourceItem>(){

            @Override
            public List<SourceItem> getChildren(E parent) {
                ArrayList<SourceItem> list = new ArrayList<SourceItem>();
                if (parent.isAnonymous()) {
                    list.add(SourceItem.ANONYMOUS_SOURCE);
                }
                if (parent.getFriends().size() > 0) {
                    list.add(SourceItem.ANY_FRIEND_SOURCE);
                }
                return list;
            }
        };
        return GlazedListsFactory.collectionList(resultsList, model);
    }

    private EventList<SourceItem> createFriendList(EventList<E> resultsList) {
        CollectionList.Model model = new CollectionList.Model<E, Friend>(){

            @Override
            public List<Friend> getChildren(E parent) {
                Collection<Friend> friends = parent.getFriends();
                return new ArrayList<Friend>(friends);
            }
        };
        CollectionList collectionList = GlazedListsFactory.collectionList(resultsList, model);
        return GlazedListsFactory.simpleFunctionList(collectionList, new SourceItemFriendFunction());
    }

    private void updateAnonymousFound() {
        UniqueList<SourceItem> newList;
        boolean found = this.uniqueSourceList.contains(SourceItem.ANONYMOUS_SOURCE);
        UniqueList<SourceItem> uniqueList = newList = found ? this.uniqueSourceList : this.uniqueFriendList;
        if (this.currentUniqueList == newList) {
            return;
        }
        this.currentUniqueList = newList;
        this.moreButton.getAction().putValue("Name", found ? I18n.tr("friends") : I18n.tr("more"));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SourceFilter.this.updateFilterList();
            }
        });
    }

    private void updateAnyFriendFound() {
        boolean found = this.uniqueSourceList.contains(SourceItem.ANY_FRIEND_SOURCE);
        if (this.anyFriendFound == found) {
            return;
        }
        this.anyFriendFound = found;
        int size = this.friendListenerList.size();
        for (int i = 0; i < size; ++i) {
            this.friendListenerList.get(i).friendFound(found);
        }
    }

    private void updateMoreVisibility() {
        boolean visible;
        boolean bl = visible = this.currentUniqueList == this.uniqueSourceList || this.uniqueFriendList.size() > 3;
        if (!this.moreButton.isVisible() && visible) {
            this.moreButton.setVisible(true);
        } else if (this.moreButton.isVisible() && !visible) {
            this.moreButton.setVisible(false);
        }
    }

    private FilterPopupPanel createFriendPopup() {
        FilterPopupPanel popupPanel = new FilterPopupPanel(this.getResources(), I18n.tr("Friends"));
        popupPanel.setListCellRenderer(new SourceCellRenderer(popupPanel.getBackground(), BorderFactory.createEmptyBorder(1, 4, 0, 1), true));
        DefaultEventListModel<SourceItem> listModel = new DefaultEventListModel<SourceItem>(this.uniqueFriendList);
        this.popupSelectionModel = new DefaultEventSelectionModel<SourceItem>(this.uniqueFriendList);
        popupPanel.setListModel(listModel);
        popupPanel.setListSelectionModel(this.popupSelectionModel);
        this.popupSelectionModel.addListSelectionListener(new SelectionListener(this.popupSelectionModel));
        return popupPanel;
    }

    private void showFriendPopup() {
        if (this.filterPopupPanel == null) {
            this.filterPopupPanel = this.createFriendPopup();
        }
        this.filterPopupPanel.showPopup(this.moreButton, this.list.getWidth() - 12, this.label.getY() - this.moreButton.getY());
    }

    private void hideFriendPopup() {
        if (this.filterPopupPanel != null) {
            this.filterPopupPanel.hidePopup();
        }
    }

    public static interface FriendListener {
        public void friendFound(boolean var1);
    }

    private static class SourceItemFriendFunction
    implements FunctionList.Function<Friend, SourceItem> {
        private SourceItemFriendFunction() {
        }

        @Override
        public SourceItem evaluate(Friend sourceValue) {
            return new SourceItem(SourceItem.Type.FRIEND, sourceValue.getRenderName());
        }
    }

    private class SourceItemCountComparator
    implements Comparator<SourceItem> {
        private SourceItemCountComparator() {
        }

        @Override
        public int compare(SourceItem item1, SourceItem item2) {
            int count2;
            int count1 = SourceFilter.this.currentUniqueList.getCount(item1);
            return count1 < (count2 = SourceFilter.this.currentUniqueList.getCount(item2)) ? 1 : (count1 > count2 ? -1 : 0);
        }
    }

    private static class SourceItemComparator
    implements Comparator<SourceItem> {
        private SourceItemComparator() {
        }

        @Override
        public int compare(SourceItem item1, SourceItem item2) {
            if (item1.getType() == item2.getType()) {
                String name1 = item1.getName();
                String name2 = item2.getName();
                return Objects.compareToNullIgnoreCase(name1, name2, false);
            }
            if (item1.getType() == SourceItem.Type.ANONYMOUS) {
                return 1;
            }
            if (item2.getType() == SourceItem.Type.ANONYMOUS) {
                return -1;
            }
            if (item1.getType() == SourceItem.Type.ANY_FRIEND) {
                return 1;
            }
            return -1;
        }
    }

    private class SourceCellRenderer
    extends DefaultListCellRenderer {
        private final Color background;
        private final Border border;
        private final boolean useFriend;

        public SourceCellRenderer(Color background, Border border, boolean useFriend) {
            this.background = background;
            this.border = border;
            this.useFriend = useFriend;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component renderer = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (renderer instanceof JLabel && value instanceof SourceItem) {
                int count = this.useFriend ? SourceFilter.this.uniqueFriendList.getCount((SourceItem)value) : SourceFilter.this.currentUniqueList.getCount((SourceItem)value);
                StringBuilder buf = new StringBuilder();
                buf.append(((SourceItem)value).getName());
                buf.append(" (").append(count).append(")");
                ((JLabel)renderer).setText(buf.toString());
                ((JLabel)renderer).setBackground(this.background);
                ((JLabel)renderer).setBorder(this.border);
            }
            return renderer;
        }
    }

    private class SelectionListener
    implements ListSelectionListener {
        private final DefaultEventSelectionModel<SourceItem> selectionModel;

        public SelectionListener(DefaultEventSelectionModel<SourceItem> selectionModel) {
            this.selectionModel = selectionModel;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (SourceFilter.this.isActive()) {
                return;
            }
            EventList<SourceItem> selectedList = this.selectionModel.getSelected();
            if (selectedList.size() > 0) {
                SourceItem value = (SourceItem)selectedList.get(0);
                SourceMatcher newMatcher = new SourceMatcher(value);
                SourceFilter.this.activate(value.toString(), newMatcher);
            } else {
                SourceFilter.this.deactivate();
            }
            SourceFilter.this.hideFriendPopup();
            SourceFilter.this.fireFilterChanged(SourceFilter.this);
        }
    }

    private class MoreAction
    extends AbstractAction {
        public MoreAction() {
            super(I18n.tr("more"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SourceFilter.this.filterPopupPanel == null) {
                SourceFilter.this.showFriendPopup();
            } else if (SourceFilter.this.filterPopupPanel.isPopupReady()) {
                SourceFilter.this.showFriendPopup();
            } else {
                SourceFilter.this.filterPopupPanel.setPopupReady(true);
            }
        }
    }
}

