/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.advanced.connection;

import ca.odell.glazedlists.impl.swing.SwingThreadProxyEventList;
import ca.odell.glazedlists.swing.DefaultEventTableModel;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.inject.Inject;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import org.limewire.collection.glazedlists.GlazedListsFactory;
import org.limewire.core.api.connection.ConnectionItem;
import org.limewire.core.api.connection.GnutellaConnectionManager;
import org.limewire.friend.api.FriendPresence;
import org.limewire.ui.swing.advanced.connection.ConnectionTable;
import org.limewire.ui.swing.advanced.connection.ConnectionTableFormat;
import org.limewire.ui.swing.components.Disposable;
import org.limewire.ui.swing.components.FocusJOptionPane;
import org.limewire.ui.swing.search.FriendPresenceActions;
import org.limewire.ui.swing.table.TableDoubleClickHandler;
import org.limewire.ui.swing.table.TablePopupHandler;
import org.limewire.ui.swing.util.I18n;

public class ConnectionDetailPanel
extends JPanel
implements Disposable {
    private GnutellaConnectionManager gnutellaConnectionManager;
    private Action removeConnectionAction = new RemoveConnectionAction(I18n.tr("Remove"));
    private Action viewLibraryAction = new ViewLibraryAction(I18n.tr("Browse Files"));
    private JScrollPane scrollPane = new JScrollPane();
    private ConnectionTable connectionTable = new ConnectionTable();
    private JPopupMenu popupMenu = new JPopupMenu();
    private final FriendPresenceActions remoteHostActions;

    @Inject
    public ConnectionDetailPanel(GnutellaConnectionManager gnutellaConnectionManager, FriendPresenceActions remoteHostActions) {
        this.gnutellaConnectionManager = gnutellaConnectionManager;
        this.remoteHostActions = remoteHostActions;
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.scrollPane.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        this.scrollPane.setPreferredSize(new Dimension(120, 120));
        this.connectionTable.setPopupHandler(new TablePopupHandler(){

            @Override
            public boolean isPopupShowing(int row) {
                return false;
            }

            @Override
            public void maybeShowPopup(Component component, int x, int y) {
                ConnectionItem[] items;
                int row = ConnectionDetailPanel.this.connectionTable.rowAtPoint(new Point(x, y));
                if (row >= 0 && !ConnectionDetailPanel.this.connectionTable.isRowSelected(row)) {
                    ConnectionDetailPanel.this.connectionTable.setRowSelectionInterval(row, row);
                }
                if ((items = ConnectionDetailPanel.this.connectionTable.getSelectedConnections()).length > 0) {
                    ConnectionDetailPanel.this.viewLibraryAction.setEnabled(items[0].isConnected());
                }
                ConnectionDetailPanel.this.popupMenu.show(component, x, y);
            }
        });
        this.connectionTable.setDoubleClickHandler(new TableDoubleClickHandler(){

            @Override
            public void handleDoubleClick(int row) {
                if (row >= 0) {
                    ConnectionDetailPanel.this.connectionTable.setRowSelectionInterval(row, row);
                }
                ConnectionDetailPanel.this.viewLibrary();
            }
        });
        JMenuItem menuItem = new JMenuItem(this.viewLibraryAction);
        this.popupMenu.add(menuItem);
        this.popupMenu.addSeparator();
        menuItem = new JMenuItem(this.removeConnectionAction);
        this.popupMenu.add(menuItem);
        this.add((Component)this.scrollPane, "Center");
        this.scrollPane.setViewportView(this.connectionTable);
    }

    public void initData() {
        if (!(this.connectionTable.getModel() instanceof DefaultEventTableModel)) {
            SwingThreadProxyEventList<ConnectionItem> connectionList = GlazedListsFactory.swingThreadProxyEventList(this.gnutellaConnectionManager.getConnectionList());
            ConnectionTableFormat connectionTableFormat = new ConnectionTableFormat();
            this.connectionTable.setEventList(connectionList, connectionTableFormat);
        }
    }

    @Override
    public void dispose() {
        this.connectionTable.clearEventList();
    }

    public void refresh() {
        this.connectionTable.refresh();
    }

    private void viewLibrary() {
        ConnectionItem[] items = this.connectionTable.getSelectedConnections();
        this.remoteHostActions.viewLibrariesOf(Collections2.transform(Collections2.filter(Arrays.asList(items), new Predicate<ConnectionItem>(){

            @Override
            public boolean apply(ConnectionItem input) {
                return input.isConnected();
            }
        }), new Function<ConnectionItem, FriendPresence>(){

            @Override
            public FriendPresence apply(ConnectionItem from) {
                return from.getFriendPresence();
            }
        }));
        for (ConnectionItem item : items) {
            if (item.isConnected()) continue;
            FocusJOptionPane.showMessageDialog(this, I18n.tr("Unable to view files - not yet connected to host"), I18n.tr("Connections"), 1);
        }
    }

    private class ViewLibraryAction
    extends AbstractAction {
        public ViewLibraryAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ConnectionDetailPanel.this.viewLibrary();
        }
    }

    private class RemoveConnectionAction
    extends AbstractAction {
        public RemoveConnectionAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ConnectionItem[] items;
            for (ConnectionItem item : items = ConnectionDetailPanel.this.connectionTable.getSelectedConnections()) {
                ConnectionDetailPanel.this.gnutellaConnectionManager.removeConnection(item);
            }
            ConnectionDetailPanel.this.connectionTable.clearSelection();
        }
    }
}

