/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.setting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Executor;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.setting.SettingsGroup;
import org.limewire.setting.evt.SettingsGroupManagerEvent;
import org.limewire.setting.evt.SettingsGroupManagerListener;

public final class SettingsGroupManager {
    private static final SettingsGroupManager INSTANCE = new SettingsGroupManager();
    private final Collection<SettingsGroup> PROPS = Collections.synchronizedList(new ArrayList());
    private Collection<SettingsGroupManagerListener> listeners;
    private final Executor executor = ExecutorsHelper.newFixedSizeThreadPool(1, "SettingsHandlerEventDispatcher");

    public static SettingsGroupManager instance() {
        return INSTANCE;
    }

    private SettingsGroupManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSettingsHandlerListener(SettingsGroupManagerListener l) {
        if (l == null) {
            throw new NullPointerException("SettingsGroupManagerListener is null");
        }
        SettingsGroupManager settingsGroupManager = this;
        synchronized (settingsGroupManager) {
            if (this.listeners == null) {
                this.listeners = new ArrayList<SettingsGroupManagerListener>();
            }
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSettingsHandlerListener(SettingsGroupManagerListener l) {
        if (l == null) {
            throw new NullPointerException("SettingsGroupManagerListener is null");
        }
        SettingsGroupManager settingsGroupManager = this;
        synchronized (settingsGroupManager) {
            if (this.listeners != null) {
                this.listeners.remove(l);
                if (this.listeners.isEmpty()) {
                    this.listeners = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SettingsGroupManagerListener[] getSettingsHandlerListeners() {
        SettingsGroupManager settingsGroupManager = this;
        synchronized (settingsGroupManager) {
            if (this.listeners == null) {
                return null;
            }
            return this.listeners.toArray(new SettingsGroupManagerListener[this.listeners.size()]);
        }
    }

    public void addSettingsGroup(SettingsGroup group) {
        this.PROPS.add(group);
        this.fireSettingsHandlerEvent(SettingsGroupManagerEvent.EventType.SETTINGS_GROUP_ADDED, group);
    }

    public void removeSettingsGroup(SettingsGroup group) {
        if (this.PROPS.remove(group)) {
            this.fireSettingsHandlerEvent(SettingsGroupManagerEvent.EventType.SETTINGS_GROUP_REMOVED, group);
        }
    }

    public SettingsGroup[] getSettingsGroups() {
        return this.PROPS.toArray(new SettingsGroup[this.PROPS.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        Collection<SettingsGroup> collection = this.PROPS;
        synchronized (collection) {
            for (SettingsGroup group : this.PROPS) {
                group.reload();
            }
        }
        this.fireSettingsHandlerEvent(SettingsGroupManagerEvent.EventType.RELOAD, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save() {
        boolean any = false;
        Collection<SettingsGroup> collection = this.PROPS;
        synchronized (collection) {
            for (SettingsGroup group : this.PROPS) {
                any |= group.save();
            }
        }
        if (any) {
            this.fireSettingsHandlerEvent(SettingsGroupManagerEvent.EventType.SAVE, null);
        }
        return any;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean revertToDefault() {
        boolean any = false;
        Collection<SettingsGroup> collection = this.PROPS;
        synchronized (collection) {
            for (SettingsGroup group : this.PROPS) {
                any |= group.revertToDefault();
            }
        }
        if (any) {
            this.fireSettingsHandlerEvent(SettingsGroupManagerEvent.EventType.REVERT_TO_DEFAULT, null);
        }
        return any;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShouldSave(boolean shouldSave) {
        Collection<SettingsGroup> collection = this.PROPS;
        synchronized (collection) {
            for (SettingsGroup group : this.PROPS) {
                group.setShouldSave(shouldSave);
            }
        }
        this.fireSettingsHandlerEvent(SettingsGroupManagerEvent.EventType.SHOULD_SAVE, null);
    }

    protected void fireSettingsHandlerEvent(SettingsGroupManagerEvent.EventType type, SettingsGroup group) {
        this.fireSettingsHandlerEvent(new SettingsGroupManagerEvent(type, this, group));
    }

    protected void fireSettingsHandlerEvent(final SettingsGroupManagerEvent evt) {
        if (evt == null) {
            throw new NullPointerException("SettingsHandlerEvent is null");
        }
        final SettingsGroupManagerListener[] listeners = this.getSettingsHandlerListeners();
        if (listeners != null) {
            Runnable command = new Runnable(){

                @Override
                public void run() {
                    for (SettingsGroupManagerListener l : listeners) {
                        l.handleGroupManagerEvent(evt);
                    }
                }
            };
            this.execute(command);
        }
    }

    protected void execute(Runnable evt) {
        this.executor.execute(evt);
    }
}

