/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.rudp;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.LongHashMap;
import org.limewire.rudp.ChunkReleaser;
import org.limewire.rudp.DataRecord;
import org.limewire.rudp.messages.DataMessage;

public class DataWindow {
    private static final Log LOG = LogFactory.getLog(DataWindow.class);
    public static final int MAX_SEQUENCE_NUMBER = 65535;
    private static final int HIST_SIZE = 4;
    private static final float RTT_GAIN = 0.125f;
    private static final float DEVIATION_GAIN = 0.25f;
    private final LongHashMap<DataRecord> window;
    private long windowStart;
    private int windowSize;
    private long averageRTT;
    private long averageLowRTT;
    private int lowRTTCount;
    private float srtt;
    private float rttvar;
    private float rto;
    private boolean readableData;

    public DataWindow(int size, long start) {
        if (size < 1) {
            throw new IllegalArgumentException("size must be > 0");
        }
        this.windowStart = start;
        this.windowSize = size;
        this.window = new LongHashMap(size + 2);
    }

    public DataRecord addData(DataMessage msg) {
        DataRecord d;
        if (this.windowStart > msg.getSequenceNumber()) {
            throw new IllegalStateException("message is not in current window: " + this.windowStart + " > " + msg.getSequenceNumber());
        }
        long seqNo = msg.getSequenceNumber();
        if (seqNo == this.windowStart) {
            this.readableData = true;
        }
        if ((d = this.window.get(seqNo)) != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("received duplicate message seq: " + msg.getSequenceNumber() + ", window start: " + this.windowStart);
            }
            return d;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("adding message seq: " + msg.getSequenceNumber() + ", window start: " + this.windowStart);
        }
        d = new DataRecord(msg);
        this.window.put(seqNo, d);
        return d;
    }

    public DataRecord getBlock(long pnum) {
        return this.window.get(pnum);
    }

    public long getWindowStart() {
        return this.windowStart;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public int getUsedSpots() {
        int count = 0;
        for (long i = this.windowStart; i < this.windowStart + (long)this.windowSize + 3L; ++i) {
            DataRecord d = this.window.get(i);
            if (d == null || d.read && i == this.windowStart) continue;
            ++count;
        }
        return count;
    }

    public int getWindowSpace() {
        return this.windowSize - this.getUsedSpots();
    }

    public int clearLowAckedBlocks(ChunkReleaser releaser) {
        DataRecord d;
        int count = 0;
        for (long i = this.windowStart; i < this.windowStart + (long)this.windowSize + 1L && (d = this.window.get(i)) != null && d.acks > 0; ++i) {
            this.window.remove(i);
            ++count;
            if (releaser == null) continue;
            releaser.releaseChunk(d.msg.getChunk());
        }
        this.windowStart += (long)count;
        return count;
    }

    public long getLowestUnsentBlock() {
        for (long i = this.windowStart; i < this.windowStart + (long)this.windowSize + 1L; ++i) {
            if (this.window.get(i) != null) continue;
            return i;
        }
        return -1L;
    }

    public int countHigherAckBlocks() {
        int count = 0;
        for (long i = this.windowStart + 1L; i < this.windowStart + (long)this.windowSize + 1L; ++i) {
            DataRecord d = this.window.get(i);
            if (d == null || d.acks <= 0) continue;
            ++count;
        }
        return count;
    }

    public boolean acksAppearToBeMissing(long time, int multiple) {
        int irto = (int)this.rto;
        DataRecord drec = this.getBlock(this.windowStart);
        return irto > 0 && drec != null && drec.acks < 1 && drec.sentTime + (long)(multiple * irto) < time;
    }

    public int getRTO() {
        return (int)this.rto;
    }

    public float getRTTVar() {
        return this.rttvar;
    }

    public float getSRTT() {
        return this.srtt;
    }

    public int lowRoundTripTime() {
        return (int)this.averageLowRTT;
    }

    public void ackBlock(long pnum) {
        DataRecord drec;
        if (LOG.isDebugEnabled()) {
            LOG.debug("entered ackBlock with # " + pnum);
        }
        if ((drec = this.getBlock(pnum)) != null) {
            ++drec.acks;
            drec.ackTime = System.currentTimeMillis();
            if (drec.acks == 1 && drec.sends == 1) {
                long rtt = drec.ackTime - drec.sentTime;
                float delta = (float)rtt - this.srtt;
                if (rtt > 0L) {
                    this.srtt = (double)this.srtt <= 0.1 ? delta : (this.srtt += 0.125f * delta);
                    this.rttvar += 0.25f * (Math.abs(delta) - this.rttvar);
                    this.rto = (float)((double)(this.srtt + 4.0f * this.rttvar) + 0.5);
                    if (this.averageRTT == 0L) {
                        this.averageRTT = rtt;
                    } else {
                        float avgRTT = (float)(this.averageRTT * 3L + rtt) / 4.0f;
                        this.averageRTT = (long)avgRTT;
                    }
                    if (this.lowRTTCount < 10 || rtt < this.averageLowRTT) {
                        if (this.averageLowRTT == 0L) {
                            this.averageLowRTT = rtt;
                        } else {
                            float lowRtt = (float)(this.averageLowRTT * 3L + rtt) / 4.0f;
                            this.averageLowRTT = (long)lowRtt;
                        }
                        ++this.lowRTTCount;
                    }
                }
            }
        }
    }

    public void pseudoAckToReceiverWindow(long wStart) {
        if (wStart <= this.windowStart) {
            return;
        }
        for (long i = this.windowStart; i < wStart; ++i) {
            DataRecord drec = this.getBlock(i);
            if (drec == null || drec.acks != 0) continue;
            ++drec.acks;
            drec.ackTime = drec.sentTime + (long)((int)this.rto);
        }
    }

    public DataRecord getOldestUnackedBlock() {
        DataRecord oldest = null;
        for (long i = this.windowStart; i < this.windowStart + (long)this.windowSize + 1L; ++i) {
            DataRecord d = this.getBlock(i);
            if (d == null || d.acks != 0 || oldest != null && d.sentTime >= oldest.sentTime) continue;
            oldest = d;
        }
        return oldest;
    }

    public boolean hasReadableData() {
        return this.readableData;
    }

    public DataRecord getReadableBlock() {
        DataRecord d;
        if (LOG.isDebugEnabled()) {
            LOG.debug("wStart " + this.windowStart + " wSize " + this.windowSize);
        }
        for (long i = this.windowStart; i < this.windowStart + (long)this.windowSize + 1L && (d = this.getBlock(i)) != null; ++i) {
            if (d.read) continue;
            return d;
        }
        return null;
    }

    public int clearEarlyReadBlocks() {
        int count = 0;
        for (long i = this.windowStart; i < this.windowStart + (long)this.windowSize + 1L; ++i) {
            DataRecord d = this.window.get(i);
            if (d != null && d.read) {
                this.window.remove(i);
                ++count;
                continue;
            }
            if (d == null) {
                this.readableData = false;
                break;
            }
            this.readableData = true;
            break;
        }
        this.windowStart += (long)count;
        return count;
    }

    public int numNotRead() {
        int count = 0;
        for (long i = this.windowStart; i < this.windowStart + (long)this.windowSize + 1L; ++i) {
            DataRecord d = this.getBlock(i);
            if (d == null || d.read) continue;
            ++count;
        }
        return count;
    }
}

