/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.limewire.io.Address;
import org.limewire.listener.ListenerSupport;
import org.limewire.net.ConnectivityChangeEvent;
import org.limewire.net.address.AddressConnector;
import org.limewire.net.address.AddressResolutionObserver;
import org.limewire.net.address.AddressResolver;
import org.limewire.nio.NBSocket;
import org.limewire.nio.NBSocketFactory;
import org.limewire.nio.NIOSocketFactory;
import org.limewire.nio.observer.ConnectObserver;
import org.limewire.nio.ssl.SSLSocketFactory;
import org.limewire.nio.ssl.TLSSocketFactory;

public interface SocketsManager
extends ListenerSupport<ConnectivityChangeEvent> {
    public Socket create(ConnectType var1) throws IOException;

    public Socket connect(NBSocket var1, InetSocketAddress var2, InetSocketAddress var3, int var4, ConnectType var5) throws IOException;

    public Socket connect(NBSocket var1, InetSocketAddress var2, InetSocketAddress var3, int var4, ConnectObserver var5, ConnectType var6) throws IOException;

    public Socket connect(InetSocketAddress var1, int var2) throws IOException;

    public Socket connect(InetSocketAddress var1, int var2, ConnectType var3) throws IOException;

    public Socket connect(InetSocketAddress var1, int var2, ConnectObserver var3) throws IOException;

    public Socket connect(InetSocketAddress var1, int var2, ConnectObserver var3, ConnectType var4) throws IOException;

    public <T extends ConnectObserver> T connect(Address var1, T var2);

    public <T extends AddressResolutionObserver> T resolve(Address var1, T var2);

    public boolean removeConnectObserver(ConnectObserver var1);

    public int getNumAllowedSockets();

    public int getNumWaitingSockets();

    public void registerConnector(AddressConnector var1);

    public void registerResolver(AddressResolver var1);

    public boolean canConnect(Address var1);

    public boolean canResolve(Address var1);

    public static enum ConnectType {
        PLAIN(new NIOSocketFactory()),
        TLS(new TLSSocketFactory()),
        SSL(new SSLSocketFactory());

        private final NBSocketFactory factory;

        private ConnectType(NBSocketFactory factory) {
            this.factory = factory;
        }

        NBSocketFactory getFactory() {
            return this.factory;
        }
    }
}

