/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.routing;

import java.net.SocketAddress;
import org.limewire.mojito.KUID;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.Vendor;
import org.limewire.mojito.routing.Version;
import org.limewire.mojito.routing.impl.LocalContact;
import org.limewire.mojito.routing.impl.RemoteContact;

public class ContactFactory {
    private ContactFactory() {
    }

    public static Contact createLocalContact(Vendor vendor, Version version, boolean firewalled) {
        return ContactFactory.createLocalContact(vendor, version, KUID.createRandomID(), 0, firewalled);
    }

    public static Contact createLocalContact(Vendor vendor, Version version, KUID nodeId, int instanceId, boolean firewalled) {
        return new LocalContact(vendor, version, nodeId, instanceId, firewalled);
    }

    public static Contact createLiveContact(SocketAddress sourceAddress, Vendor vendor, Version version, KUID nodeId, SocketAddress contactAddress, int instanceId, int flags) {
        return new RemoteContact(sourceAddress, vendor, version, nodeId, contactAddress, instanceId, flags, Contact.State.ALIVE);
    }

    public static Contact createUnknownContact(Vendor vendor, Version version, KUID nodeId, SocketAddress contactAddress) {
        return new RemoteContact(null, vendor, version, nodeId, contactAddress, 0, 0, Contact.State.UNKNOWN);
    }

    public static Contact createUnknownContact(SocketAddress sourceAddress, Vendor vendor, Version version, KUID nodeId, SocketAddress contactAddress, int instanceId, int flags) {
        return new RemoteContact(sourceAddress, vendor, version, nodeId, contactAddress, instanceId, flags, Contact.State.UNKNOWN);
    }
}

