/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.routing;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.mojito.Context;
import org.limewire.mojito.KUID;
import org.limewire.mojito.concurrent.DHTFuture;
import org.limewire.mojito.concurrent.DHTFutureAdapter;
import org.limewire.mojito.concurrent.DHTFutureListener;
import org.limewire.mojito.manager.BootstrapManager;
import org.limewire.mojito.result.FindNodeResult;
import org.limewire.mojito.result.PingResult;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.RouteTable;
import org.limewire.mojito.settings.BucketRefresherSettings;
import org.limewire.mojito.settings.KademliaSettings;

public class BucketRefresher
implements Runnable {
    private static final Log LOG = LogFactory.getLog(BucketRefresher.class);
    private final Context context;
    private final RefreshTask refreshTask = new RefreshTask();
    private ScheduledFuture future;

    public BucketRefresher(Context context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        RefreshTask refreshTask = this.refreshTask;
        synchronized (refreshTask) {
            if (this.future == null) {
                long delay;
                long initialDelay = delay = BucketRefresherSettings.BUCKET_REFRESHER_DELAY.getValue();
                if (BucketRefresherSettings.UNIFORM_BUCKET_REFRESH_DISTRIBUTION.getValue()) {
                    initialDelay = delay + (long)((double)delay * Math.random());
                }
                this.future = this.context.getDHTExecutorService().scheduleWithFixedDelay(this, initialDelay, delay, TimeUnit.MILLISECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        RefreshTask refreshTask = this.refreshTask;
        synchronized (refreshTask) {
            if (this.future != null) {
                this.future.cancel(true);
                this.future = null;
            }
            this.refreshTask.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        RefreshTask refreshTask = this.refreshTask;
        synchronized (refreshTask) {
            BootstrapManager bootstrapManager;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Random bucket refresh");
            }
            BootstrapManager bootstrapManager2 = bootstrapManager = this.context.getBootstrapManager();
            synchronized (bootstrapManager2) {
                if (!bootstrapManager.isBootstrapped()) {
                    if (!bootstrapManager.isBootstrapping()) {
                        if (LOG.isInfoEnabled()) {
                            LOG.info("Bootstrap " + this.context.getName());
                        }
                        DHTFutureAdapter<PingResult> listener = new DHTFutureAdapter<PingResult>(){

                            @Override
                            public void handleFutureSuccess(PingResult result) {
                                BucketRefresher.this.context.bootstrap(result.getContact());
                            }
                        };
                        DHTFuture<PingResult> future = this.context.findActiveContact();
                        future.addDHTFutureListener((DHTFutureListener<PingResult>)listener);
                    } else if (LOG.isInfoEnabled()) {
                        LOG.info(this.context.getName() + " is bootstrapping");
                    }
                    return;
                }
            }
            if (this.refreshTask.isDone()) {
                long pingNearest = BucketRefresherSettings.BUCKET_REFRESHER_PING_NEAREST.getValue();
                if (pingNearest > 0L) {
                    Collection<Contact> nodes = this.context.getRouteTable().select(this.context.getLocalNodeID(), KademliaSettings.REPLICATION_PARAMETER.getValue(), RouteTable.SelectMode.ALL);
                    for (Contact node : nodes) {
                        if (this.context.isLocalNode(node)) continue;
                        long timeStamp = node.getTimeStamp();
                        if (System.currentTimeMillis() - timeStamp < pingNearest) continue;
                        this.context.ping(node);
                    }
                }
                this.refreshTask.refresh();
            }
        }
    }

    private class RefreshTask
    implements DHTFutureListener<FindNodeResult> {
        private Iterator<KUID> bucketIds = null;
        private DHTFuture<FindNodeResult> future = null;

        private RefreshTask() {
        }

        public synchronized boolean isDone() {
            return this.bucketIds == null || !this.bucketIds.hasNext();
        }

        public synchronized void stop() {
            if (this.future != null) {
                this.future.cancel(true);
                this.future = null;
            }
            this.bucketIds = null;
        }

        public synchronized boolean refresh() {
            Collection<KUID> list = BucketRefresher.this.context.getRouteTable().getRefreshIDs(false);
            if (LOG.isInfoEnabled()) {
                LOG.info(BucketRefresher.this.context.getName() + " has " + list.size() + " Buckets to refresh");
            }
            this.bucketIds = list.iterator();
            return this.next();
        }

        private synchronized boolean next() {
            if (this.isDone()) {
                if (LOG.isInfoEnabled()) {
                    LOG.info(BucketRefresher.this.context.getName() + " finished Bucket refreshes");
                }
                return false;
            }
            KUID lookupId = this.bucketIds.next();
            this.future = BucketRefresher.this.context.lookup(lookupId);
            this.future.addDHTFutureListener(this);
            if (LOG.isInfoEnabled()) {
                LOG.info(BucketRefresher.this.context.getName() + " started a Bucket refresh lookup for " + lookupId);
            }
            return true;
        }

        @Override
        public void handleFutureSuccess(FindNodeResult result) {
            if (LOG.isInfoEnabled()) {
                LOG.info(result);
            }
            if (!this.next()) {
                this.stop();
            }
        }

        @Override
        public void handleExecutionException(ExecutionException e) {
            LOG.error("ExecutionException", e);
            if (!this.next()) {
                this.stop();
            }
        }

        @Override
        public void handleCancellationException(CancellationException e) {
            LOG.debug("CancellationException", e);
            this.stop();
        }

        @Override
        public void handleInterruptedException(InterruptedException e) {
            LOG.debug("InterruptedException", e);
            this.stop();
        }
    }
}

