/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.limewire.io.BadGGEPBlockException;
import org.limewire.io.BadGGEPPropertyException;
import org.limewire.io.IOUtils;
import org.limewire.service.ErrorService;
import org.limewire.util.ByteUtils;
import org.limewire.util.NameValue;
import org.limewire.util.StringUtils;

public class GGEP {
    public static final int MAX_KEY_SIZE_IN_BYTES = 15;
    public static final int MAX_VALUE_SIZE_IN_BYTES = 262143;
    public static final byte GGEP_PREFIX_MAGIC_NUMBER = -61;
    private static final String DEFAULT_ENCODING_CHARSET = "UTF-8";
    private final Map<String, Object> _props = new TreeMap<String, Object>();
    private final boolean useCOBS;
    private volatile int hashCode = 0;

    public GGEP(boolean useCOBS) {
        this.useCOBS = useCOBS;
    }

    public GGEP() {
        this(false);
    }

    public GGEP(byte[] data) throws BadGGEPBlockException {
        this(data, 0);
    }

    public GGEP(byte[] data, int offset) throws BadGGEPBlockException {
        this(data, offset, null);
    }

    public GGEP(byte[] messageBytes, int beginOffset, int[] endOffset) throws BadGGEPBlockException {
        if (messageBytes.length - beginOffset < 4) {
            throw new BadGGEPBlockException();
        }
        if (messageBytes[beginOffset] != -61) {
            throw new BadGGEPBlockException();
        }
        boolean tUseCOBS = false;
        boolean onLastExtension = false;
        int currIndex = beginOffset + 1;
        while (!onLastExtension) {
            try {
                this.sanityCheck(messageBytes[currIndex]);
            }
            catch (ArrayIndexOutOfBoundsException malformedInput) {
                throw new BadGGEPBlockException();
            }
            onLastExtension = this.isLastExtension(messageBytes[currIndex]);
            boolean encoded = this.isEncoded(messageBytes[currIndex]);
            boolean compressed = this.isCompressed(messageBytes[currIndex]);
            int headerLen = this.deriveHeaderLength(messageBytes[currIndex]);
            ++currIndex;
            String extensionHeader = null;
            try {
                extensionHeader = StringUtils.getASCIIString(messageBytes, currIndex, headerLen);
            }
            catch (StringIndexOutOfBoundsException inputIsMalformed) {
                throw new BadGGEPBlockException();
            }
            int[] toIncrement = new int[1];
            int dataLength = this.deriveDataLength(messageBytes, currIndex += headerLen, toIncrement);
            byte[] extensionData = null;
            currIndex += toIncrement[0];
            if (dataLength > 0) {
                byte[] data = new byte[dataLength];
                try {
                    System.arraycopy(messageBytes, currIndex, data, 0, dataLength);
                }
                catch (ArrayIndexOutOfBoundsException malformedInput) {
                    throw new BadGGEPBlockException();
                }
                if (encoded) {
                    tUseCOBS = true;
                    try {
                        data = GGEP.cobsDecode(data);
                    }
                    catch (IOException badCobsEncoding) {
                        throw new BadGGEPBlockException("Bad COBS Encoding");
                    }
                }
                if (compressed) {
                    try {
                        data = IOUtils.inflate(data);
                    }
                    catch (IOException badData) {
                        throw new BadGGEPBlockException("Bad compressed data");
                    }
                }
                extensionData = data;
                currIndex += dataLength;
            }
            if (compressed) {
                this._props.put(extensionHeader, new NeedsCompression(extensionData));
                continue;
            }
            this._props.put(extensionHeader, extensionData);
        }
        if (endOffset != null && endOffset.length > 0) {
            endOffset[0] = currIndex;
        }
        this.useCOBS = tUseCOBS;
    }

    public void merge(GGEP other) {
        this._props.putAll(other._props);
    }

    private void sanityCheck(byte headerFlags) throws BadGGEPBlockException {
        if ((headerFlags & 0x10) != 0) {
            throw new BadGGEPBlockException();
        }
    }

    private boolean isLastExtension(byte headerFlags) {
        boolean retBool = false;
        if ((headerFlags & 0x80) != 0) {
            retBool = true;
        }
        return retBool;
    }

    private boolean isEncoded(byte headerFlags) {
        boolean retBool = false;
        if ((headerFlags & 0x40) != 0) {
            retBool = true;
        }
        return retBool;
    }

    private boolean isCompressed(byte headerFlags) {
        boolean retBool = false;
        if ((headerFlags & 0x20) != 0) {
            retBool = true;
        }
        return retBool;
    }

    private int deriveHeaderLength(byte headerFlags) throws BadGGEPBlockException {
        int retInt = 0;
        retInt = headerFlags & 0xF;
        if (retInt == 0) {
            throw new BadGGEPBlockException();
        }
        return retInt;
    }

    private int deriveDataLength(byte[] buff, int beginOffset, int[] increment) throws BadGGEPBlockException {
        byte currByte;
        int length = 0;
        int iterations = 0;
        int MAX_ITERATIONS = 3;
        do {
            try {
                currByte = buff[beginOffset++];
            }
            catch (ArrayIndexOutOfBoundsException malformedInput) {
                throw new BadGGEPBlockException();
            }
            length = length << 6 | currByte & 0x3F;
            if (++iterations <= 3) continue;
            throw new BadGGEPBlockException();
        } while (64 != (currByte & 0x40));
        increment[0] = iterations;
        return length;
    }

    public void write(OutputStream out) throws IOException {
        if (this.getHeaders().size() > 0) {
            out.write(-61);
            Iterator<String> headers = this.getHeaders().iterator();
            while (headers.hasNext()) {
                String currHeader = headers.next();
                byte[] currData = this.get(currHeader);
                int dataLen = 0;
                boolean shouldEncode = this.shouldCOBSEncode(currData);
                boolean shouldCompress = this.shouldCompress(currHeader);
                if (currData != null) {
                    if (shouldCompress && (currData = IOUtils.deflate(currData)).length > 262143) {
                        throw new IllegalArgumentException("value for [" + currHeader + "] too large after compression");
                    }
                    if (shouldEncode) {
                        currData = GGEP.cobsEncode(currData);
                    }
                    dataLen = currData.length;
                }
                this.writeHeader(currHeader, dataLen, !headers.hasNext(), out, shouldEncode, shouldCompress);
                if (dataLen <= 0) continue;
                out.write(currData);
            }
        }
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.write(out);
        }
        catch (IOException e) {
            ErrorService.error(e);
        }
        return out.toByteArray();
    }

    private final boolean shouldCOBSEncode(byte[] data) {
        return this.useCOBS && this.containsNull(data);
    }

    private final boolean shouldCompress(String header) {
        return this._props.get(header) instanceof NeedsCompression;
    }

    private void writeHeader(String header, int dataLen, boolean isLast, OutputStream out, boolean isEncoded, boolean isCompressed) throws IOException {
        int toWrite;
        byte[] headerBytes = StringUtils.toAsciiBytes(header);
        int flags = 0;
        if (isLast) {
            flags |= 0x80;
        }
        if (isEncoded) {
            flags |= 0x40;
        }
        if (isCompressed) {
            flags |= 0x20;
        }
        out.write(flags |= headerBytes.length);
        out.write(headerBytes);
        int begin = dataLen & 0x3F000;
        if (dataLen > 4095) {
            toWrite = 0x80 | (begin >>= 12);
            out.write(toWrite);
        }
        int middle = dataLen & 0xFC0;
        if (dataLen > 63) {
            toWrite = 0x80 | (middle >>= 6);
            out.write(toWrite);
        }
        int end = dataLen & 0x3F;
        toWrite = 0x40 | end;
        out.write(toWrite);
    }

    public int getHeaderOverhead(String key) {
        byte[] data = this.get(key);
        if (data == null) {
            throw new IllegalArgumentException("no data for key: " + key);
        }
        return 1 + key.length() + data.length + 1 + (data.length > 63 ? 1 : 0) + (data.length > 4095 ? 1 : 0);
    }

    public void putAll(List<? extends NameValue<?>> fields) throws IllegalArgumentException {
        for (NameValue<?> next : fields) {
            String key = next.getName();
            Object value = next.getValue();
            if (value == null) {
                this.put(key);
                continue;
            }
            if (value instanceof byte[]) {
                this.put(key, (byte[])value);
                continue;
            }
            if (value instanceof String) {
                this.put(key, (String)value);
                continue;
            }
            if (value instanceof Integer) {
                this.put(key, (Integer)value);
                continue;
            }
            if (value instanceof Long) {
                this.put(key, (Long)value);
                continue;
            }
            if (value instanceof Byte) {
                this.put(key, (Byte)value);
                continue;
            }
            throw new IllegalArgumentException("Unknown value: " + value);
        }
    }

    public void putCompressed(String key, byte[] value) throws IllegalArgumentException {
        this.validateKey(key);
        if (value == null) {
            throw new IllegalArgumentException("null value for key: " + key);
        }
        this._props.put(key, new NeedsCompression(value));
    }

    public void put(String key, byte value) throws IllegalArgumentException {
        this.put(key, new byte[]{value});
    }

    public void put(String key, byte[] value) throws IllegalArgumentException {
        this.validateKey(key);
        this.validateValue(value, key);
        this._props.put(key, value);
    }

    public void put(String key, String value) throws IllegalArgumentException {
        this.put(key, value, DEFAULT_ENCODING_CHARSET);
    }

    private void put(String key, String value, String charSetName) throws IllegalArgumentException {
        try {
            this.put(key, value == null ? null : value.getBytes(charSetName));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Unsupported character set for String encoding", e);
        }
    }

    public void put(String key, int value) throws IllegalArgumentException {
        if (value < 0) {
            throw new IllegalArgumentException("Negative value: " + value + " for key: " + key);
        }
        this.put(key, ByteUtils.int2minLeb(value));
    }

    public void put(String key, long value) throws IllegalArgumentException {
        if (value < 0L) {
            throw new IllegalArgumentException("Negative value: " + value + " for key: " + key);
        }
        this.put(key, ByteUtils.long2minLeb(value));
    }

    public void put(String key) throws IllegalArgumentException {
        this.validateKey(key);
        this._props.put(key, null);
    }

    public byte[] getBytes(String key) throws BadGGEPPropertyException {
        byte[] ret = this.get(key);
        if (ret == null) {
            throw new BadGGEPPropertyException();
        }
        return ret;
    }

    public String getString(String key) throws BadGGEPPropertyException {
        return this.getString(key, DEFAULT_ENCODING_CHARSET);
    }

    private String getString(String key, String encoding) throws BadGGEPPropertyException, IllegalArgumentException {
        try {
            return new String(this.getBytes(key), encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Cannot get GGEP key value as String due to unsupported encoding", e);
        }
    }

    public int getInt(String key) throws BadGGEPPropertyException {
        byte[] bytes = this.getBytes(key);
        if (bytes.length < 1) {
            throw new BadGGEPPropertyException("No bytes");
        }
        if (bytes.length > 4) {
            throw new BadGGEPPropertyException("Integer too big");
        }
        return ByteUtils.leb2int(bytes, 0, bytes.length);
    }

    public long getLong(String key) throws BadGGEPPropertyException {
        byte[] bytes = this.getBytes(key);
        if (bytes.length < 1) {
            throw new BadGGEPPropertyException("No bytes");
        }
        if (bytes.length > 8) {
            throw new BadGGEPPropertyException("Integer too big");
        }
        return ByteUtils.leb2long(bytes, 0, bytes.length);
    }

    public boolean hasKey(String key) {
        return this._props.containsKey(key);
    }

    public boolean hasValueFor(String key) {
        return this.get(key) != null;
    }

    public Set<String> getHeaders() {
        return this._props.keySet();
    }

    public boolean isEmpty() {
        return this._props.isEmpty();
    }

    public byte[] get(String key) {
        Object value = this._props.get(key);
        if (value instanceof NeedsCompression) {
            return ((NeedsCompression)value).data;
        }
        return (byte[])value;
    }

    private void validateKey(String key) throws IllegalArgumentException {
        if (!StringUtils.isAsciiOnly(key)) {
            throw new IllegalArgumentException("key is not ascii only: " + key);
        }
        byte[] bytes = StringUtils.toAsciiBytes(key);
        if (key.equals("") || bytes.length > 15 || this.containsNull(bytes)) {
            throw new IllegalArgumentException("invalid key: " + key);
        }
    }

    private void validateValue(byte[] value, String key) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("null value for key: " + key);
        }
        if (value.length > 262143) {
            throw new IllegalArgumentException("value (" + value + ") too large for key: " + key);
        }
    }

    private boolean containsNull(byte[] bytes) {
        if (bytes != null) {
            for (int i = 0; i < bytes.length; ++i) {
                if (bytes[i] != 0) continue;
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GGEP)) {
            return false;
        }
        return this.subset((GGEP)o) && ((GGEP)o).subset(this);
    }

    private boolean subset(GGEP other) {
        for (String key : this._props.keySet()) {
            byte[] v2;
            byte[] v1 = this.get(key);
            if (v1 == null != ((v2 = other.get(key)) == null)) {
                return false;
            }
            if (v1 == null || Arrays.equals(v1, v2)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 37 * ((Object)this._props).hashCode();
        }
        return this.hashCode;
    }

    static byte[] cobsDecode(byte[] src) throws IOException {
        int srcLen = src.length;
        int currIndex = 0;
        int code = 0;
        ByteArrayOutputStream sink = new ByteArrayOutputStream();
        while (currIndex < srcLen) {
            if (currIndex + ((code = ByteUtils.ubyte2int(src[currIndex++])) - 2) >= srcLen) {
                throw new IOException();
            }
            for (int i = 1; i < code; ++i) {
                sink.write(src[currIndex++]);
            }
            if (currIndex >= srcLen || code >= 255) continue;
            sink.write(0);
        }
        return sink.toByteArray();
    }

    static int cobsFinishBlock(int code, ByteArrayOutputStream sink, byte[] src, int begin, int end) {
        sink.write(code);
        if (begin > -1) {
            sink.write(src, begin, end - begin + 1);
        }
        return 1;
    }

    static byte[] cobsEncode(byte[] src) {
        int currIndex;
        int srcLen = src.length;
        int code = 1;
        int maxEncodingLen = src.length + (src.length + 1) / 254 + 1;
        ByteArrayOutputStream sink = new ByteArrayOutputStream(maxEncodingLen);
        int writeStartIndex = -1;
        for (currIndex = 0; currIndex < srcLen; ++currIndex) {
            if (src[currIndex] == 0) {
                code = GGEP.cobsFinishBlock(code, sink, src, writeStartIndex, currIndex - 1);
                writeStartIndex = -1;
                continue;
            }
            if (writeStartIndex < 0) {
                writeStartIndex = currIndex;
            }
            if (++code != 255) continue;
            code = GGEP.cobsFinishBlock(code, sink, src, writeStartIndex, currIndex);
            writeStartIndex = -1;
        }
        GGEP.cobsFinishBlock(code, sink, src, writeStartIndex, currIndex - 1);
        return sink.toByteArray();
    }

    private static class NeedsCompression {
        final byte[] data;

        NeedsCompression(byte[] data) {
            this.data = data;
        }
    }
}

