/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.impl.browse;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.SearchServices;
import com.limegroup.gnutella.messages.QueryReply;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.limewire.core.api.browse.Browse;
import org.limewire.core.api.browse.BrowseListener;
import org.limewire.core.api.search.SearchResult;
import org.limewire.core.impl.search.QueryReplyListener;
import org.limewire.core.impl.search.QueryReplyListenerList;
import org.limewire.core.impl.search.RemoteFileDescAdapter;
import org.limewire.friend.api.FriendPresence;
import org.limewire.io.GUID;
import org.limewire.io.IpPort;
import org.limewire.util.Objects;

class CoreBrowse
implements Browse {
    private final SearchServices searchServices;
    private final FriendPresence friendPresence;
    private final QueryReplyListenerList listenerList;
    private final RemoteFileDescAdapter.Factory remoteFileDescAdapterFactory;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final AtomicBoolean stopped = new AtomicBoolean(false);
    private volatile byte[] browseGuid;
    private volatile BrowseResultAdapter listener;

    @Inject
    public CoreBrowse(@Assisted FriendPresence friendPresence, SearchServices searchServices, QueryReplyListenerList listenerList, RemoteFileDescAdapter.Factory remoteFileDescAdapterFactory) {
        this.friendPresence = Objects.nonNull(friendPresence, "friendPresence");
        this.searchServices = searchServices;
        this.listenerList = listenerList;
        this.remoteFileDescAdapterFactory = remoteFileDescAdapterFactory;
    }

    @Override
    public void start(BrowseListener browseListener) {
        if (this.started.getAndSet(true)) {
            throw new IllegalStateException("already started!");
        }
        this.browseGuid = this.searchServices.newQueryGUID();
        this.listener = new BrowseResultAdapter(browseListener);
        this.listenerList.addQueryReplyListener(this.browseGuid, this.listener);
        this.searchServices.doAsynchronousBrowseHost(this.friendPresence, new GUID(this.browseGuid), new ListenerProxy(browseListener));
    }

    @Override
    public void stop() {
        if (!this.stopped.getAndSet(true) && this.listener != null) {
            this.listener.browseListener.browseFinished(false);
        }
        this.listenerList.removeQueryReplyListener(this.browseGuid, this.listener);
        this.searchServices.stopQuery(new GUID(this.browseGuid));
    }

    private class BrowseResultAdapter
    implements QueryReplyListener {
        private final BrowseListener browseListener;

        public BrowseResultAdapter(BrowseListener browseListener) {
            this.browseListener = browseListener;
        }

        @Override
        public void handleQueryReply(RemoteFileDesc rfd, QueryReply queryReply, Set<? extends IpPort> locs) {
            this.browseListener.handleBrowseResult(CoreBrowse.this.remoteFileDescAdapterFactory.create(rfd, locs));
        }
    }

    private class ListenerProxy
    implements BrowseListener {
        private final BrowseListener delegate;

        public ListenerProxy(BrowseListener delegate) {
            this.delegate = delegate;
        }

        @Override
        public void browseFinished(boolean success) {
            if (!CoreBrowse.this.stopped.getAndSet(true)) {
                this.delegate.browseFinished(success);
            }
            CoreBrowse.this.stop();
        }

        @Override
        public void handleBrowseResult(SearchResult searchResult) {
            if (!CoreBrowse.this.stopped.get()) {
                this.delegate.handleBrowseResult(searchResult);
            }
        }
    }
}

