/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.util.Iterator;

public class DualIterator<T>
implements Iterator<T> {
    private final Iterator<T> i1;
    private final Iterator<T> i2;
    private boolean onOne;

    public DualIterator(Iterator<T> a, Iterator<T> b) {
        this.i1 = a;
        this.i2 = b;
        this.onOne = true;
    }

    @Override
    public boolean hasNext() {
        return this.i1.hasNext() || this.i2.hasNext();
    }

    @Override
    public T next() {
        if (this.i1.hasNext()) {
            return this.i1.next();
        }
        this.onOne = false;
        return this.i2.next();
    }

    @Override
    public void remove() {
        if (this.onOne) {
            this.i1.remove();
        } else {
            this.i2.remove();
        }
    }
}

